/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.stewardshipaction.fvt.clientconstructors;

import org.odpi.openmetadata.accessservices.stewardshipaction.client.StewardshipAction;
import org.odpi.openmetadata.accessservices.stewardshipaction.client.rest.StewardshipActionRESTClient;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.auditlog.AuditLogDestination;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException;
import org.odpi.openmetadata.fvt.utilities.FVTResults;
import org.odpi.openmetadata.fvt.utilities.auditlog.FVTAuditLogDestination;

public class ClientConstructorTest {
    private static final String testCaseName = "ClientConstructorTest";
    private static final String serverUserId = "TestNPA";
    private static final String serverPassword = "TestNPAPassword";
    private static final int maxPageSize = 100;

    public static FVTResults performFVT(String serverName, String serverPlatformRootURL) {
        FVTResults results = new FVTResults(testCaseName);
        results.incrementNumberOfTests();
        try {
            ClientConstructorTest.runIt(serverPlatformRootURL, serverName, results.getAuditLogDestination());
            results.incrementNumberOfSuccesses();
        }
        catch (Exception error) {
            results.addCapturedError(error);
        }
        return results;
    }

    private static void runIt(String serverPlatformRootURL, String serverName, FVTAuditLogDestination auditLogDestination) throws InvalidParameterException {
        ClientConstructorTest thisTest = new ClientConstructorTest();
        AuditLog auditLog = new AuditLog((AuditLogDestination)auditLogDestination, AccessServiceDescription.STEWARDSHIP_ACTION_OMAS.getAccessServiceCode(), AccessServiceDescription.STEWARDSHIP_ACTION_OMAS.getAccessServiceDevelopmentStatus(), AccessServiceDescription.STEWARDSHIP_ACTION_OMAS.getAccessServiceName(), AccessServiceDescription.STEWARDSHIP_ACTION_OMAS.getAccessServiceDescription(), AccessServiceDescription.STEWARDSHIP_ACTION_OMAS.getAccessServiceWiki());
        thisTest.testStewardshipActionClient(serverName, serverPlatformRootURL, auditLog);
    }

    private void testStewardshipActionClient(String serverName, String serverPlatformRootURL, AuditLog auditLog) throws InvalidParameterException {
        new StewardshipAction(serverName, serverPlatformRootURL, auditLog, 100);
        new StewardshipAction(serverName, serverPlatformRootURL, 100);
        new StewardshipAction(serverName, serverPlatformRootURL, serverUserId, serverPassword, auditLog, 100);
        new StewardshipAction(serverName, serverPlatformRootURL, serverUserId, serverPassword, 100);
        StewardshipActionRESTClient restClient = new StewardshipActionRESTClient(serverName, serverPlatformRootURL);
        new StewardshipAction(serverName, serverPlatformRootURL, restClient, 100, auditLog);
    }
}

