/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.stewardshipaction.server;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.accessservices.stewardshipaction.converters.ElementStubConverter;
import org.odpi.openmetadata.accessservices.stewardshipaction.metadataelements.DuplicateElement;
import org.odpi.openmetadata.accessservices.stewardshipaction.metadataelements.ElementStub;
import org.odpi.openmetadata.accessservices.stewardshipaction.properties.DuplicateProperties;
import org.odpi.openmetadata.accessservices.stewardshipaction.rest.DuplicatesRequestBody;
import org.odpi.openmetadata.accessservices.stewardshipaction.rest.DuplicatesResponse;
import org.odpi.openmetadata.accessservices.stewardshipaction.rest.ElementStubResponse;
import org.odpi.openmetadata.accessservices.stewardshipaction.rest.ElementStubsResponse;
import org.odpi.openmetadata.accessservices.stewardshipaction.server.StewardshipActionInstanceHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.ConnectionResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.slf4j.LoggerFactory;

public class StewardshipActionRESTServices {
    private static StewardshipActionInstanceHandler instanceHandler = new StewardshipActionInstanceHandler();
    private static RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(StewardshipActionRESTServices.class), instanceHandler.getServiceName());
    private RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();

    public ConnectionResponse getOutTopicConnection(String serverName, String userId, String callerId) {
        String methodName = "getOutTopicConnection";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getOutTopicConnection");
        ConnectionResponse response = new ConnectionResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getOutTopicConnection");
            response.setConnection(instanceHandler.getOutTopicConnection(userId, serverName, "getOutTopicConnection", callerId));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getOutTopicConnection", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse linkElementsAsDuplicates(String serverName, String userId, String element1GUID, String element2GUID, DuplicatesRequestBody requestBody) {
        String methodName = "linkElementsAsDuplicates";
        String element1GUIDParameterName = "element1GUID";
        String element2GUIDParameterName = "element2GUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "linkElementsAsDuplicates");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "linkElementsAsDuplicates");
            ReferenceableHandler<ElementStub> handler = instanceHandler.getReferenceableHandler(userId, serverName, "linkElementsAsDuplicates");
            if (requestBody != null) {
                handler.linkElementsAsPeerDuplicates(userId, element1GUID, "element1GUID", element2GUID, "element2GUID", false, requestBody.getStatusIdentifier(), requestBody.getSteward(), requestBody.getStewardTypeName(), requestBody.getStewardPropertyName(), requestBody.getSource(), requestBody.getNotes(), "linkElementsAsDuplicates");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "linkElementsAsDuplicates", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "linkElementsAsDuplicates", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse unlinkElementsAsDuplicates(String serverName, String userId, String element1GUID, String element2GUID, NullRequestBody requestBody) {
        String methodName = "unlinkElementsAsDuplicates";
        String element1GUIDParameter = "element1GUID";
        String element2GUIDParameter = "element2GUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "unlinkElementsAsDuplicates");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "unlinkElementsAsDuplicates");
            ReferenceableHandler<ElementStub> handler = instanceHandler.getReferenceableHandler(userId, serverName, "unlinkElementsAsDuplicates");
            handler.unlinkElementsAsPeerDuplicates(userId, element1GUID, "element1GUID", element2GUID, "element2GUID", null, "unlinkElementsAsDuplicates");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "unlinkElementsAsDuplicates", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse markElementAsKnownDuplicate(String serverName, String userId, String elementGUID, NullRequestBody requestBody) {
        String methodName = "markElementAsKnownDuplicate";
        String elementGUIDParameter = "elementGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "markElementAsKnownDuplicate");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "markElementAsKnownDuplicate");
            ReferenceableHandler<ElementStub> handler = instanceHandler.getReferenceableHandler(userId, serverName, "markElementAsKnownDuplicate");
            handler.setClassificationInRepository(userId, null, null, elementGUID, "elementGUID", "Referenceable", "e55062b2-907f-44bd-9831-255642285731", "KnownDuplicate", null, false, true, true, null, "markElementAsKnownDuplicate");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "markElementAsKnownDuplicate", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse unmarkElementAsKnownDuplicate(String serverName, String userId, String elementGUID, NullRequestBody requestBody) {
        String methodName = "unmarkElementAsKnownDuplicate";
        String elementGUIDParameter = "elementGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "unmarkElementAsKnownDuplicate");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "unmarkElementAsKnownDuplicate");
            ReferenceableHandler<ElementStub> handler = instanceHandler.getReferenceableHandler(userId, serverName, "unmarkElementAsKnownDuplicate");
            handler.removeClassificationFromRepository(userId, null, null, elementGUID, "elementGUID", "Referenceable", "e55062b2-907f-44bd-9831-255642285731", "KnownDuplicate", true, true, null, "unmarkElementAsKnownDuplicate");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "unmarkElementAsKnownDuplicate", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DuplicatesResponse getPeerDuplicates(String serverName, String userId, String elementGUID, int startFrom, int pageSize) {
        String methodName = "getPeerDuplicates";
        String guidParameterName = "elementGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getPeerDuplicates");
        DuplicatesResponse response = new DuplicatesResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getPeerDuplicates");
            ReferenceableHandler<ElementStub> handler = instanceHandler.getReferenceableHandler(userId, serverName, "getPeerDuplicates");
            List relationships = handler.getAttachmentLinks(userId, elementGUID, "elementGUID", "Referenceable", "a94b2929-9e62-4b12-98ab-8ac45691e5bd", "PeerDuplicateLink", null, "Referenceable", 0, true, startFrom, pageSize, null, "getPeerDuplicates");
            ArrayList<DuplicateElement> results = new ArrayList<DuplicateElement>();
            if (relationships != null) {
                ElementStubConverter<ElementStub> converter = instanceHandler.getElementStubConverter(userId, serverName, "getPeerDuplicates");
                for (Relationship relationship : relationships) {
                    if (relationship == null) continue;
                    DuplicateElement duplicateElement = new DuplicateElement();
                    duplicateElement.setElementHeader(converter.getMetadataElementHeader(ElementStub.class, (InstanceHeader)relationship, null, "getPeerDuplicates"));
                    if (relationship.getProperties() != null) {
                        DuplicateProperties duplicateProperties = new DuplicateProperties();
                        OMRSRepositoryHelper repositoryHelper = instanceHandler.getRepositoryHelper(userId, serverName, "getPeerDuplicates");
                        duplicateProperties.setStatusIdentifier(repositoryHelper.getIntProperty(instanceHandler.getServiceName(), "statusIdentifier", relationship.getProperties(), "getPeerDuplicates"));
                        duplicateProperties.setSteward(repositoryHelper.getStringProperty(instanceHandler.getServiceName(), "steward", relationship.getProperties(), "getPeerDuplicates"));
                        duplicateProperties.setStewardTypeName(repositoryHelper.getStringProperty(instanceHandler.getServiceName(), "stewardTypeName", relationship.getProperties(), "getPeerDuplicates"));
                        duplicateProperties.setStewardPropertyName(repositoryHelper.getStringProperty(instanceHandler.getServiceName(), "stewardPropertyName", relationship.getProperties(), "getPeerDuplicates"));
                        duplicateProperties.setSource(repositoryHelper.getStringProperty(instanceHandler.getServiceName(), "source", relationship.getProperties(), "getPeerDuplicates"));
                        duplicateProperties.setNotes(repositoryHelper.getStringProperty(instanceHandler.getServiceName(), "notes", relationship.getProperties(), "getPeerDuplicates"));
                        EntityProxy peerProxy = relationship.getEntityOneProxy();
                        if (elementGUID.equals(peerProxy.getGUID())) {
                            peerProxy = relationship.getEntityTwoProxy();
                        }
                        duplicateProperties.setDuplicateElement(converter.getNewBean(ElementStub.class, peerProxy, "getPeerDuplicates"));
                        duplicateElement.setDuplicateProperties(duplicateProperties);
                    }
                    results.add(duplicateElement);
                }
            }
            if (!results.isEmpty()) {
                response.setElementList(results);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getPeerDuplicates", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse markAsConsolidatedDuplicate(String serverName, String userId, String consolidatedDuplicateGUID, DuplicatesRequestBody requestBody) {
        String methodName = "markAsConsolidatedDuplicate";
        String elementGUIDParameter = "consolidatedDuplicateGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "markAsConsolidatedDuplicate");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "markAsConsolidatedDuplicate");
            ReferenceableHandler<ElementStub> handler = instanceHandler.getReferenceableHandler(userId, serverName, "markAsConsolidatedDuplicate");
            if (requestBody != null) {
                OMRSRepositoryHelper repositoryHelper = instanceHandler.getRepositoryHelper(userId, serverName, "markAsConsolidatedDuplicate");
                InstanceProperties properties = repositoryHelper.addIntPropertyToInstance(instanceHandler.getServiceName(), null, "statusIdentifier", requestBody.getStatusIdentifier(), "markAsConsolidatedDuplicate");
                properties = repositoryHelper.addStringPropertyToInstance(instanceHandler.getServiceName(), properties, "steward", requestBody.getSteward(), "markAsConsolidatedDuplicate");
                properties = repositoryHelper.addStringPropertyToInstance(instanceHandler.getServiceName(), properties, "stewardTypeName", requestBody.getStewardTypeName(), "markAsConsolidatedDuplicate");
                properties = repositoryHelper.addStringPropertyToInstance(instanceHandler.getServiceName(), properties, "stewardPropertyName", requestBody.getStewardPropertyName(), "markAsConsolidatedDuplicate");
                properties = repositoryHelper.addStringPropertyToInstance(instanceHandler.getServiceName(), properties, "source", requestBody.getSource(), "markAsConsolidatedDuplicate");
                properties = repositoryHelper.addStringPropertyToInstance(instanceHandler.getServiceName(), properties, "notes", requestBody.getNotes(), "markAsConsolidatedDuplicate");
                handler.setClassificationInRepository(userId, null, null, consolidatedDuplicateGUID, "consolidatedDuplicateGUID", "Referenceable", "a1fabffd-d6ec-4b2d-bfe4-646f27c07c82", "ConsolidatedDuplicateLink", properties, false, true, true, null, "markAsConsolidatedDuplicate");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "markAsConsolidatedDuplicate", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "markAsConsolidatedDuplicate", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse linkElementToConsolidatedDuplicate(String serverName, String userId, String consolidatedDuplicateGUID, String contributingElementGUID, NullRequestBody requestBody) {
        String methodName = "linkElementToConsolidatedDuplicate";
        String element1GUIDParameter = "consolidatedDuplicateGUID";
        String element2GUIDParameter = "contributingElementGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "linkElementToConsolidatedDuplicate");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "linkElementToConsolidatedDuplicate");
            ReferenceableHandler<ElementStub> handler = instanceHandler.getReferenceableHandler(userId, serverName, "linkElementToConsolidatedDuplicate");
            handler.linkElementToElement(userId, null, null, consolidatedDuplicateGUID, "consolidatedDuplicateGUID", "Referenceable", contributingElementGUID, "contributingElementGUID", "Referenceable", true, true, "a1fabffd-d6ec-4b2d-bfe4-646f27c07c82", "ConsolidatedDuplicateLink", null, "linkElementToConsolidatedDuplicate");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "linkElementToConsolidatedDuplicate", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse unlinkElementFromConsolidatedDuplicate(String serverName, String userId, String consolidatedDuplicateGUID, String contributingElementGUID, NullRequestBody requestBody) {
        String methodName = "unlinkElementFromConsolidatedDuplicate";
        String element1GUIDParameter = "consolidatedDuplicateGUID";
        String element2GUIDParameter = "contributingElementGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "unlinkElementFromConsolidatedDuplicate");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "unlinkElementFromConsolidatedDuplicate");
            ReferenceableHandler<ElementStub> handler = instanceHandler.getReferenceableHandler(userId, serverName, "unlinkElementFromConsolidatedDuplicate");
            handler.unlinkElementFromElement(userId, false, null, null, consolidatedDuplicateGUID, "consolidatedDuplicateGUID", "Referenceable", contributingElementGUID, "contributingElementGUID", "a32316b8-dc8c-48c5-b12b-71c1b2a080bf", "Referenceable", true, true, "a1fabffd-d6ec-4b2d-bfe4-646f27c07c82", "ConsolidatedDuplicateLink", null, "unlinkElementFromConsolidatedDuplicate");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "unlinkElementFromConsolidatedDuplicate", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ElementStubsResponse getContributingDuplicates(String serverName, String userId, String consolidatedDuplicateGUID, int startFrom, int pageSize) {
        String methodName = "getContributingDuplicates";
        String guidParameterName = "consolidatedDuplicateGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getContributingDuplicates");
        ElementStubsResponse response = new ElementStubsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getContributingDuplicates");
            ReferenceableHandler<ElementStub> handler = instanceHandler.getReferenceableHandler(userId, serverName, "getContributingDuplicates");
            List elementStubs = handler.getAttachedElements(userId, consolidatedDuplicateGUID, "consolidatedDuplicateGUID", "Referenceable", "a1fabffd-d6ec-4b2d-bfe4-646f27c07c82", "ConsolidatedDuplicateLink", "Referenceable", null, null, 1, true, true, startFrom, pageSize, null, "getContributingDuplicates");
            response.setElements(elementStubs);
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getContributingDuplicates", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ElementStubResponse getConsolidatedDuplicate(String serverName, String userId, String elementGUID) {
        String methodName = "getConsolidatedDuplicate";
        String guidParameterName = "elementGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getConsolidatedDuplicate");
        ElementStubResponse response = new ElementStubResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getConsolidatedDuplicate");
            ReferenceableHandler<ElementStub> handler = instanceHandler.getReferenceableHandler(userId, serverName, "getConsolidatedDuplicate");
            Relationship relationship = handler.getUniqueAttachmentLink(userId, elementGUID, "elementGUID", "Referenceable", "a1fabffd-d6ec-4b2d-bfe4-646f27c07c82", "ConsolidatedDuplicateLink", null, "Referenceable", 2, true, null, "getConsolidatedDuplicate");
            if (relationship != null) {
                ElementStubConverter<ElementStub> converter = instanceHandler.getElementStubConverter(userId, serverName, "getConsolidatedDuplicate");
                ElementStub elementStub = converter.getNewBean(ElementStub.class, relationship.getEntityTwoProxy(), "getConsolidatedDuplicate");
                response.setElement(elementStub);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getConsolidatedDuplicate", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeConsolidatedDuplicate(String serverName, String userId, String consolidatedDuplicateGUID, NullRequestBody requestBody) {
        String methodName = "removeConsolidatedDuplicate";
        String element1GUIDParameter = "consolidatedDuplicateGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeConsolidatedDuplicate");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeConsolidatedDuplicate");
            ReferenceableHandler<ElementStub> handler = instanceHandler.getReferenceableHandler(userId, serverName, "removeConsolidatedDuplicate");
            handler.deleteBeanInRepository(userId, null, null, consolidatedDuplicateGUID, "consolidatedDuplicateGUID", "a32316b8-dc8c-48c5-b12b-71c1b2a080bf", "Referenceable", null, null, true, true, null, "removeConsolidatedDuplicate");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "removeConsolidatedDuplicate", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

