/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.stewardshipaction.converters;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.accessservices.stewardshipaction.converters.StewardshipActionOMASConverter;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementStub;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class ElementStubConverter<B>
extends StewardshipActionOMASConverter<B> {
    public ElementStubConverter(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
    }

    public B getNewBean(Class<B> beanClass, EntityProxy entityProxy, String methodName) throws PropertyServerException {
        try {
            Object returnBean = beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (returnBean instanceof ElementStub) {
                returnBean = super.getElementStub(beanClass, entityProxy, methodName);
                return returnBean;
            }
            return null;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }

    public B getNewBean(Class<B> beanClass, Relationship relationship, boolean useEnd1, String methodName) throws PropertyServerException {
        if (relationship != null) {
            if (useEnd1) {
                return this.getNewBean(beanClass, relationship.getEntityOneProxy(), methodName);
            }
            return this.getNewBean(beanClass, relationship.getEntityTwoProxy(), methodName);
        }
        return null;
    }

    public List<B> getNewBeans(Class<B> beanClass, List<Relationship> relationships, boolean useEnd1, String methodName) throws PropertyServerException {
        if (relationships != null) {
            ArrayList<B> beans = new ArrayList<B>();
            for (Relationship relationship : relationships) {
                B bean;
                if (relationship == null || (bean = this.getNewBean(beanClass, relationship, useEnd1, methodName)) == null) continue;
                beans.add(bean);
            }
            if (!beans.isEmpty()) {
                return beans;
            }
        }
        return null;
    }

    public B getNewBean(Class<B> beanClass, EntityDetail entity, String methodName) throws PropertyServerException {
        try {
            Object returnBean = beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            EntityProxy entityProxy = this.repositoryHelper.getNewEntityProxy(this.serviceName, entity);
            if (returnBean instanceof ElementStub) {
                returnBean = super.getElementStub(beanClass, entityProxy, methodName);
                return returnBean;
            }
            return null;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
        }
        catch (Exception error) {
            super.handleBadEntity(beanClass.getName(), entity, methodName);
        }
        return null;
    }

    public B getNewBean(Class<B> beanClass, EntityDetail entity, Relationship relationship, String methodName) throws PropertyServerException {
        return this.getNewBean(beanClass, entity, methodName);
    }
}

