/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.stewardshipaction.server;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.accessservices.stewardshipaction.server.StewardshipActionInstanceHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.DuplicatesRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.DuplicatesResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.ElementStubResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.ElementStubsResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.OCFConnectionResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.commonservices.generichandlers.ElementStubConverter;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.DuplicateElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ElementStub;
import org.odpi.openmetadata.frameworks.openmetadata.properties.governance.DuplicateProperties;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.slf4j.LoggerFactory;

public class StewardshipActionRESTServices {
    private static final StewardshipActionInstanceHandler instanceHandler = new StewardshipActionInstanceHandler();
    private static final RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(StewardshipActionRESTServices.class), instanceHandler.getServiceName());
    private final RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();

    public OCFConnectionResponse getOutTopicConnection(String serverName, String userId, String callerId) {
        String methodName = "getOutTopicConnection";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getOutTopicConnection");
        OCFConnectionResponse response = new OCFConnectionResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getOutTopicConnection");
            response.setConnection(instanceHandler.getOutTopicConnection(userId, serverName, "getOutTopicConnection", callerId));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getOutTopicConnection", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse linkElementsAsDuplicates(String serverName, String userId, String element1GUID, String element2GUID, DuplicatesRequestBody requestBody) {
        String methodName = "linkElementsAsDuplicates";
        String element1GUIDParameterName = "element1GUID";
        String element2GUIDParameterName = "element2GUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "linkElementsAsDuplicates");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "linkElementsAsDuplicates");
            ReferenceableHandler<ElementStub> handler = instanceHandler.getReferenceableHandler(userId, serverName, "linkElementsAsDuplicates");
            if (requestBody != null) {
                handler.linkElementsAsPeerDuplicates(userId, element1GUID, "element1GUID", element2GUID, "element2GUID", false, requestBody.getStatusIdentifier(), requestBody.getSteward(), requestBody.getStewardTypeName(), requestBody.getStewardPropertyName(), requestBody.getSource(), requestBody.getNotes(), instanceHandler.getSupportedZones(userId, serverName, "linkElementsAsDuplicates"), "linkElementsAsDuplicates");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "linkElementsAsDuplicates", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "linkElementsAsDuplicates", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse unlinkElementsAsDuplicates(String serverName, String userId, String element1GUID, String element2GUID, NullRequestBody requestBody) {
        String methodName = "unlinkElementsAsDuplicates";
        String element1GUIDParameter = "element1GUID";
        String element2GUIDParameter = "element2GUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "unlinkElementsAsDuplicates");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "unlinkElementsAsDuplicates");
            ReferenceableHandler<ElementStub> handler = instanceHandler.getReferenceableHandler(userId, serverName, "unlinkElementsAsDuplicates");
            handler.unlinkElementsAsPeerDuplicates(userId, element1GUID, "element1GUID", element2GUID, "element2GUID", instanceHandler.getSupportedZones(userId, serverName, "unlinkElementsAsDuplicates"), "unlinkElementsAsDuplicates");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "unlinkElementsAsDuplicates", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse markElementAsKnownDuplicate(String serverName, String userId, String elementGUID, NullRequestBody requestBody) {
        String methodName = "markElementAsKnownDuplicate";
        String elementGUIDParameter = "elementGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "markElementAsKnownDuplicate");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "markElementAsKnownDuplicate");
            ReferenceableHandler<ElementStub> handler = instanceHandler.getReferenceableHandler(userId, serverName, "markElementAsKnownDuplicate");
            handler.setClassificationInRepository(userId, null, null, elementGUID, "elementGUID", OpenMetadataType.REFERENCEABLE.typeName, "e55062b2-907f-44bd-9831-255642285731", "KnownDuplicate", null, false, true, true, instanceHandler.getSupportedZones(userId, serverName, "markElementAsKnownDuplicate"), null, "markElementAsKnownDuplicate");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "markElementAsKnownDuplicate", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse unmarkElementAsKnownDuplicate(String serverName, String userId, String elementGUID, NullRequestBody requestBody) {
        String methodName = "unmarkElementAsKnownDuplicate";
        String elementGUIDParameter = "elementGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "unmarkElementAsKnownDuplicate");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "unmarkElementAsKnownDuplicate");
            ReferenceableHandler<ElementStub> handler = instanceHandler.getReferenceableHandler(userId, serverName, "unmarkElementAsKnownDuplicate");
            handler.removeClassificationFromRepository(userId, null, null, elementGUID, "elementGUID", OpenMetadataType.REFERENCEABLE.typeName, "e55062b2-907f-44bd-9831-255642285731", "KnownDuplicate", true, true, instanceHandler.getSupportedZones(userId, serverName, "unmarkElementAsKnownDuplicate"), null, "unmarkElementAsKnownDuplicate");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "unmarkElementAsKnownDuplicate", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DuplicatesResponse getPeerDuplicates(String serverName, String userId, String elementGUID, int startFrom, int pageSize) {
        String methodName = "getPeerDuplicates";
        String guidParameterName = "elementGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getPeerDuplicates");
        DuplicatesResponse response = new DuplicatesResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getPeerDuplicates");
            ReferenceableHandler<ElementStub> handler = instanceHandler.getReferenceableHandler(userId, serverName, "getPeerDuplicates");
            List relationships = handler.getAttachmentLinks(userId, elementGUID, "elementGUID", OpenMetadataType.REFERENCEABLE.typeName, "a94b2929-9e62-4b12-98ab-8ac45691e5bd", "PeerDuplicateLink", null, OpenMetadataType.REFERENCEABLE.typeName, 0, null, null, SequencingOrder.CREATION_DATE_RECENT, null, true, true, instanceHandler.getSupportedZones(userId, serverName, "getPeerDuplicates"), startFrom, pageSize, null, "getPeerDuplicates");
            ArrayList<DuplicateElement> results = new ArrayList<DuplicateElement>();
            if (relationships != null) {
                ElementStubConverter<ElementStub> converter = instanceHandler.getElementStubConverter(userId, serverName, "getPeerDuplicates");
                for (Relationship relationship : relationships) {
                    if (relationship == null) continue;
                    DuplicateElement duplicateElement = new DuplicateElement();
                    duplicateElement.setElementHeader(converter.getMetadataElementHeader(ElementStub.class, (InstanceHeader)relationship, null, "getPeerDuplicates"));
                    if (relationship.getProperties() != null) {
                        DuplicateProperties duplicateProperties = new DuplicateProperties();
                        OMRSRepositoryHelper repositoryHelper = instanceHandler.getRepositoryHelper(userId, serverName, "getPeerDuplicates");
                        duplicateProperties.setStatusIdentifier(repositoryHelper.getIntProperty(instanceHandler.getServiceName(), OpenMetadataProperty.STATUS_IDENTIFIER.name, relationship.getProperties(), "getPeerDuplicates"));
                        duplicateProperties.setSteward(repositoryHelper.getStringProperty(instanceHandler.getServiceName(), OpenMetadataProperty.STEWARD.name, relationship.getProperties(), "getPeerDuplicates"));
                        duplicateProperties.setStewardTypeName(repositoryHelper.getStringProperty(instanceHandler.getServiceName(), OpenMetadataProperty.STEWARD_TYPE_NAME.name, relationship.getProperties(), "getPeerDuplicates"));
                        duplicateProperties.setStewardPropertyName(repositoryHelper.getStringProperty(instanceHandler.getServiceName(), OpenMetadataProperty.STEWARD_PROPERTY_NAME.name, relationship.getProperties(), "getPeerDuplicates"));
                        duplicateProperties.setSource(repositoryHelper.getStringProperty(instanceHandler.getServiceName(), OpenMetadataProperty.SOURCE.name, relationship.getProperties(), "getPeerDuplicates"));
                        duplicateProperties.setNotes(repositoryHelper.getStringProperty(instanceHandler.getServiceName(), OpenMetadataProperty.NOTES.name, relationship.getProperties(), "getPeerDuplicates"));
                        EntityProxy peerProxy = relationship.getEntityOneProxy();
                        if (elementGUID.equals(peerProxy.getGUID())) {
                            peerProxy = relationship.getEntityTwoProxy();
                        }
                        duplicateProperties.setDuplicateGUID(peerProxy.getGUID());
                        duplicateElement.setDuplicateProperties(duplicateProperties);
                    }
                    results.add(duplicateElement);
                }
                response.setElements(results);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getPeerDuplicates", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse markAsConsolidatedDuplicate(String serverName, String userId, String consolidatedDuplicateGUID, DuplicatesRequestBody requestBody) {
        String methodName = "markAsConsolidatedDuplicate";
        String elementGUIDParameter = "consolidatedDuplicateGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "markAsConsolidatedDuplicate");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "markAsConsolidatedDuplicate");
            ReferenceableHandler<ElementStub> handler = instanceHandler.getReferenceableHandler(userId, serverName, "markAsConsolidatedDuplicate");
            if (requestBody != null) {
                OMRSRepositoryHelper repositoryHelper = instanceHandler.getRepositoryHelper(userId, serverName, "markAsConsolidatedDuplicate");
                InstanceProperties properties = repositoryHelper.addIntPropertyToInstance(instanceHandler.getServiceName(), null, OpenMetadataProperty.STATUS_IDENTIFIER.name, requestBody.getStatusIdentifier(), "markAsConsolidatedDuplicate");
                properties = repositoryHelper.addStringPropertyToInstance(instanceHandler.getServiceName(), properties, OpenMetadataProperty.STEWARD.name, requestBody.getSteward(), "markAsConsolidatedDuplicate");
                properties = repositoryHelper.addStringPropertyToInstance(instanceHandler.getServiceName(), properties, OpenMetadataProperty.STEWARD_TYPE_NAME.name, requestBody.getStewardTypeName(), "markAsConsolidatedDuplicate");
                properties = repositoryHelper.addStringPropertyToInstance(instanceHandler.getServiceName(), properties, OpenMetadataProperty.STEWARD_PROPERTY_NAME.name, requestBody.getStewardPropertyName(), "markAsConsolidatedDuplicate");
                properties = repositoryHelper.addStringPropertyToInstance(instanceHandler.getServiceName(), properties, OpenMetadataProperty.SOURCE.name, requestBody.getSource(), "markAsConsolidatedDuplicate");
                properties = repositoryHelper.addStringPropertyToInstance(instanceHandler.getServiceName(), properties, OpenMetadataProperty.NOTES.name, requestBody.getNotes(), "markAsConsolidatedDuplicate");
                handler.setClassificationInRepository(userId, null, null, consolidatedDuplicateGUID, "consolidatedDuplicateGUID", OpenMetadataType.REFERENCEABLE.typeName, "e40e80d7-5a29-482c-9a88-0dc7251f08de", "ConsolidatedDuplicate", properties, false, true, true, instanceHandler.getSupportedZones(userId, serverName, "markAsConsolidatedDuplicate"), null, "markAsConsolidatedDuplicate");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "markAsConsolidatedDuplicate", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "markAsConsolidatedDuplicate", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse linkElementToConsolidatedDuplicate(String serverName, String userId, String consolidatedDuplicateGUID, String contributingElementGUID, NullRequestBody requestBody) {
        String methodName = "linkElementToConsolidatedDuplicate";
        String element1GUIDParameter = "consolidatedDuplicateGUID";
        String element2GUIDParameter = "contributingElementGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "linkElementToConsolidatedDuplicate");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "linkElementToConsolidatedDuplicate");
            ReferenceableHandler<ElementStub> handler = instanceHandler.getReferenceableHandler(userId, serverName, "linkElementToConsolidatedDuplicate");
            handler.linkElementToElement(userId, null, null, consolidatedDuplicateGUID, "consolidatedDuplicateGUID", OpenMetadataType.REFERENCEABLE.typeName, contributingElementGUID, "contributingElementGUID", OpenMetadataType.REFERENCEABLE.typeName, true, true, instanceHandler.getSupportedZones(userId, serverName, "linkElementToConsolidatedDuplicate"), "a1fabffd-d6ec-4b2d-bfe4-646f27c07c82", "ConsolidatedDuplicateLink", null, null, (Date)null, new Date(), "linkElementToConsolidatedDuplicate");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "linkElementToConsolidatedDuplicate", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse unlinkElementFromConsolidatedDuplicate(String serverName, String userId, String consolidatedDuplicateGUID, String contributingElementGUID, NullRequestBody requestBody) {
        String methodName = "unlinkElementFromConsolidatedDuplicate";
        String element1GUIDParameter = "consolidatedDuplicateGUID";
        String element2GUIDParameter = "contributingElementGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "unlinkElementFromConsolidatedDuplicate");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "unlinkElementFromConsolidatedDuplicate");
            ReferenceableHandler<ElementStub> handler = instanceHandler.getReferenceableHandler(userId, serverName, "unlinkElementFromConsolidatedDuplicate");
            handler.unlinkElementFromElement(userId, false, null, null, consolidatedDuplicateGUID, "consolidatedDuplicateGUID", OpenMetadataType.REFERENCEABLE.typeName, contributingElementGUID, "contributingElementGUID", OpenMetadataType.REFERENCEABLE.typeGUID, OpenMetadataType.REFERENCEABLE.typeName, true, true, instanceHandler.getSupportedZones(userId, serverName, "unlinkElementFromConsolidatedDuplicate"), "a1fabffd-d6ec-4b2d-bfe4-646f27c07c82", "ConsolidatedDuplicateLink", null, "unlinkElementFromConsolidatedDuplicate");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "unlinkElementFromConsolidatedDuplicate", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ElementStubsResponse getContributingDuplicates(String serverName, String userId, String consolidatedDuplicateGUID, int startFrom, int pageSize) {
        String methodName = "getContributingDuplicates";
        String guidParameterName = "consolidatedDuplicateGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getContributingDuplicates");
        ElementStubsResponse response = new ElementStubsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getContributingDuplicates");
            ReferenceableHandler<ElementStub> handler = instanceHandler.getReferenceableHandler(userId, serverName, "getContributingDuplicates");
            List elementStubs = handler.getAttachedElements(userId, null, null, consolidatedDuplicateGUID, "consolidatedDuplicateGUID", OpenMetadataType.REFERENCEABLE.typeName, "a1fabffd-d6ec-4b2d-bfe4-646f27c07c82", "ConsolidatedDuplicateLink", OpenMetadataType.REFERENCEABLE.typeName, (String)null, null, 1, null, null, SequencingOrder.CREATION_DATE_RECENT, null, true, true, handler.getSupportedZones(), startFrom, pageSize, null, "getContributingDuplicates");
            response.setElements(elementStubs);
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getContributingDuplicates", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ElementStubResponse getConsolidatedDuplicate(String serverName, String userId, String elementGUID) {
        String methodName = "getConsolidatedDuplicate";
        String guidParameterName = "elementGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getConsolidatedDuplicate");
        ElementStubResponse response = new ElementStubResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getConsolidatedDuplicate");
            ReferenceableHandler<ElementStub> handler = instanceHandler.getReferenceableHandler(userId, serverName, "getConsolidatedDuplicate");
            Relationship relationship = handler.getUniqueAttachmentLink(userId, elementGUID, "elementGUID", OpenMetadataType.REFERENCEABLE.typeName, "a1fabffd-d6ec-4b2d-bfe4-646f27c07c82", "ConsolidatedDuplicateLink", null, OpenMetadataType.REFERENCEABLE.typeName, 2, null, null, SequencingOrder.CREATION_DATE_RECENT, null, true, true, instanceHandler.getSupportedZones(userId, serverName, "getConsolidatedDuplicate"), null, "getConsolidatedDuplicate");
            if (relationship != null) {
                ElementStubConverter<ElementStub> converter = instanceHandler.getElementStubConverter(userId, serverName, "getConsolidatedDuplicate");
                ElementStub elementStub = converter.getElementStub(ElementStub.class, relationship.getEntityTwoProxy(), "getConsolidatedDuplicate");
                response.setElement(elementStub);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getConsolidatedDuplicate", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeConsolidatedDuplicate(String serverName, String userId, String consolidatedDuplicateGUID, NullRequestBody requestBody) {
        String methodName = "removeConsolidatedDuplicate";
        String element1GUIDParameter = "consolidatedDuplicateGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeConsolidatedDuplicate");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeConsolidatedDuplicate");
            ReferenceableHandler<ElementStub> handler = instanceHandler.getReferenceableHandler(userId, serverName, "removeConsolidatedDuplicate");
            handler.deleteBeanInRepository(userId, null, null, consolidatedDuplicateGUID, "consolidatedDuplicateGUID", OpenMetadataType.REFERENCEABLE.typeGUID, OpenMetadataType.REFERENCEABLE.typeName, null, null, true, true, instanceHandler.getSupportedZones(userId, serverName, "removeConsolidatedDuplicate"), null, "removeConsolidatedDuplicate");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "removeConsolidatedDuplicate", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

