/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.stewardshipaction.admin;

import java.util.List;
import org.odpi.openmetadata.accessservices.stewardshipaction.connectors.outtopic.StewardshipActionOutTopicServerConnector;
import org.odpi.openmetadata.accessservices.stewardshipaction.connectors.outtopic.StewardshipActionOutTopicServerProvider;
import org.odpi.openmetadata.accessservices.stewardshipaction.ffdc.StewardshipActionAuditCode;
import org.odpi.openmetadata.accessservices.stewardshipaction.outtopic.StewardshipActionOMRSTopicListener;
import org.odpi.openmetadata.accessservices.stewardshipaction.outtopic.StewardshipActionOutTopicPublisher;
import org.odpi.openmetadata.accessservices.stewardshipaction.server.StewardshipActionServicesInstance;
import org.odpi.openmetadata.adminservices.configuration.properties.AccessServiceConfig;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGConfigurationErrorException;
import org.odpi.openmetadata.adminservices.registration.AccessServiceAdmin;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.auditlog.ComponentDescription;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Endpoint;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditingComponent;
import org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopicConnector;
import org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopicListener;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;

public class StewardshipActionAdmin
extends AccessServiceAdmin {
    private AuditLog auditLog = null;
    private StewardshipActionServicesInstance instance = null;
    private String serverName = null;
    private StewardshipActionOutTopicPublisher eventPublisher = null;

    public void initialize(AccessServiceConfig accessServiceConfig, OMRSTopicConnector omrsTopicConnector, OMRSRepositoryConnector repositoryConnector, AuditLog auditLog, String serverUserName) throws OMAGConfigurationErrorException {
        String actionDescription = "initialize";
        auditLog.logMessage("initialize", StewardshipActionAuditCode.SERVICE_INITIALIZING.getMessageDefinition());
        this.auditLog = auditLog;
        try {
            List supportedZones = this.extractSupportedZones(accessServiceConfig.getAccessServiceOptions(), accessServiceConfig.getAccessServiceName(), auditLog);
            this.instance = new StewardshipActionServicesInstance(repositoryConnector, supportedZones, auditLog, serverUserName, repositoryConnector.getMaxPageSize());
            this.serverName = this.instance.getServerName();
            if (accessServiceConfig.getAccessServiceOutTopic() != null) {
                Connection outTopicEventBusConnection = accessServiceConfig.getAccessServiceOutTopic();
                Endpoint endpoint = outTopicEventBusConnection.getEndpoint();
                AuditLog outTopicAuditLog = auditLog.createNewAuditLog((ComponentDescription)OMRSAuditingComponent.OMAS_OUT_TOPIC);
                Connection serverSideOutTopicConnection = this.getServerSideOutTopicConnection(accessServiceConfig.getAccessServiceOutTopic(), AccessServiceDescription.STEWARDSHIP_ACTION_OMAS.getAccessServiceFullName(), StewardshipActionOutTopicServerProvider.class.getName(), auditLog);
                StewardshipActionOutTopicServerConnector outTopicServerConnector = (StewardshipActionOutTopicServerConnector)super.getTopicConnector(serverSideOutTopicConnection, StewardshipActionOutTopicServerConnector.class, outTopicAuditLog, AccessServiceDescription.STEWARDSHIP_ACTION_OMAS.getAccessServiceFullName(), "initialize");
                this.eventPublisher = new StewardshipActionOutTopicPublisher(outTopicServerConnector, endpoint.getAddress(), outTopicAuditLog, repositoryConnector.getRepositoryHelper(), AccessServiceDescription.STEWARDSHIP_ACTION_OMAS.getAccessServiceName(), this.serverName);
                this.registerWithEnterpriseTopic(AccessServiceDescription.STEWARDSHIP_ACTION_OMAS.getAccessServiceFullName(), this.serverName, omrsTopicConnector, (OMRSTopicListener)new StewardshipActionOMRSTopicListener(AccessServiceDescription.STEWARDSHIP_ACTION_OMAS.getAccessServiceFullName(), serverUserName, this.eventPublisher, this.instance.getReferenceableHandler(), supportedZones, outTopicAuditLog), auditLog);
            }
            auditLog.logMessage("initialize", StewardshipActionAuditCode.SERVICE_INITIALIZED.getMessageDefinition(new String[]{this.serverName}), accessServiceConfig.toString());
        }
        catch (OMAGConfigurationErrorException error) {
            throw error;
        }
        catch (Exception error) {
            auditLog.logException("initialize", StewardshipActionAuditCode.SERVICE_INSTANCE_FAILURE.getMessageDefinition(new String[]{error.getMessage()}), accessServiceConfig.toString(), (Throwable)error);
            super.throwUnexpectedInitializationException("initialize", AccessServiceDescription.STEWARDSHIP_ACTION_OMAS.getAccessServiceFullName(), (Throwable)error);
        }
    }

    public void shutdown() {
        String actionDescription = "shutdown";
        if (this.eventPublisher != null) {
            this.eventPublisher.disconnect();
        }
        if (this.instance != null) {
            this.instance.shutdown();
        }
        this.auditLog.logMessage("shutdown", StewardshipActionAuditCode.SERVICE_SHUTDOWN.getMessageDefinition(new String[]{this.serverName}));
    }
}

