/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.stewardshipaction.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.accessservices.stewardshipaction.server.StewardshipActionRESTServices;
import org.odpi.openmetadata.commonservices.ffdc.rest.DuplicatesRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.DuplicatesResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.ElementStubResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.ElementStubsResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.OCFConnectionResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.RegisteredOMAGServiceResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/access-services/stewardship-action/users/{userId}"})
@Tag(name="Metadata Access Server: Stewardship Action OMAS", description="The Stewardship Action OMAS provides APIs and events for tools and applications focused on resolving issues detected in the data landscape.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/services/omas/stewardship-action/overview/"))
public class StewardshipActionResource {
    private final StewardshipActionRESTServices restAPI = new StewardshipActionRESTServices();

    @GetMapping(path={"/description"})
    public RegisteredOMAGServiceResponse getServiceDescription(@PathVariable String serverName, @PathVariable String userId) {
        return this.restAPI.getServiceDescription(serverName, userId);
    }

    @GetMapping(path={"/topics/out-topic-connection/{callerId}"})
    public OCFConnectionResponse getOutTopicConnection(@PathVariable String serverName, @PathVariable String userId, @PathVariable String callerId) {
        return this.restAPI.getOutTopicConnection(serverName, userId, callerId);
    }

    @PostMapping(path={"/elements/{element1GUID}/peer-duplicate-of/{element2GUID}"})
    public VoidResponse linkElementsAsDuplicates(@PathVariable String serverName, @PathVariable String userId, @PathVariable String element1GUID, @PathVariable String element2GUID, @RequestBody DuplicatesRequestBody requestBody) {
        return this.restAPI.linkElementsAsDuplicates(serverName, userId, element1GUID, element2GUID, requestBody);
    }

    @PostMapping(path={"/elements/{element1GUID}/peer-duplicate-of/{element2GUID}/delete"})
    public VoidResponse unlinkElementsAsDuplicates(@PathVariable String serverName, @PathVariable String userId, @PathVariable String element1GUID, @PathVariable String element2GUID, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.unlinkElementsAsDuplicates(serverName, userId, element1GUID, element2GUID, requestBody);
    }

    @PostMapping(path={"/elements/{elementGUID}/known-duplicate"})
    public VoidResponse markElementAsKnownDuplicate(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.markElementAsKnownDuplicate(serverName, userId, elementGUID, requestBody);
    }

    @PostMapping(path={"/elements/{elementGUID}/known-duplicate/delete"})
    public VoidResponse unmarkElementAsKnownDuplicate(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.unmarkElementAsKnownDuplicate(serverName, userId, elementGUID, requestBody);
    }

    @GetMapping(path={"/elements/{elementGUID}/peer-duplicates"})
    public DuplicatesResponse getPeerDuplicates(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getPeerDuplicates(serverName, userId, elementGUID, startFrom, pageSize);
    }

    @PostMapping(path={"/elements/{consolidatedDuplicateGUID}/consolidated-duplicate"})
    public VoidResponse markAsConsolidatedDuplicate(@PathVariable String serverName, @PathVariable String userId, @PathVariable String consolidatedDuplicateGUID, @RequestBody DuplicatesRequestBody requestBody) {
        return this.restAPI.markAsConsolidatedDuplicate(serverName, userId, consolidatedDuplicateGUID, requestBody);
    }

    @PostMapping(path={"/elements/consolidated-duplicate/{consolidatedDuplicateGUID}/contributing-element/{contributingElementGUID}"})
    public VoidResponse linkElementToConsolidatedDuplicate(@PathVariable String serverName, @PathVariable String userId, @PathVariable String consolidatedDuplicateGUID, @PathVariable String contributingElementGUID, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.linkElementToConsolidatedDuplicate(serverName, userId, consolidatedDuplicateGUID, contributingElementGUID, requestBody);
    }

    @PostMapping(path={"/elements/consolidated-duplicate/{consolidatedDuplicateGUID}/contributing-element/{contributingElementGUID}/delete"})
    public VoidResponse unlinkElementFromConsolidatedDuplicate(@PathVariable String serverName, @PathVariable String userId, @PathVariable String consolidatedDuplicateGUID, @PathVariable String contributingElementGUID, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.unlinkElementFromConsolidatedDuplicate(serverName, userId, consolidatedDuplicateGUID, contributingElementGUID, requestBody);
    }

    @GetMapping(path={"/elements/consolidated-duplicate/{consolidatedDuplicateGUID}/contributing-elements"})
    public ElementStubsResponse getContributingDuplicates(@PathVariable String serverName, @PathVariable String userId, @PathVariable String consolidatedDuplicateGUID, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getContributingDuplicates(serverName, userId, consolidatedDuplicateGUID, startFrom, pageSize);
    }

    @GetMapping(path={"/elements/{elementGUID}/consolidated-duplicate"})
    public ElementStubResponse getConsolidatedDuplicate(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID) {
        return this.restAPI.getConsolidatedDuplicate(serverName, userId, elementGUID);
    }

    @PostMapping(path={"/elements/{consolidatedDuplicateGUID}/consolidated-duplicate/delete"})
    public VoidResponse removeConsolidatedDuplicate(@PathVariable String serverName, @PathVariable String userId, @PathVariable String consolidatedDuplicateGUID, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.removeConsolidatedDuplicate(serverName, userId, consolidatedDuplicateGUID, requestBody);
    }
}

