/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.governanceservers.stewardshipengineservices.properties;

public enum StewardshipEngineStatus {
    ASSIGNED(0, "Assigned", "The stewardship engine is assigned to the stewardship server but has not yet been configured."),
    CONFIGURING(1, "Configuring", "The stewardship engine is retrieving its configuration from the metadata server."),
    RUNNING(2, "Running", "The stewardship engine is operational and able to service all defined stewardship requests on demand."),
    FAILED(3, "Failed", "The stewardship engine is unable to run successfully due to an error in its configuration."),
    DISABLED(4, "Disabled", "The stewardship engine has been disabled. It is waiting to be enabled before it can service any more stewardship requests.");

    private static final long serialVersionUID = 1L;
    private int ordinal;
    private String statusName;
    private String statusDescription;

    private StewardshipEngineStatus(int ordinal, String statusName, String statusDescription) {
        this.ordinal = ordinal;
        this.statusName = statusName;
        this.statusDescription = statusDescription;
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    public String getStatusName() {
        return this.statusName;
    }

    public String getStatusDescription() {
        return this.statusDescription;
    }
}

