/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.governanceservers.stewardshipengineservices.client;

import java.util.List;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.governanceaction.ffdc.StewardshipEngineException;
import org.odpi.openmetadata.governanceservers.stewardshipengineservices.client.StewardshipEngineServicesRESTClient;
import org.odpi.openmetadata.governanceservers.stewardshipengineservices.properties.StewardshipEngineSummary;
import org.odpi.openmetadata.governanceservers.stewardshipengineservices.rest.StewardshipEngineStatusResponse;

public class StewardshipServerClient {
    private String serverName;
    private String serverPlatformRootURL;
    private StewardshipEngineServicesRESTClient restClient;
    private InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();
    private RESTExceptionHandler exceptionHandler = new RESTExceptionHandler();

    public StewardshipServerClient(String serverPlatformRootURL, String serverName) throws InvalidParameterException {
        this.serverPlatformRootURL = serverPlatformRootURL;
        this.serverName = serverName;
        this.restClient = new StewardshipEngineServicesRESTClient(serverName, serverPlatformRootURL);
    }

    public StewardshipServerClient(String serverPlatformRootURL, String serverName, String userId, String password) throws InvalidParameterException {
        this.serverPlatformRootURL = serverPlatformRootURL;
        this.serverName = serverName;
        this.restClient = new StewardshipEngineServicesRESTClient(serverName, serverPlatformRootURL, userId, password);
    }

    List<StewardshipEngineSummary> getStewardshipEngineStatuses(String userId) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getStewardshipEngineStatuses";
        String urlTemplate = "/servers/{0}/open-metadata/stewardship-server/users/{1}/stewardship-engines/status";
        this.invalidParameterHandler.validateUserId(userId, "getStewardshipEngineStatuses");
        StewardshipEngineStatusResponse restResult = this.restClient.callStewardshipEngineStatusGetRESTCall("getStewardshipEngineStatuses", this.serverPlatformRootURL + "/servers/{0}/open-metadata/stewardship-server/users/{1}/stewardship-engines/status", this.serverName, userId);
        this.exceptionHandler.detectAndThrowInvalidParameterException((FFDCResponse)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException((FFDCResponse)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException((FFDCResponse)restResult);
        return restResult.getStewardshipEngineSummaries();
    }

    public void refreshConfig(String userId, String stewardshipEngineName) throws InvalidParameterException, UserNotAuthorizedException, StewardshipEngineException {
        String methodName = "refreshConfig";
        String stewardshipEngineParameterName = "stewardshipEngineName";
        String urlTemplate = "/servers/{0}/open-metadata/stewardship-server/users/{1}/stewardship-engines/{2}/refresh-config";
        this.invalidParameterHandler.validateUserId(userId, "refreshConfig");
        this.invalidParameterHandler.validateName(stewardshipEngineName, "stewardshipEngineName", "refreshConfig");
        try {
            VoidResponse restResult = this.restClient.callVoidGetRESTCall("refreshConfig", this.serverPlatformRootURL + "/servers/{0}/open-metadata/stewardship-server/users/{1}/stewardship-engines/{2}/refresh-config", new Object[]{this.serverName, userId, stewardshipEngineName});
            this.exceptionHandler.detectAndThrowInvalidParameterException((FFDCResponse)restResult);
            this.exceptionHandler.detectAndThrowUserNotAuthorizedException((FFDCResponse)restResult);
            this.exceptionHandler.detectAndThrowPropertyServerException((FFDCResponse)restResult);
        }
        catch (PropertyServerException exception) {
            throw new StewardshipEngineException(exception.getReportedErrorMessage(), (OCFCheckedExceptionBase)exception);
        }
    }
}

