/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.governanceservers.stewardshipservices.server;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.multitenant.GovernanceServerServiceInstance;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.governanceservers.stewardshipengineservices.ffdc.StewardshipEngineServicesErrorCode;
import org.odpi.openmetadata.governanceservers.stewardshipengineservices.properties.StewardshipEngineSummary;
import org.odpi.openmetadata.governanceservers.stewardshipservices.handlers.StewardshipEngineHandler;

public class StewardshipServerInstance
extends GovernanceServerServiceInstance {
    private Map<String, StewardshipEngineHandler> stewardshipEngineInstances;

    StewardshipServerInstance(String serverName, String serviceName, AuditLog auditLog, String localServerUserId, int maxPageSize, String accessServiceRootURL, String accessServiceServerName, Map<String, StewardshipEngineHandler> stewardshipEngineInstances) {
        super(serverName, serviceName, auditLog, localServerUserId, maxPageSize, accessServiceRootURL, accessServiceServerName);
        this.stewardshipEngineInstances = stewardshipEngineInstances;
    }

    synchronized List<StewardshipEngineSummary> getStewardshipEngineStatuses() {
        ArrayList<StewardshipEngineSummary> results = new ArrayList<StewardshipEngineSummary>();
        if (this.stewardshipEngineInstances != null) {
            for (StewardshipEngineHandler stewardshipEngineHandler : this.stewardshipEngineInstances.values()) {
                if (stewardshipEngineHandler == null) continue;
                results.add(stewardshipEngineHandler.getSummary());
            }
        }
        if (results.isEmpty()) {
            return null;
        }
        return results;
    }

    synchronized StewardshipEngineHandler getStewardshipEngine(String stewardshipEngineName) throws InvalidParameterException {
        String methodName = "getStewardshipEngine";
        String guidParameterName = "stewardshipEngineName";
        StewardshipEngineHandler instance = this.stewardshipEngineInstances.get(stewardshipEngineName);
        if (instance == null) {
            throw new InvalidParameterException(StewardshipEngineServicesErrorCode.UNKNOWN_STEWARDSHIP_ENGINE.getMessageDefinition(new String[]{this.serverName, stewardshipEngineName}), ((Object)((Object)this)).getClass().getName(), "getStewardshipEngine", "stewardshipEngineName");
        }
        return instance;
    }

    public void shutdown() {
        if (this.stewardshipEngineInstances != null) {
            for (StewardshipEngineHandler handler : this.stewardshipEngineInstances.values()) {
                if (handler == null) continue;
            }
        }
        super.shutdown();
    }
}

