/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.governanceservers.stewardshipservices.server;

import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.governanceservers.stewardshipengineservices.rest.StewardshipEngineStatusResponse;
import org.odpi.openmetadata.governanceservers.stewardshipservices.handlers.StewardshipEngineHandler;
import org.odpi.openmetadata.governanceservers.stewardshipservices.server.StewardshipServerInstanceHandler;
import org.slf4j.LoggerFactory;

public class StewardshipServerRESTServices {
    private static StewardshipServerInstanceHandler instanceHandler = new StewardshipServerInstanceHandler();
    private static RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(StewardshipServerRESTServices.class), instanceHandler.getServiceName());
    private RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();

    public VoidResponse refreshConfig(String serverName, String stewardshipEngineName, String userId) {
        String methodName = "refreshConfig";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "refreshConfig");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            StewardshipEngineHandler handler = instanceHandler.getStewardshipEngineHandler(userId, serverName, stewardshipEngineName, "refreshConfig");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "refreshConfig");
            handler.refreshConfig();
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "refreshConfig", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public StewardshipEngineStatusResponse getStewardshipEngineStatuses(String serverName, String userId) {
        String methodName = "getStewardshipEngineStatuses";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getStewardshipEngineStatuses");
        StewardshipEngineStatusResponse response = new StewardshipEngineStatusResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getStewardshipEngineStatuses");
            response.setStewardshipEngineSummaries(instanceHandler.getStewardshipEngineStatuses(userId, serverName, "getStewardshipEngineStatuses"));
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "getStewardshipEngineStatuses", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

