/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.governanceservers.stewardshipengineservices.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.governanceservers.stewardshipengineservices.rest.StewardshipEngineStatusResponse;
import org.odpi.openmetadata.governanceservers.stewardshipservices.server.StewardshipServerRESTServices;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/stewardship-server/users/{userId}"})
@Tag(name="Stewardship Engine Services", description="The stewardship engine services provide the core subsystem for a stewardship server. A stewardship server is an OMAG Server that hosts automated metadata stewardship.", externalDocs=@ExternalDocumentation(description="Stewardship Engine Services", url="https://egeria.odpi.org/open-metadata-implementation/governance-servers/stewardship-engine-services/"))
public class StewardshipServerResource {
    private StewardshipServerRESTServices restAPI = new StewardshipServerRESTServices();

    @GetMapping(path={"/stewardship-engines/status"})
    public StewardshipEngineStatusResponse getStewardshipEngineStatuses(@PathVariable String serverName, @PathVariable String userId) {
        return this.restAPI.getStewardshipEngineStatuses(serverName, userId);
    }

    @GetMapping(path={"/stewardship-engines/{stewardshipEngineName}/refresh-config"})
    public VoidResponse refreshConfig(@PathVariable String serverName, @PathVariable String stewardshipEngineName, @PathVariable String userId) {
        return this.restAPI.refreshConfig(serverName, stewardshipEngineName, userId);
    }
}

