/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.structuredfile;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Scanner;
import org.odpi.openmetadata.adapters.connectors.structuredfile.StructuredFileStore;
import org.odpi.openmetadata.adapters.connectors.structuredfile.ffdc.StructuredFileConnectorErrorCode;
import org.odpi.openmetadata.adapters.connectors.structuredfile.ffdc.exception.FileReadException;
import org.odpi.openmetadata.frameworks.connectors.ConnectorBase;
import org.odpi.openmetadata.frameworks.connectors.properties.AdditionalProperties;
import org.odpi.openmetadata.frameworks.connectors.properties.ConnectionProperties;
import org.odpi.openmetadata.frameworks.connectors.properties.EndpointProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StructuredFileStoreConnector
extends ConnectorBase
implements StructuredFileStore {
    private String fileStoreName = null;
    private List<String> columnNames = null;
    private char delimiterChar = (char)44;
    private char quoteChar = (char)34;
    private static final Logger log = LoggerFactory.getLogger(StructuredFileStoreConnector.class);

    public void initialize(String connectorInstanceId, ConnectionProperties connectionProperties) {
        super.initialize(connectorInstanceId, connectionProperties);
        AdditionalProperties additionalProperties = connectionProperties.getAdditionalProperties();
        EndpointProperties endpoint = connectionProperties.getEndpoint();
        if (additionalProperties != null) {
            Object columnNamesProperty = additionalProperties.getProperty("columnNames");
            Object delimiterCharProperty = additionalProperties.getProperty("delimiterCharacter");
            Object quoteCharProperty = additionalProperties.getProperty("quoteCharacter");
            if (columnNamesProperty != null && columnNamesProperty instanceof List) {
                this.columnNames = new ArrayList<String>();
                for (Object columnNameProperty : (List)columnNamesProperty) {
                    if (columnNameProperty == null) continue;
                    this.columnNames.add(columnNameProperty.toString());
                }
            }
            if (delimiterCharProperty instanceof Character) {
                this.delimiterChar = ((Character)delimiterCharProperty).charValue();
            }
            if (quoteCharProperty instanceof Character) {
                this.quoteChar = ((Character)quoteCharProperty).charValue();
            }
        }
        if (endpoint != null) {
            this.fileStoreName = endpoint.getAddress();
        } else {
            log.error("Null endpoint");
        }
    }

    @Override
    public String getFileName() throws FileReadException {
        String methodName = "getFileName";
        this.validateFileStore(this.fileStoreName, "getFileName");
        return this.fileStoreName;
    }

    @Override
    public Date getLastUpdateDate() throws FileReadException {
        String methodName = "getLastUpdateDate";
        File fileStore = this.validateFileStore(this.fileStoreName, "getLastUpdateDate");
        return new Date(fileStore.lastModified());
    }

    @Override
    public long getRecordCount() throws FileReadException {
        String methodName = "getRecordCount";
        long rowCount = 0L;
        File fileStore = this.validateFileStore(this.fileStoreName, "getRecordCount");
        try {
            Scanner scanner = new Scanner(fileStore);
            while (scanner.hasNext()) {
                scanner.nextLine();
                ++rowCount;
            }
            scanner.close();
            if (rowCount > 0L && this.columnNames == null) {
                --rowCount;
            }
        }
        catch (IOException error) {
            StructuredFileConnectorErrorCode errorCode = StructuredFileConnectorErrorCode.UNEXPECTED_IO_EXCEPTION;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(this.fileStoreName, error.getMessage());
            throw new FileReadException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "getRecordCount", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), error, this.fileStoreName);
        }
        return rowCount;
    }

    @Override
    public List<String> getColumnNames() throws FileReadException {
        String methodName = "getColumnNames";
        this.validateFileStore(this.fileStoreName, "getColumnNames");
        if (this.columnNames != null) {
            return this.columnNames;
        }
        return this.readRow(0, "getColumnNames");
    }

    @Override
    public List<String> readRecord(int dataRecordNumber) throws FileReadException {
        String methodName = "readRecord";
        if (this.columnNames == null) {
            return this.readRow(dataRecordNumber + 1, "readRecord");
        }
        return this.readRow(dataRecordNumber, "readRecord");
    }

    private List<String> readRow(int recordLocation, String methodName) throws FileReadException {
        File fileStore = this.validateFileStore(this.fileStoreName, methodName);
        try {
            Scanner scanner = new Scanner(fileStore);
            int rowCounter = 0;
            while (scanner.hasNext()) {
                if (rowCounter == recordLocation) {
                    return this.parseRecord(scanner.nextLine());
                }
                scanner.nextLine();
                ++rowCounter;
            }
            scanner.close();
            StructuredFileConnectorErrorCode errorCode = StructuredFileConnectorErrorCode.FILE_TOO_SHORT;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(this.fileStoreName, Integer.toString(recordLocation));
            throw new FileReadException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), this.fileStoreName);
        }
        catch (IOException error) {
            StructuredFileConnectorErrorCode errorCode = StructuredFileConnectorErrorCode.UNEXPECTED_IO_EXCEPTION;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(this.fileStoreName, error.getMessage());
            throw new FileReadException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), error, this.fileStoreName);
        }
    }

    private List<String> parseRecord(String fileRecord) {
        char[] characters;
        if (fileRecord == null || fileRecord.isEmpty()) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        StringBuffer currentValue = new StringBuffer();
        boolean inQuotes = false;
        boolean startCollectingCharacters = false;
        boolean doubleQuotesInColumn = false;
        for (char character : characters = fileRecord.toCharArray()) {
            if (inQuotes) {
                startCollectingCharacters = true;
                if (character == this.quoteChar) {
                    inQuotes = false;
                    doubleQuotesInColumn = false;
                    continue;
                }
                if (character == '\"') {
                    if (doubleQuotesInColumn) continue;
                    currentValue.append(character);
                    doubleQuotesInColumn = true;
                    continue;
                }
                currentValue.append(character);
                continue;
            }
            if (character == this.quoteChar) {
                inQuotes = true;
                if (characters[0] != '\"' && this.quoteChar == '\"') {
                    currentValue.append('\"');
                }
                if (!startCollectingCharacters) continue;
                currentValue.append('\"');
                continue;
            }
            if (character == this.delimiterChar) {
                result.add(currentValue.toString());
                currentValue = new StringBuffer();
                startCollectingCharacters = false;
                continue;
            }
            if (character == '\n') break;
            if (character == '\r') continue;
            currentValue.append(character);
        }
        result.add(currentValue.toString());
        return result;
    }

    public void disconnect() {
        try {
            super.disconnect();
        }
        catch (Throwable exec) {
            log.debug("Ignoring unexpected exception " + exec.getClass().getSimpleName() + " with message " + exec.getMessage());
        }
        log.debug("Closing Structured File Store");
    }

    private File validateFileStore(String fileStoreName, String methodName) throws FileReadException {
        if (fileStoreName == null) {
            StructuredFileConnectorErrorCode errorCode = StructuredFileConnectorErrorCode.FILE_NOT_SPECIFIED;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(this.connectionBean.getQualifiedName());
            throw new FileReadException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), null);
        }
        File fileStore = new File(fileStoreName);
        if (!fileStore.exists()) {
            StructuredFileConnectorErrorCode errorCode = StructuredFileConnectorErrorCode.FILE_NOT_FOUND;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(fileStoreName, this.connectionBean.getQualifiedName());
            throw new FileReadException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), fileStoreName);
        }
        if (fileStore.isDirectory()) {
            StructuredFileConnectorErrorCode errorCode = StructuredFileConnectorErrorCode.DIRECTORY_SPECIFIED;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(fileStoreName, this.connectionBean.getQualifiedName());
            throw new FileReadException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), fileStoreName);
        }
        if (!fileStore.canRead()) {
            StructuredFileConnectorErrorCode errorCode = StructuredFileConnectorErrorCode.FILE_NOT_READABLE;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(fileStoreName, this.connectionBean.getQualifiedName());
            throw new FileReadException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), fileStoreName);
        }
        return fileStore;
    }
}

