/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.properties.objects.glossary;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.List;
import java.util.Set;
import org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.CanonicalVocabulary;
import org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.Classification;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.GovernanceActions;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.governednode.GovernedNode;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.node.Node;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.node.NodeType;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class Glossary
extends GovernedNode {
    String usage = null;
    String language = null;

    public Glossary() {
        this.nodeType = NodeType.Glossary;
    }

    public String getUsage() {
        return this.usage;
    }

    public void setUsage(String usage) {
        this.usage = usage;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    @Override
    public String getName() {
        return super.getName();
    }

    @Override
    public void setName(String name) {
        super.setName(name);
    }

    @Override
    public NodeType getNodeType() {
        return super.getNodeType();
    }

    @Override
    public void setNodeType(NodeType nodeType) {
        super.setNodeType(nodeType);
    }

    @Override
    public String getDescription() {
        return super.getDescription();
    }

    @Override
    public String getQualifiedName() {
        return super.getQualifiedName();
    }

    @Override
    public Set<String> getProjects() {
        return super.getProjects();
    }

    @Override
    public List<Classification> getClassifications() {
        return super.getClassifications();
    }

    @Override
    public GovernanceActions getGovernanceActions() {
        return super.getGovernanceActions();
    }

    @Override
    public String getIcon() {
        return super.getIcon();
    }

    @Override
    public void processClassification(Classification classification) {
        if (classification.getClassificationName().equals("Taxonomy")) {
            if (this.nodeType == NodeType.CanonicalGlossary || this.nodeType == NodeType.TaxonomyAndCanonicalGlossary) {
                super.setNodeType(NodeType.TaxonomyAndCanonicalGlossary);
            } else {
                super.setNodeType(NodeType.Taxonomy);
            }
        } else if (classification.getClassificationName().equals(new CanonicalVocabulary().getClassificationName())) {
            if (this.nodeType == NodeType.Taxonomy || this.nodeType == NodeType.TaxonomyAndCanonicalGlossary) {
                super.setNodeType(NodeType.TaxonomyAndCanonicalGlossary);
            } else {
                super.setNodeType(NodeType.CanonicalGlossary);
            }
        }
    }

    @Override
    public StringBuilder toString(StringBuilder sb) {
        if (sb == null) {
            sb = new StringBuilder();
        }
        sb.append("Glossary=");
        sb.append((CharSequence)super.toString(sb));
        return sb;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Glossary term = (Glossary)o;
        Node node = (Node)o;
        return node.equals((Node)o);
    }

    @Override
    public int hashCode() {
        return ((Node)this).hashCode();
    }
}

