/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.properties.objects.term;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import java.util.Set;
import org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.Classification;
import org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.ObjectIdentifier;
import org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.SpineAttribute;
import org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.SpineObject;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.governednode.GovernedNode;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.node.Node;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.node.NodeType;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.term.Asset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class Term
extends GovernedNode
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(Term.class);
    private static final String className = Term.class.getName();
    private String glossaryName = null;
    private String summary = null;
    private String abbreviation = null;
    private String examples = null;
    private String usage = null;
    private Set<Asset> assets = null;
    private Set<String> categories = null;
    private boolean isSpineObject = false;
    private boolean isSpineAttribute = false;
    private boolean isObjectIdentifier = false;

    public Term() {
        this.nodeType = NodeType.Term;
    }

    public String getGlossaryName() {
        return this.glossaryName;
    }

    public void setGlossaryName(String glossaryName) {
        this.glossaryName = glossaryName;
    }

    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public String getAbbreviation() {
        return this.abbreviation;
    }

    public void setAbbreviation(String abbreviation) {
        this.abbreviation = abbreviation;
    }

    public String getExamples() {
        return this.examples;
    }

    public void setExamples(String examples) {
        this.examples = examples;
    }

    public String getUsage() {
        return this.usage;
    }

    public void setUsage(String usage) {
        this.usage = usage;
    }

    public Set<Asset> getAssets() {
        return this.assets;
    }

    public void setAssets(Set<Asset> assets) {
        this.assets = assets;
    }

    public Set<String> getCategories() {
        return this.categories;
    }

    public void setCategories(Set<String> categories) {
        this.categories = categories;
    }

    public boolean isSpineObject() {
        return this.isSpineObject;
    }

    public void setSpineObject(boolean spineObject) {
        this.isSpineObject = spineObject;
    }

    public boolean isSpineAttribute() {
        return this.isSpineAttribute;
    }

    public void setSpineAttribute(boolean spineAttribute) {
        this.isSpineAttribute = spineAttribute;
    }

    public boolean isObjectIdentifier() {
        return this.isObjectIdentifier;
    }

    public void setObjectIdentifier(boolean objectIdentifier) {
        this.isObjectIdentifier = objectIdentifier;
    }

    @Override
    public StringBuilder toString(StringBuilder sb) {
        if (sb == null) {
            sb = new StringBuilder();
        }
        sb.append("term=");
        sb.append((CharSequence)super.toString(sb));
        sb.append("GlossaryTerm Attributes{");
        sb.append("Summary=" + this.summary);
        sb.append("Examples=" + this.examples);
        sb.append("Abbreviation=" + this.abbreviation);
        sb.append("Usage=" + this.usage);
        sb.append("GlossaryName=" + this.glossaryName);
        sb.append(", SpineInformation=[");
        if (this.isSpineObject) {
            sb.append("SpineObject ");
        }
        if (this.isSpineAttribute) {
            sb.append("SpineAttribute ");
        }
        if (this.isObjectIdentifier) {
            sb.append("SpineIdentifier");
        }
        sb.append("]");
        if (this.glossaryName != null) {
            sb.append(", glossaryName=");
            sb.append(this.glossaryName);
        }
        if (this.categories != null) {
            sb.append(", categories=[");
            for (String category : this.categories) {
                sb.append("category").append(":");
                sb.append(category);
            }
            sb.append(this.categories.toString());
            sb.append(" ]");
        }
        if (this.assets != null) {
            for (Asset asset : this.assets) {
                sb.append(asset.getName()).append(":");
                sb.append(asset.toString());
            }
            sb.append(", assets=[").append(this.assets.toString());
            sb.append(" ],");
        }
        sb.append('}');
        return sb;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Term term = (Term)o;
        Node node = (Node)o;
        if (!node.equals((Node)o)) {
            return false;
        }
        if (this.assets != null ? !this.assets.equals(term.assets) : term.assets != null) {
            return false;
        }
        if (this.glossaryName != null ? !this.glossaryName.equals(term.glossaryName) : term.glossaryName != null) {
            return false;
        }
        if (this.summary != null ? !this.summary.equals(term.summary) : term.summary != null) {
            return false;
        }
        return !(this.categories != null ? !this.categories.equals(term.categories) : term.categories != null);
    }

    @Override
    public int hashCode() {
        int result = ((Node)this).hashCode();
        result = 31 * result + (this.summary != null ? this.summary.hashCode() : 0);
        result = 31 * result + (this.glossaryName != null ? this.glossaryName.hashCode() : 0);
        result = 31 * result + (this.assets != null ? this.assets.hashCode() : 0);
        result = 31 * result + (this.categories != null ? this.categories.hashCode() : 0);
        return result;
    }

    @Override
    protected void processClassification(Classification classification) {
        String classificationName = new SpineObject().getClassificationName();
        if (classification.getClassificationName().equals(classificationName)) {
            this.isSpineObject = true;
        }
        classificationName = new SpineAttribute().getClassificationName();
        if (classification.getClassificationName().equals(classificationName)) {
            this.isSpineAttribute = true;
        }
        classificationName = new ObjectIdentifier().getClassificationName();
        if (classification.getClassificationName().equals(classificationName)) {
            this.isObjectIdentifier = true;
        }
    }
}

