/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.validators;

import org.odpi.openmetadata.accessservices.subjectarea.ffdc.SubjectAreaErrorCode;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.subjectarea.properties.enums.Status;

public class InputValidator {
    public static void validateOMASServerURLNotNull(String className, String methodName, String omasServerURL) throws InvalidParameterException {
        if (omasServerURL == null) {
            SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.SERVER_URL_NOT_SPECIFIED;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[0]);
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), className, methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }

    public static void validateUserIdNotNull(String className, String methodName, String userId) throws InvalidParameterException {
        if (userId == null) {
            SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.NULL_USER_ID;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(methodName);
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), className, methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }

    public static Status validateStatusAndCheckNotDeleted(String className, String methodName, String statusName) throws InvalidParameterException {
        Status newStatus = null;
        try {
            newStatus = Status.valueOf(statusName);
        }
        catch (Exception e) {
            SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.INVALID_STATUS_VALUE_SUPPLIED;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(statusName);
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), className, methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        if (Status.DELETED == newStatus) {
            SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.STATUS_UPDATE_TO_DELETED_NOT_ALLOWED;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getUnformattedErrorMessage();
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), className, methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        return newStatus;
    }

    public static void validateGUIDNotNull(String className, String methodName, String guid, String guidParameter) throws InvalidParameterException {
        if (guid == null) {
            SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.NULL_GUID;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(guidParameter, methodName);
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), className, methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }

    public static void validateNameNotNull(String className, String methodName, String name, String nameParameter) throws InvalidParameterException {
        if (name == null) {
            SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.NULL_NAME;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(nameParameter, methodName);
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), className, methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }
}

