/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class Reference
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String KEY_RELATED_END_GUID = "relatedEndGuid";
    public static final String KEY_RELATIONSHIP_GUID = "RelationshipGuid";
    public static final String KEY_TYPENAME = "relatedEndType";
    public static final String KEY_UNIQUE_ATTRIBUTES = "uniqueAttributes";
    protected String relationship_Type = null;
    protected String relationshipGuid;
    protected Map<String, Object> uniqueAttributes;
    protected String relatedEndGuid;
    protected String relatedEndType = null;
    protected String referenceName = null;
    private Map<String, Object> relationshipAttributes;

    public String getRelationship_Type() {
        return this.relationship_Type;
    }

    public void setRelationship_Type(String relationship_Type) {
        this.relationship_Type = relationship_Type;
    }

    public Map<String, Object> getRelationshipAttributes() {
        return this.relationshipAttributes;
    }

    public void setRelationshipAttributes(Map<String, Object> relationshipAttributes) {
        this.relationshipAttributes = relationshipAttributes;
    }

    public String getRelatedEndGuid() {
        return this.relatedEndGuid;
    }

    public void setRelatedEndGuid(String relatedEndGuid) {
        this.relatedEndGuid = relatedEndGuid;
    }

    public String getRelationshipGuid() {
        return this.relationshipGuid;
    }

    public void setRelationshipGuid(String relationshipGuid) {
        this.relationshipGuid = relationshipGuid;
    }

    public String getRelatedEndType() {
        return this.relatedEndType;
    }

    public void setRelatedEndType(String relatedEndType) {
        this.relatedEndType = relatedEndType;
    }

    public Reference() {
        this(null, null, null);
    }

    public Reference(String guid) {
        this(guid, null, null);
    }

    public Reference(String guid, String relatedEndType) {
        this(guid, relatedEndType, null);
    }

    public Reference(String relatedEndType, Map<String, Object> uniqueAttributes) {
        this(null, relatedEndType, uniqueAttributes);
    }

    public Reference(String relatedEndType, final String attrName, final Object attrValue) {
        this(null, relatedEndType, (Map<String, Object>)new HashMap<String, Object>(){
            {
                this.put(attrName, attrValue);
            }
        });
    }

    public Reference(String guid, String relatedEndType, Map<String, Object> uniqueAttributes) {
        this.setRelationshipGuid(guid);
        this.setRelatedEndType(relatedEndType);
        this.setUniqueAttributes(uniqueAttributes);
    }

    public Reference(Reference other) {
        if (other != null) {
            this.setRelationshipGuid(other.getRelationshipGuid());
            this.setRelatedEndGuid(other.getRelatedEndGuid());
            this.setRelatedEndType(other.getRelatedEndType());
            this.setUniqueAttributes(other.getUniqueAttributes());
        }
    }

    public Reference(Map objIdMap) {
        if (objIdMap != null) {
            Object reg = objIdMap.get(KEY_RELATED_END_GUID);
            Object rg = objIdMap.get(KEY_RELATIONSHIP_GUID);
            Object t = objIdMap.get(KEY_TYPENAME);
            Object u = objIdMap.get(KEY_UNIQUE_ATTRIBUTES);
            if (reg != null) {
                this.setRelatedEndGuid(reg.toString());
            }
            if (rg != null) {
                this.setRelationshipGuid(rg.toString());
            }
            if (t != null) {
                this.setRelatedEndType(t.toString());
            }
            if (u != null && u instanceof Map) {
                this.setUniqueAttributes((Map)u);
            }
        }
    }

    public Map<String, Object> getUniqueAttributes() {
        return this.uniqueAttributes;
    }

    public void setUniqueAttributes(Map<String, Object> uniqueAttributes) {
        this.uniqueAttributes = uniqueAttributes;
    }

    public StringBuilder toString(StringBuilder sb) {
        if (sb == null) {
            sb = new StringBuilder();
        }
        sb.append("Reference{");
        sb.append("relatedEndGuid='").append(this.relatedEndGuid).append('\'');
        sb.append("relationshipGuid='").append(this.relationshipGuid).append('\'');
        sb.append("relatedEndType='").append(this.relatedEndType).append('\'');
        sb.append(", uniqueAttributes={");
        sb.append('}');
        sb.append('}');
        return sb;
    }

    public String getReferenceName() {
        return this.referenceName;
    }

    public void setReferenceName(String referenceName) {
        this.referenceName = referenceName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Reference that = (Reference)o;
        if (this.relatedEndGuid != null && !Objects.equals(this.relatedEndGuid, that.relatedEndGuid)) {
            return false;
        }
        if (this.relationshipGuid != null && !Objects.equals(this.relationshipGuid, that.relationshipGuid)) {
            return false;
        }
        return Objects.equals(this.relatedEndType, that.relatedEndType) && Objects.equals(this.uniqueAttributes, that.uniqueAttributes);
    }

    public int hashCode() {
        return this.relatedEndGuid != null ? Objects.hash(this.relatedEndGuid) : Objects.hash(this.relatedEndType, this.uniqueAttributes);
    }

    public String toString() {
        return this.toString(new StringBuilder()).toString();
    }
}

