/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.properties.objects.governednode;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.Classification;
import org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.Confidence;
import org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.Confidentiality;
import org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.Criticality;
import org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.Retention;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.GovernanceActions;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class GovernedNode
extends Node
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(GovernedNode.class);
    private static final String className = GovernedNode.class.getName();
    private GovernanceActions governanceActions = null;

    public GovernanceActions getGovernanceActions() {
        return this.governanceActions;
    }

    public void setGovernanceActions(GovernanceActions governanceActions) {
        this.governanceActions = governanceActions;
    }

    @Override
    public StringBuilder toString(StringBuilder sb) {
        if (sb == null) {
            sb = new StringBuilder();
        }
        sb.append("Node{");
        sb.append("node='").append((CharSequence)super.toString(sb)).append('\'');
        if (this.governanceActions != null) {
            sb.append(",goveranceActions=").append(this.governanceActions);
        }
        sb.append('}');
        return sb;
    }

    @Override
    public String toString() {
        return this.toString(new StringBuilder()).toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GovernedNode governedNode = (GovernedNode)o;
        Node node = (Node)o;
        if (!node.equals(this)) {
            return false;
        }
        return !(this.governanceActions != null ? !this.governanceActions.equals(governedNode.governanceActions) : governedNode.governanceActions != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.governanceActions != null ? this.governanceActions.hashCode() : 0);
        return result;
    }

    @Override
    public void setClassifications(List<Classification> classifications) {
        if (classifications != null && classifications.size() > 0) {
            ArrayList<Classification> newClassifications = new ArrayList<Classification>();
            if (this.governanceActions == null) {
                this.governanceActions = new GovernanceActions();
            }
            for (Classification classification : classifications) {
                if (classification.getClassificationName().equals(new Confidentiality().getClassificationName())) {
                    this.governanceActions.setConfidentiality((Confidentiality)classification);
                } else if (classification.getClassificationName().equals(new Confidence().getClassificationName())) {
                    this.governanceActions.setConfidence((Confidence)classification);
                } else if (classification.getClassificationName().equals(new Criticality().getClassificationName())) {
                    this.governanceActions.setCriticality((Criticality)classification);
                } else if (classification.getClassificationName().equals(new Retention().getClassificationName())) {
                    this.governanceActions.setRetention((Retention)classification);
                } else {
                    newClassifications.add(classification);
                }
                this.processClassification(classification);
            }
            this.classifications = newClassifications;
        }
    }
}

