/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class RelationshipEnd
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String KEY_END_GUID = "EndGuid";
    public static final String KEY_RELATIONSHIP_GUID = "RelationshipGuid";
    public static final String KEY_TYPENAME = "relatedEndType";
    public static final String KEY_UNIQUE_ATTRIBUTES = "uniqueAttributes";
    private String EndGuid;
    private String relationshipGuid;
    private Map<String, Object> uniqueAttributes;
    protected String typeName = null;

    public String getEndGuid() {
        return this.EndGuid;
    }

    public void setEndGuid(String EndGuid) {
        this.EndGuid = EndGuid;
    }

    public String getRelationshipGuid() {
        return this.relationshipGuid;
    }

    public void setRelationshipGuid(String relationshipGuid) {
        this.relationshipGuid = relationshipGuid;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public RelationshipEnd() {
        this(null, null, null);
    }

    public RelationshipEnd(String guid) {
        this(guid, null, null);
    }

    public RelationshipEnd(String guid, String typeName) {
        this(guid, typeName, null);
    }

    public RelationshipEnd(String typeName, Map<String, Object> uniqueAttributes) {
        this(null, typeName, uniqueAttributes);
    }

    public RelationshipEnd(String guid, String typeName, Map<String, Object> uniqueAttributes) {
        this.setRelationshipGuid(guid);
        this.setTypeName(typeName);
        this.setUniqueAttributes(uniqueAttributes);
    }

    public RelationshipEnd(RelationshipEnd other) {
        if (other != null) {
            this.setRelationshipGuid(other.getRelationshipGuid());
            this.setEndGuid(other.getEndGuid());
            this.setTypeName(other.getTypeName());
            this.setUniqueAttributes(other.getUniqueAttributes());
        }
    }

    public RelationshipEnd(Map objIdMap) {
        if (objIdMap != null) {
            Object reg = objIdMap.get(KEY_END_GUID);
            Object rg = objIdMap.get(KEY_RELATIONSHIP_GUID);
            Object t = objIdMap.get(KEY_TYPENAME);
            Object u = objIdMap.get(KEY_UNIQUE_ATTRIBUTES);
            if (reg != null) {
                this.setEndGuid(reg.toString());
            }
            if (rg != null) {
                this.setRelationshipGuid(rg.toString());
            }
            if (t != null) {
                this.setTypeName(t.toString());
            }
            if (u != null && u instanceof Map) {
                this.setUniqueAttributes((Map)u);
            }
        }
    }

    public Map<String, Object> getUniqueAttributes() {
        return this.uniqueAttributes;
    }

    public void setUniqueAttributes(Map<String, Object> uniqueAttributes) {
        this.uniqueAttributes = uniqueAttributes;
    }

    public StringBuilder toString(StringBuilder sb) {
        if (sb == null) {
            sb = new StringBuilder();
        }
        sb.append("Reference{");
        sb.append("EndGuid='").append(this.EndGuid).append('\'');
        sb.append("relationshipGuid='").append(this.relationshipGuid).append('\'');
        sb.append("relatedEndType='").append(this.typeName).append('\'');
        sb.append(", uniqueAttributes={");
        sb.append('}');
        sb.append('}');
        return sb;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RelationshipEnd that = (RelationshipEnd)o;
        if (this.EndGuid != null && !Objects.equals(this.EndGuid, that.EndGuid)) {
            return false;
        }
        if (this.relationshipGuid != null && !Objects.equals(this.relationshipGuid, that.relationshipGuid)) {
            return false;
        }
        return Objects.equals(this.typeName, that.typeName) && Objects.equals(this.uniqueAttributes, that.uniqueAttributes);
    }

    public int hashCode() {
        return this.EndGuid != null ? Objects.hash(this.EndGuid) : Objects.hash(this.typeName, this.uniqueAttributes);
    }

    public String toString() {
        return this.toString(new StringBuilder()).toString();
    }
}

