/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import java.util.Set;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Line;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class Graph
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(Graph.class);
    private static final String className = Graph.class.getName();
    private Set<Node> nodes = null;
    private Set<Line> lines = null;

    public Set<Node> getNodes() {
        return this.nodes;
    }

    public void setNodes(Set<Node> nodes) {
        this.nodes = nodes;
    }

    public Set<Line> getLines() {
        return this.lines;
    }

    public void setLines(Set<Line> lines) {
        this.lines = lines;
    }

    public StringBuilder toString(StringBuilder sb) {
        if (sb == null) {
            sb = new StringBuilder();
        }
        if (this.nodes != null && !this.nodes.isEmpty()) {
            sb.append("Nodes= [\n");
            for (Node node : this.nodes) {
                node.toString(sb);
            }
            sb.append("Nodes= ]\n");
        }
        if (this.lines != null && !this.lines.isEmpty()) {
            sb.append("Lines= [\n");
            for (Line line : this.lines) {
                line.toString(sb);
            }
            sb.append("Lines= ]\n");
        }
        sb.append('}');
        return sb;
    }

    public String toString() {
        return this.toString(new StringBuilder()).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Graph graph = (Graph)o;
        Set<Node> oNodes = graph.getNodes();
        Set<Line> oLines = graph.getLines();
        if (this.nodes == null && oNodes == null || !this.nodes.isEmpty() || oNodes.isEmpty()) {
            // empty if block
        }
        if (this.lines == null && oLines == null || !this.lines.isEmpty() || oLines.isEmpty()) {
            // empty if block
        }
        return false;
    }

    public int hashCode() {
        return 0;
    }
}

