/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.properties.relationships;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.odpi.openmetadata.accessservices.subjectarea.properties.enums.TermRelationshipStatus;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Line;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.LineType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class Antonym
extends Line {
    private static final Logger log = LoggerFactory.getLogger(Antonym.class);
    private static final String className = Antonym.class.getName();
    private static final String[] PROPERTY_NAMES_SET_VALUES = new String[]{"description", "expression", "status", "steward", "source", null};
    private static final String[] ATTRIBUTE_NAMES_SET_VALUES = new String[]{"description", "expression", "steward", "source", null};
    private static final String[] ENUM_NAMES_SET_VALUES = new String[]{"status", null};
    private static final String[] MAP_NAMES_SET_VALUES = new String[]{null};
    private static final Set<String> PROPERTY_NAMES_SET = new HashSet<String>(new HashSet<String>(Arrays.asList(PROPERTY_NAMES_SET_VALUES)));
    private static final Set<String> ATTRIBUTE_NAMES_SET = new HashSet<String>(new HashSet<String>(Arrays.asList(ATTRIBUTE_NAMES_SET_VALUES)));
    private static final Set<String> ENUM_NAMES_SET = new HashSet<String>(new HashSet<String>(Arrays.asList(ENUM_NAMES_SET_VALUES)));
    private static final Set<String> MAP_NAMES_SET = new HashSet<String>(new HashSet<String>(Arrays.asList(MAP_NAMES_SET_VALUES)));
    private String antonym1Guid = null;
    private String antonym2Guid = null;
    private String description;
    private String expression;
    private TermRelationshipStatus status;
    private String steward;
    private String source;

    public Antonym() {
        this.initialise();
    }

    private void initialise() {
        this.name = "Antonym";
        try {
            this.lineType = LineType.valueOf(this.name);
        }
        catch (IllegalArgumentException e) {
            this.lineType = LineType.Unknown;
        }
        this.entity1Name = "antonyms";
        this.entity1Type = "GlossaryTerm";
        this.entity2Name = "antonyms";
        this.entity2Type = "GlossaryTerm";
        this.typeDefGuid = "ea5e126a-a8fa-4a43-bcfa-309a98aa0185";
    }

    public Antonym(Line template) {
        super(template);
        this.initialise();
    }

    public Antonym(Relationship omrsRelationship) {
        super(omrsRelationship);
        this.name = "Antonym";
        try {
            this.lineType = LineType.valueOf(this.name);
        }
        catch (IllegalArgumentException e) {
            this.lineType = LineType.Unknown;
        }
        this.antonym1Guid = omrsRelationship.getEntityOneProxy().getGUID();
        this.antonym2Guid = omrsRelationship.getEntityTwoProxy().getGUID();
    }

    public String getAntonym1Guid() {
        return this.antonym1Guid;
    }

    public void setAntonym1Guid(String antonym1Guid) {
        this.antonym1Guid = antonym1Guid;
    }

    public String getAntonym2Guid() {
        return this.antonym2Guid;
    }

    public void setAntonym2Guid(String antonym2Guid) {
        this.antonym2Guid = antonym2Guid;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public TermRelationshipStatus getStatus() {
        return this.status;
    }

    public void setStatus(TermRelationshipStatus status) {
        this.status = status;
    }

    public String getSteward() {
        return this.steward;
    }

    public void setSteward(String steward) {
        this.steward = steward;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    @Override
    public StringBuilder toString(StringBuilder sb) {
        if (sb == null) {
            sb = new StringBuilder();
        }
        sb.append(" Antonym=");
        sb.append((CharSequence)super.toString(sb));
        sb.append(" Antonym Attributes{");
        sb.append("description=" + this.description + ",");
        sb.append("expression=" + this.expression + ",");
        sb.append("steward=" + this.steward + ",");
        sb.append("source=" + this.source + ",");
        if (this.status != null) {
            sb.append("status=" + this.status.name());
        }
        sb.append("}");
        return sb;
    }

    public String toString() {
        return this.toString(new StringBuilder()).toString();
    }
}

