/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.responses;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.SubjectAreaErrorCode;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.SubjectAreaCheckedExceptionBase;
import org.odpi.openmetadata.accessservices.subjectarea.responses.ResponseCategory;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SubjectAreaOMASAPIResponse;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class UnexpectedExceptionResponse
extends SubjectAreaOMASAPIResponse {
    protected String exceptionClassName = null;
    protected String exceptionErrorMessage = null;
    protected String exceptionSystemAction = null;
    protected String exceptionUserAction = null;

    public UnexpectedExceptionResponse() {
        this.setResponseCategory(ResponseCategory.UnexpectedException);
    }

    public UnexpectedExceptionResponse(String methodName, String errorMessage) {
        this.setResponseCategory(ResponseCategory.UnexpectedException);
        SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.GUID_DOES_NOT_EXIST;
        this.exceptionErrorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(methodName, errorMessage);
        this.exceptionSystemAction = errorCode.getSystemAction();
        this.exceptionUserAction = errorCode.getUserAction();
    }

    public UnexpectedExceptionResponse(SubjectAreaCheckedExceptionBase e) {
        this();
        this.exceptionClassName = e.getReportingClassName();
        this.exceptionErrorMessage = e.getErrorMessage();
        this.exceptionSystemAction = e.getReportedSystemAction();
        this.exceptionUserAction = e.getReportedUserAction();
    }

    @Override
    public String toString() {
        return "UnexpectedExceptionResponse{" + super.toString() + "relatedHTTPCode=" + this.relatedHTTPCode + ", exceptionClassName='" + this.exceptionClassName + '\'' + ", exceptionErrorMessage='" + this.exceptionErrorMessage + '\'' + ", exceptionSystemAction='" + this.exceptionSystemAction + '\'' + ", exceptionUserAction='" + this.exceptionUserAction + '\'' + "category=" + (Object)((Object)this.responseCategory) + '}';
    }

    public String getExceptionClassName() {
        return this.exceptionClassName;
    }

    public void setExceptionClassName(String exceptionClassName) {
        this.exceptionClassName = exceptionClassName;
    }

    public String getExceptionErrorMessage() {
        return this.exceptionErrorMessage;
    }

    public void setExceptionErrorMessage(String exceptionErrorMessage) {
        this.exceptionErrorMessage = exceptionErrorMessage;
    }

    public String getExceptionSystemAction() {
        return this.exceptionSystemAction;
    }

    public void setExceptionSystemAction(String exceptionSystemAction) {
        this.exceptionSystemAction = exceptionSystemAction;
    }

    public String getExceptionUserAction() {
        return this.exceptionUserAction;
    }

    public void setExceptionUserAction(String exceptionUserAction) {
        this.exceptionUserAction = exceptionUserAction;
    }
}

