/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.Classification;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.OmasObject;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.SystemAttributes;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.NodeType;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.nodesummary.IconSummary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class Node
implements Serializable,
OmasObject {
    private static final Logger log = LoggerFactory.getLogger(Node.class);
    private static final String className = Node.class.getName();
    protected NodeType nodeType = NodeType.Unknown;
    private String name = null;
    private String qualifiedName = null;
    private SystemAttributes systemAttributes = null;
    private Date effectiveFromTime = null;
    private Date effectiveToTime = null;
    private String description = null;
    protected List<Classification> classifications = null;
    private Set<IconSummary> icons = null;
    private Map<String, String> additionalProperties;

    public NodeType getNodeType() {
        return this.nodeType;
    }

    public void setNodeType(NodeType nodeType) {
        this.nodeType = nodeType;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getQualifiedName() {
        return this.qualifiedName;
    }

    public void setQualifiedName(String qualifiedName) {
        this.qualifiedName = qualifiedName;
    }

    public SystemAttributes getSystemAttributes() {
        return this.systemAttributes;
    }

    public void setSystemAttributes(SystemAttributes systemAttributes) {
        this.systemAttributes = systemAttributes;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<Classification> getClassifications() {
        if (this.classifications == null) {
            this.classifications = new ArrayList<Classification>();
        }
        return this.classifications;
    }

    public void setClassifications(List<Classification> classifications) {
        this.classifications = classifications;
    }

    public Set<IconSummary> getIcons() {
        return this.icons;
    }

    public void setIcons(Set<IconSummary> icons) {
        this.icons = icons;
    }

    public Date getEffectiveFromTime() {
        return this.effectiveFromTime;
    }

    public void setEffectiveFromTime(Date effectiveFromTime) {
        this.effectiveFromTime = effectiveFromTime;
    }

    public Date getEffectiveToTime() {
        return this.effectiveToTime;
    }

    public void setEffectiveToTime(Date effectiveToTime) {
        this.effectiveToTime = effectiveToTime;
    }

    public StringBuilder toString(StringBuilder sb) {
        if (sb == null) {
            sb = new StringBuilder();
        }
        sb.append("Node{");
        if (this.name != null) {
            sb.append("name='").append(this.name).append('\'');
        }
        if (this.qualifiedName != null) {
            sb.append(", qualifiedName='").append(this.qualifiedName).append('\'');
        }
        if (this.description != null) {
            sb.append(", description=").append(this.description);
        }
        if (this.icons != null) {
            sb.append(", icon='").append(this.icons).append('\'');
        }
        if (this.effectiveFromTime != null) {
            sb.append(", effective from date='").append(this.effectiveFromTime).append('\'');
        }
        if (this.effectiveToTime != null) {
            sb.append(", effective to date='").append(this.effectiveToTime).append('\'');
        }
        sb.append('}');
        return sb;
    }

    public String toString() {
        return this.toString(new StringBuilder()).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Node node = (Node)o;
        if (!Objects.equals(this.name, node.name)) {
            return false;
        }
        if (!Objects.equals(this.qualifiedName, node.qualifiedName)) {
            return false;
        }
        if (!Objects.equals(this.description, node.description)) {
            return false;
        }
        if (!Objects.equals(this.effectiveFromTime, node.effectiveFromTime)) {
            return false;
        }
        if (!Objects.equals(this.effectiveToTime, node.effectiveToTime)) {
            return false;
        }
        return Objects.equals(this.icons, node.icons);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.qualifiedName != null ? this.qualifiedName.hashCode() : 0);
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.effectiveFromTime != null ? this.effectiveFromTime.hashCode() : 0);
        result = 31 * result + (this.effectiveToTime != null ? this.effectiveToTime.hashCode() : 0);
        result = 31 * result + (this.icons != null ? this.icons.hashCode() : 0);
        return result;
    }

    protected void processClassification(Classification classification) {
    }

    public void setAdditionalProperties(Map<String, String> additionalProperties) {
        this.additionalProperties = additionalProperties;
    }

    public Map<String, String> getAdditionalProperties() {
        return this.additionalProperties;
    }
}

