/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.responses;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponseBase;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class SubjectAreaOMASAPIResponse<R>
extends FFDCResponseBase {
    private List<R> result = new ArrayList<R>();

    public void addAllResults(Collection<? extends R> entities) {
        this.result.addAll(entities);
    }

    public void addResult(R entity) {
        this.result.add(entity);
    }

    public void setExceptionInfo(OCFCheckedExceptionBase e, String className) {
        super.setRelatedHTTPCode(e.getReportedHTTPCode());
        super.setExceptionClassName(className);
        super.setActionDescription(e.getReportingActionDescription());
        super.setExceptionUserAction(e.getReportedUserAction());
        super.setExceptionErrorMessage(e.getReportedErrorMessage());
        super.setExceptionSystemAction(e.getReportedSystemAction());
        super.setExceptionProperties(e.getRelatedProperties());
    }

    @JsonIgnore
    public R getHead() {
        if (!this.result.isEmpty()) {
            return this.getResult().get(0);
        }
        return null;
    }

    public List<R> getResult() {
        return new ArrayList<R>(this.result);
    }
}

