/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.io.Serializable;
import java.util.Map;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.OmasObject;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.SystemAttributes;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.RelationshipEnd;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.RelationshipType;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.Antonym;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.Categorization;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.CategoryAnchor;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.CategoryHierarchyLink;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.HasA;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.IsA;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.IsATypeOf;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.LibraryCategoryReference;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.LibraryTermReference;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.PreferredTerm;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.ProjectScope;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.RelatedTerm;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.ReplacementTerm;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.SemanticAssignment;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.Synonym;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.TermAnchor;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.Translation;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.TypedBy;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.UsedInContext;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.ValidValue;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="class", defaultImpl=Relationship.class, visible=true)
@JsonSubTypes(value={@JsonSubTypes.Type(value=HasA.class), @JsonSubTypes.Type(value=RelatedTerm.class), @JsonSubTypes.Type(value=Synonym.class), @JsonSubTypes.Type(value=Antonym.class), @JsonSubTypes.Type(value=PreferredTerm.class), @JsonSubTypes.Type(value=ReplacementTerm.class), @JsonSubTypes.Type(value=Translation.class), @JsonSubTypes.Type(value=IsA.class), @JsonSubTypes.Type(value=ValidValue.class), @JsonSubTypes.Type(value=UsedInContext.class), @JsonSubTypes.Type(value=IsATypeOf.class), @JsonSubTypes.Type(value=TypedBy.class), @JsonSubTypes.Type(value=TermAnchor.class), @JsonSubTypes.Type(value=CategoryAnchor.class), @JsonSubTypes.Type(value=Categorization.class), @JsonSubTypes.Type(value=SemanticAssignment.class), @JsonSubTypes.Type(value=LibraryCategoryReference.class), @JsonSubTypes.Type(value=LibraryTermReference.class), @JsonSubTypes.Type(value=ProjectScope.class), @JsonSubTypes.Type(value=CategoryHierarchyLink.class)})
public abstract class Relationship
implements Serializable,
OmasObject {
    protected static final long serialVersionUID = 1L;
    private SystemAttributes systemAttributes = null;
    private Long effectiveFromTime = null;
    private Long effectiveToTime = null;
    private Map<String, String> additionalProperties;
    protected RelationshipType relationshipType;
    private boolean readOnly = false;
    protected String name;
    protected RelationshipEnd end1;
    protected RelationshipEnd end2;

    protected Relationship(String name, RelationshipEnd end1, RelationshipEnd end2) {
        this.end1 = new RelationshipEnd(end1);
        this.end2 = new RelationshipEnd(end2);
        this.name = name;
        this.initialise();
    }

    protected void initialise() {
        try {
            this.relationshipType = RelationshipType.valueOf(this.name);
        }
        catch (IllegalArgumentException e) {
            this.relationshipType = RelationshipType.Unknown;
        }
    }

    public RelationshipType getRelationshipType() {
        return this.relationshipType;
    }

    public void setRelationshipType(RelationshipType relationshipType) {
        this.relationshipType = relationshipType;
    }

    public SystemAttributes getSystemAttributes() {
        return this.systemAttributes;
    }

    public void setSystemAttributes(SystemAttributes systemAttributes) {
        this.systemAttributes = systemAttributes;
    }

    public Long getEffectiveFromTime() {
        return this.effectiveFromTime;
    }

    public void setEffectiveFromTime(Long effectiveFromTime) {
        this.effectiveFromTime = effectiveFromTime;
    }

    public Long getEffectiveToTime() {
        return this.effectiveToTime;
    }

    public void setEffectiveToTime(Long effectiveToTime) {
        this.effectiveToTime = effectiveToTime;
    }

    public String getGuid() {
        if (this.systemAttributes == null) {
            return null;
        }
        return this.systemAttributes.getGUID();
    }

    public void setGuid(String guid) {
        if (this.systemAttributes == null) {
            this.systemAttributes = new SystemAttributes();
        }
        this.systemAttributes.setGUID(guid);
    }

    public String getName() {
        return this.name;
    }

    public Map<String, String> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public void setAdditionalProperties(Map<String, String> additionalProperties) {
        this.additionalProperties = additionalProperties;
    }

    public RelationshipEnd getEnd1() {
        return this.end1;
    }

    public void setEnd1(RelationshipEnd end1) {
        this.end1 = end1;
    }

    public RelationshipEnd getEnd2() {
        return this.end2;
    }

    public void setEnd2(RelationshipEnd end2) {
        this.end2 = end2;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public StringBuilder toString(StringBuilder sb) {
        if (sb == null) {
            sb = new StringBuilder();
        }
        sb.append("Relationship{");
        sb.append("RelationshipType=").append(this.relationshipType.name()).append(",");
        sb.append("name=").append(this.name);
        if (this.systemAttributes != null) {
            sb.append("systemAttributes { ");
            sb = this.systemAttributes.toString(sb);
            sb.append("}");
        }
        sb.append('}');
        return sb;
    }

    public String toString() {
        return this.toString(null).toString();
    }
}

