/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Node;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Relationship;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class Graph
implements Serializable {
    private Map<String, Node> nodes = null;
    private Map<String, Relationship> relationships = null;
    private String rootNodeGuid = null;
    private String nodeFilter = null;
    private String relationshipFilter = null;

    public Map<String, Node> getNodes() {
        return this.nodes;
    }

    public void setNodes(Map<String, Node> nodes) {
        this.nodes = nodes;
    }

    public Map<String, Relationship> getRelationships() {
        return this.relationships;
    }

    public void setRelationships(Map<String, Relationship> relationships) {
        this.relationships = relationships;
    }

    public String getRootNodeGuid() {
        return this.rootNodeGuid;
    }

    public void setRootNodeGuid(String rootNodeGuid) {
        this.rootNodeGuid = rootNodeGuid;
    }

    public String getNodeFilter() {
        return this.nodeFilter;
    }

    public void setNodeFilter(String nodeFilter) {
        this.nodeFilter = nodeFilter;
    }

    public String getRelationshipFilter() {
        return this.relationshipFilter;
    }

    public void setRelationshipFilter(String relationshipFilter) {
        this.relationshipFilter = relationshipFilter;
    }

    public String toString(StringBuilder sb) {
        Set<String> guids;
        if (sb == null) {
            sb = new StringBuilder();
        }
        sb.append("NodeGUID=" + this.rootNodeGuid + "\n");
        sb.append("NodeTypeFilter=" + this.nodeFilter == null || this.nodeFilter == "" ? "none" : this.nodeFilter + "\n");
        sb.append("relationshipTypeFilter=" + this.relationshipFilter == null || this.relationshipFilter == "" ? "none" : this.relationshipFilter + "\n");
        if (this.nodes != null && !this.nodes.isEmpty()) {
            sb.append("Nodes= [\n");
            guids = this.nodes.keySet();
            for (String guid : guids) {
                this.nodes.get(guid).toString(sb);
            }
            sb.append("]\n");
        }
        if (this.relationships != null && !this.relationships.isEmpty()) {
            sb.append("Relationships= [\n");
            guids = this.relationships.keySet();
            for (String guid : guids) {
                this.relationships.get(guid).toString(sb);
            }
            sb.append("]\n");
        }
        sb.append('}');
        return sb.toString();
    }

    public String toString() {
        return this.toString(new StringBuilder());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Graph graph = (Graph)o;
        return Objects.equals(this.rootNodeGuid, graph.getRootNodeGuid()) && Objects.equals(this.nodes, graph.nodes) && Objects.equals(this.relationships, graph.relationships) && Objects.equals(this.nodeFilter, graph.nodeFilter) && Objects.equals(this.relationshipFilter, graph.relationshipFilter);
    }

    public int hashCode() {
        return Objects.hash(this.rootNodeGuid, this.nodes, this.relationships, this.nodeFilter, this.relationshipFilter);
    }
}

