/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.properties.objects.term;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.Classification;
import org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.ObjectIdentifier;
import org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.SpineAttribute;
import org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.SpineObject;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.governednode.GovernedNode;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.NodeType;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.nodesummary.CategorySummary;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.nodesummary.GlossarySummary;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.term.Activity;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="class", defaultImpl=Term.class, visible=true)
@JsonSubTypes(value={@JsonSubTypes.Type(value=Activity.class, name="Activity")})
public class Term
extends GovernedNode
implements Serializable {
    private String summary = null;
    private String abbreviation = null;
    private String examples = null;
    private String usage = null;
    private GlossarySummary glossary = null;
    private List<CategorySummary> categories = null;
    @JsonProperty(value="spineObject")
    private boolean spineObject = false;
    @JsonProperty(value="spineAttribute")
    private boolean spineAttribute = false;
    @JsonProperty(value="objectIdentifier")
    private boolean objectIdentifier = false;

    public Term() {
        this.nodeType = NodeType.Term;
    }

    public GlossarySummary getGlossary() {
        return this.glossary;
    }

    public void setGlossary(GlossarySummary glossary) {
        this.glossary = glossary;
    }

    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public String getAbbreviation() {
        return this.abbreviation;
    }

    public void setAbbreviation(String abbreviation) {
        this.abbreviation = abbreviation;
    }

    public String getExamples() {
        return this.examples;
    }

    public void setExamples(String examples) {
        this.examples = examples;
    }

    public String getUsage() {
        return this.usage;
    }

    public void setUsage(String usage) {
        this.usage = usage;
    }

    public boolean isSpineObject() {
        return this.spineObject;
    }

    public void setSpineObject(boolean spineObject) {
        this.spineObject = spineObject;
    }

    public boolean isSpineAttribute() {
        return this.spineAttribute;
    }

    public void setSpineAttribute(boolean spineAttribute) {
        this.spineAttribute = spineAttribute;
    }

    public boolean isObjectIdentifier() {
        return this.objectIdentifier;
    }

    public void setObjectIdentifier(boolean objectIdentifier) {
        this.objectIdentifier = objectIdentifier;
    }

    public List<CategorySummary> getCategories() {
        return this.categories;
    }

    public void setCategories(List<CategorySummary> categories) {
        this.categories = categories;
    }

    @Override
    public StringBuilder toString(StringBuilder sb) {
        if (sb == null) {
            sb = new StringBuilder();
        }
        sb.append("term=");
        sb.append((CharSequence)super.toString(sb));
        sb.append("Term Attributes{");
        sb.append("Summary=").append(this.summary);
        sb.append("Examples=").append(this.examples);
        sb.append("Abbreviation=").append(this.abbreviation);
        sb.append("Usage=").append(this.usage);
        sb.append("Glossary").append(this.glossary);
        if (this.categories != null && this.categories.size() > 0) {
            sb.append("Categories: [");
            for (CategorySummary categorySummary : this.categories) {
                sb.append("Category=" + categorySummary);
            }
            sb.append("]");
        }
        sb.append(this.getGovernanceClassifications());
        sb.append(", SpineInformation=[");
        if (this.spineObject) {
            sb.append("SpineObject ");
        }
        if (this.spineAttribute) {
            sb.append("SpineAttribute ");
        }
        if (this.objectIdentifier) {
            sb.append("SpineIdentifier");
        }
        sb.append("]");
        if (this.glossary != null) {
            sb.append(", glossary:").append(this.glossary.toString());
        }
        sb.append('}');
        return sb;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Term term = (Term)o;
        return this.spineObject == term.spineObject && this.spineAttribute == term.spineAttribute && this.objectIdentifier == term.objectIdentifier && Objects.equals(this.categories, term.categories) && Objects.equals(this.summary, term.summary) && Objects.equals(this.abbreviation, term.abbreviation) && Objects.equals(this.usage, term.usage) && Objects.equals(this.getGovernanceClassifications(), term.getGovernanceClassifications()) && Objects.equals(this.glossary, term.glossary);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.summary, this.usage, this.abbreviation, this.glossary, this.spineObject, this.spineAttribute, this.objectIdentifier, this.categories, this.getGovernanceClassifications());
    }

    @Override
    protected void processClassification(Classification classification) {
        String classificationName = new SpineObject().getClassificationName();
        if (classification.getClassificationName().equals(classificationName)) {
            this.spineObject = true;
        }
        classificationName = new SpineAttribute().getClassificationName();
        if (classification.getClassificationName().equals(classificationName)) {
            this.spineAttribute = true;
        }
        classificationName = new ObjectIdentifier().getClassificationName();
        if (classification.getClassificationName().equals(classificationName)) {
            this.objectIdentifier = true;
        }
    }
}

