/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.OmasObject;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.SystemAttributes;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.LineEnd;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.LineType;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.Antonym;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.Categorization;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.CategoryAnchor;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.HasA;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.IsA;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.IsATypeOf;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.LibraryCategoryReference;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.LibraryTermReference;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.PreferredTerm;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.ProjectScope;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.RelatedTerm;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.ReplacementTerm;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.SemanticAssignment;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.Synonym;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.TermAnchor;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.Translation;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.TypedBy;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.UsedInContext;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.ValidValue;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="class", defaultImpl=Line.class, visible=true)
@JsonSubTypes(value={@JsonSubTypes.Type(value=HasA.class), @JsonSubTypes.Type(value=RelatedTerm.class), @JsonSubTypes.Type(value=Synonym.class), @JsonSubTypes.Type(value=Antonym.class), @JsonSubTypes.Type(value=PreferredTerm.class), @JsonSubTypes.Type(value=ReplacementTerm.class), @JsonSubTypes.Type(value=Translation.class), @JsonSubTypes.Type(value=IsA.class), @JsonSubTypes.Type(value=ValidValue.class), @JsonSubTypes.Type(value=UsedInContext.class), @JsonSubTypes.Type(value=IsATypeOf.class), @JsonSubTypes.Type(value=TypedBy.class), @JsonSubTypes.Type(value=TermAnchor.class), @JsonSubTypes.Type(value=CategoryAnchor.class), @JsonSubTypes.Type(value=Categorization.class), @JsonSubTypes.Type(value=SemanticAssignment.class), @JsonSubTypes.Type(value=LibraryCategoryReference.class), @JsonSubTypes.Type(value=LibraryTermReference.class), @JsonSubTypes.Type(value=ProjectScope.class)})
public abstract class Line
implements Serializable,
OmasObject {
    protected static final long serialVersionUID = 1L;
    private SystemAttributes systemAttributes = null;
    private Date effectiveFromTime = null;
    private Date effectiveToTime = null;
    private Map<String, String> additionalProperties;
    protected String typeDefGuid;
    protected LineType lineType;
    protected String name;
    protected LineEnd end1;
    protected LineEnd end2;

    protected Line(String name, String typeDefGuid, LineEnd end1, LineEnd end2) {
        this.end1 = end1;
        this.end2 = end2;
        this.name = name;
        this.typeDefGuid = typeDefGuid;
        this.initialise();
    }

    protected void initialise() {
        try {
            this.lineType = LineType.valueOf(this.name);
        }
        catch (IllegalArgumentException e) {
            this.lineType = LineType.Unknown;
        }
    }

    public LineType getLineType() {
        return this.lineType;
    }

    public void setLineType(LineType lineType) {
        this.lineType = lineType;
    }

    public SystemAttributes getSystemAttributes() {
        return this.systemAttributes;
    }

    public void setSystemAttributes(SystemAttributes systemAttributes) {
        this.systemAttributes = systemAttributes;
    }

    public Date getEffectiveFromTime() {
        return this.effectiveFromTime;
    }

    public void setEffectiveFromTime(Date effectiveFromTime) {
        this.effectiveFromTime = effectiveFromTime;
    }

    public Date getEffectiveToTime() {
        return this.effectiveToTime;
    }

    public void setEffectiveToTime(Date effectiveToTime) {
        this.effectiveToTime = effectiveToTime;
    }

    public String getGuid() {
        if (this.systemAttributes == null) {
            return null;
        }
        return this.systemAttributes.getGUID();
    }

    public void setGuid(String guid) {
        if (this.systemAttributes == null) {
            this.systemAttributes = new SystemAttributes();
        }
        this.systemAttributes.setGUID(guid);
    }

    public String getName() {
        return this.name;
    }

    public Map<String, String> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public void setAdditionalProperties(Map<String, String> additionalProperties) {
        this.additionalProperties = additionalProperties;
    }

    public LineEnd getEnd1() {
        return this.end1;
    }

    public void setEnd1(LineEnd end1) {
        this.end1 = end1;
    }

    public LineEnd getEnd2() {
        return this.end2;
    }

    public void setEnd2(LineEnd end2) {
        this.end2 = end2;
    }

    public StringBuilder toString(StringBuilder sb) {
        if (sb == null) {
            sb = new StringBuilder();
        }
        sb.append("Line{");
        sb.append("lineType=").append(this.lineType.name()).append(",");
        sb.append("name=").append(this.name);
        if (this.systemAttributes != null) {
            sb.append("systemAttributes { ");
            sb = this.systemAttributes.toString(sb);
            sb.append("}");
        }
        sb.append('}');
        return sb;
    }

    public String toString() {
        return this.toString(null).toString();
    }
}

