/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Date;
import java.util.Objects;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class FindRequest {
    private String searchCriteria = null;
    private String sequencingProperty = null;
    private SequencingOrder sequencingOrder = null;
    private int startingFrom = 0;
    private Integer pageSize = null;
    private Date asOfTime;

    public FindRequest() {
    }

    public FindRequest(FindRequest template) {
        if (template != null) {
            this.searchCriteria = template.getSearchCriteria();
            this.sequencingProperty = template.getSequencingProperty();
            this.sequencingOrder = template.getSequencingOrder();
            this.asOfTime = template.getAsOfTime();
            this.startingFrom = template.getStartingFrom();
            this.pageSize = this.getPageSize();
        }
    }

    public String getSearchCriteria() {
        return this.searchCriteria;
    }

    public void setSearchCriteria(String searchCriteria) {
        this.searchCriteria = searchCriteria;
    }

    public String getSequencingProperty() {
        return this.sequencingProperty;
    }

    public void setSequencingProperty(String sequencingProperty) {
        this.sequencingProperty = sequencingProperty;
    }

    public SequencingOrder getSequencingOrder() {
        return this.sequencingOrder;
    }

    public void setSequencingOrder(SequencingOrder sequencingOrder) {
        this.sequencingOrder = sequencingOrder;
    }

    public int getStartingFrom() {
        return this.startingFrom;
    }

    public void setStartingFrom(int startingFrom) {
        this.startingFrom = startingFrom;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public Date getAsOfTime() {
        return this.asOfTime;
    }

    public void setAsOfTime(Date asOfTime) {
        this.asOfTime = asOfTime;
    }

    public String toString() {
        return "OMRSAPIPagedFindRequest{sequencingProperty='" + this.sequencingProperty + "', sequencingOrder=" + this.sequencingOrder + ", startingFrom=" + this.startingFrom + ", pageSize=" + this.pageSize + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FindRequest that = (FindRequest)o;
        return this.startingFrom == that.startingFrom && this.pageSize == that.pageSize && Objects.equals(this.searchCriteria, that.searchCriteria) && Objects.equals(this.sequencingProperty, that.sequencingProperty) && this.sequencingOrder == that.sequencingOrder && Objects.equals(this.asOfTime, that.asOfTime);
    }

    public int hashCode() {
        return Objects.hash(this.searchCriteria, this.sequencingProperty, this.sequencingOrder, this.startingFrom, this.pageSize, this.asOfTime);
    }
}

