/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.ffdc;

import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogMessageDefinition;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogMessageSet;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogRecordSeverity;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLogRecordSeverity;

public enum SubjectAreaAuditCode implements AuditLogMessageSet
{
    SERVICE_INITIALIZING("OMAS-SUBJECT_AREA-0001", OMRSAuditLogRecordSeverity.STARTUP, "The Subject Area Open Metadata Access Service (OMAS) is initializing a new server instance", "The local server has started up a new instance of the Subject Area OMAS.  This service enables tools to locate assets in the catalog, retrieve information about themand create open connectors to access the content of the assets.  It also sends events on its out topic each time a new asset is created or updated.", "No action is required as long as this service is expected to be started for this server.  If it is not required, then remove the configuration for this service from the access service list in this server's configuration document."),
    SERVICE_INITIALIZED("OMAS-SUBJECT_AREA-0003", OMRSAuditLogRecordSeverity.STARTUP, "The Subject Area Open Metadata Access Service (OMAS) has initialized a new instance for server {0}", "The access service has completed initialization of a new instance.", "Verify that this service has initialized successfully. Investigate any reported errors. Also ensure that the enterprise repository services and the OCF metadata management services are initialized."),
    SERVICE_SHUTDOWN("OMAS-SUBJECT_AREA-0004", OMRSAuditLogRecordSeverity.SHUTDOWN, "The Subject Area Open Metadata Access Service (OMAS) is shutting down its instance for server {0}", "The local administrator has requested shut down of an Subject Area OMAS instance.", "No action is required if the server shutdown was intentional."),
    SERVICE_INSTANCE_FAILURE("OMAS-SUBJECT_AREA-0005", OMRSAuditLogRecordSeverity.EXCEPTION, "The Subject Area Open Metadata Access Service (OMAS) is unable to initialize a new instance in server {0}; the {1} exception occurred with error message: {2}", "The access service detected an error during the start up of a specific server instance.  Its services are not available for the server.", "Review the error message and any other reported failures to determine the cause of the problem.  Once this is resolved, restart the server."),
    UNEXPECTED_EXCEPTION("OMAS-SUBJECT_AREA-0006", OMRSAuditLogRecordSeverity.EXCEPTION, "The Open Metadata Service has generated an unexpected {0} exception during method {1}.  The message was: {2}", "The request returns a SubjectAreaCheckedException.", "This is probably a logic error. Review the stack trace to identify where the error occurred and work to resolve the cause.");

    private AuditLogMessageDefinition messageDefinition;

    private SubjectAreaAuditCode(String messageId, OMRSAuditLogRecordSeverity severity, String message, String systemAction, String userAction) {
        this.messageDefinition = new AuditLogMessageDefinition(messageId, (AuditLogRecordSeverity)severity, message, systemAction, userAction);
    }

    public AuditLogMessageDefinition getMessageDefinition() {
        return this.messageDefinition;
    }

    public AuditLogMessageDefinition getMessageDefinition(String ... params) {
        this.messageDefinition.setMessageParameters(params);
        return this.messageDefinition;
    }

    public String toString() {
        return "SubjectAreaAuditCode{messageDefinition=" + this.messageDefinition + "}";
    }
}

