/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.validators;

import org.odpi.openmetadata.accessservices.subjectarea.ffdc.SubjectAreaErrorCode;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.subjectarea.properties.enums.Status;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.NodeType;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.ExceptionMessageDefinition;

public class InputValidator {
    public static void validateRemoteServerURLNotNull(String className, String actionDescription, String omasServerURL) throws InvalidParameterException {
        if (omasServerURL == null) {
            ExceptionMessageDefinition messageDefinition = SubjectAreaErrorCode.SERVER_URL_NOT_SPECIFIED.getMessageDefinition();
            String invalidPropertyName = "omasServerURL";
            messageDefinition.setMessageParameters(new String[]{invalidPropertyName, null});
            throw new InvalidParameterException(messageDefinition, className, actionDescription, invalidPropertyName, null);
        }
    }

    public static void validateRemoteServerNameNotNull(String className, String actionDescription, String omasServerName) throws InvalidParameterException {
        if (omasServerName == null) {
            ExceptionMessageDefinition messageDefinition = SubjectAreaErrorCode.SERVER_NAME_NOT_SPECIFIED.getMessageDefinition();
            String invalidPropertyName = "omasServerName";
            messageDefinition.setMessageParameters(new String[]{invalidPropertyName, null});
            throw new InvalidParameterException(messageDefinition, className, actionDescription, invalidPropertyName, null);
        }
    }

    public static void validateUserIdNotNull(String className, String actionDescription, String userId) throws InvalidParameterException {
        if (userId == null) {
            ExceptionMessageDefinition messageDefinition = SubjectAreaErrorCode.NULL_USER_ID.getMessageDefinition();
            String invalidPropertyName = "userId";
            messageDefinition.setMessageParameters(new String[]{invalidPropertyName, null});
            throw new InvalidParameterException(messageDefinition, className, actionDescription, invalidPropertyName, null);
        }
    }

    public static Status validateStatusAndCheckNotDeleted(String className, String actionDescription, String statusName) throws InvalidParameterException {
        Status newStatus = null;
        try {
            newStatus = Status.valueOf(statusName);
        }
        catch (Exception e) {
            ExceptionMessageDefinition messageDefinition = SubjectAreaErrorCode.INVALID_STATUS_VALUE_SUPPLIED.getMessageDefinition();
            String invalidPropertyName = "status";
            messageDefinition.setMessageParameters(new String[]{invalidPropertyName, null});
            throw new InvalidParameterException(messageDefinition, className, actionDescription, invalidPropertyName, statusName);
        }
        if (Status.DELETED == newStatus) {
            ExceptionMessageDefinition messageDefinition = SubjectAreaErrorCode.STATUS_UPDATE_TO_DELETED_NOT_ALLOWED.getMessageDefinition();
            String invalidPropertyName = "status";
            messageDefinition.setMessageParameters(new String[]{invalidPropertyName, null});
            throw new InvalidParameterException(messageDefinition, className, actionDescription, invalidPropertyName, statusName);
        }
        return newStatus;
    }

    public static void validateGUIDNotNull(String className, String actionDescription, String guid, String guidParameter) throws InvalidParameterException {
        if (guid == null) {
            ExceptionMessageDefinition messageDefinition = SubjectAreaErrorCode.NULL_GUID.getMessageDefinition();
            String invalidPropertyName = "guid";
            messageDefinition.setMessageParameters(new String[]{invalidPropertyName, null});
            throw new InvalidParameterException(messageDefinition, className, actionDescription, invalidPropertyName, null);
        }
    }

    public static void validateNameNotNull(String className, String actionDescription, String name, String nameParameter) throws InvalidParameterException {
        if (name == null) {
            ExceptionMessageDefinition messageDefinition = SubjectAreaErrorCode.NULL_NAME.getMessageDefinition();
            messageDefinition.setMessageParameters(new String[]{nameParameter, null});
            throw new InvalidParameterException(messageDefinition, className, actionDescription, nameParameter, null);
        }
    }

    public static void validateNodeType(Object ... args) throws InvalidParameterException {
        if (args.length < 4) {
            return;
        }
        boolean isValid = false;
        String className = (String)args[0];
        String actionDescription = (String)args[1];
        NodeType nodeTypeToCheck = (NodeType)args[2];
        if (nodeTypeToCheck != null) {
            for (int i = 3; i < args.length; ++i) {
                if (!nodeTypeToCheck.equals(args[i])) continue;
                isValid = true;
            }
            if (!isValid) {
                ExceptionMessageDefinition messageDefinition = SubjectAreaErrorCode.INVALID_NODETYPE.getMessageDefinition();
                String invalidPropertyName = "nodeType";
                messageDefinition.setMessageParameters(new String[]{invalidPropertyName, null});
                throw new InvalidParameterException(messageDefinition, className, actionDescription, invalidPropertyName, nodeTypeToCheck.name());
            }
        }
    }
}

