/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.client;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.odpi.openmetadata.accessservices.subjectarea.SubjectAreaGlossary;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.SubjectAreaErrorCode;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.ClassificationException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.EntityNotDeletedException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.FunctionNotSupportedException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.GUIDNotPurgedException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.MetadataServerUncontactableException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.UnexpectedResponseException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.UnrecognizedGUIDException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.UnrecognizedNameException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.UserNotAuthorizedException;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.glossary.Glossary;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.node.NodeType;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SubjectAreaOMASAPIResponse;
import org.odpi.openmetadata.accessservices.subjectarea.utils.DetectUtils;
import org.odpi.openmetadata.accessservices.subjectarea.utils.RestCaller;
import org.odpi.openmetadata.accessservices.subjectarea.validators.InputValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubjectAreaGlossaryImpl
implements SubjectAreaGlossary {
    private static final Logger log = LoggerFactory.getLogger(SubjectAreaGlossaryImpl.class);
    private static final String className = SubjectAreaGlossaryImpl.class.getName();
    private static final String BASE_URL = "/users/%s/glossaries";
    private String omasServerURL;

    public SubjectAreaGlossaryImpl(String omasServerURL) {
        this.omasServerURL = omasServerURL;
    }

    @Override
    public Glossary createGlossary(String userid, Glossary suppliedGlossary) throws MetadataServerUncontactableException, InvalidParameterException, UserNotAuthorizedException, UnrecognizedGUIDException, ClassificationException, FunctionNotSupportedException, UnexpectedResponseException {
        String methodName = "createGlossary";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: createGlossary,userid=" + userid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"createGlossary", (String)userid);
        String url = this.omasServerURL + String.format(BASE_URL, userid);
        InputValidator.validateNodeType((Object[])new Object[]{className, "createGlossary", suppliedGlossary.getNodeType(), NodeType.Glossary, NodeType.Taxonomy, NodeType.TaxonomyAndCanonicalGlossary, NodeType.CanonicalGlossary});
        ObjectMapper mapper = new ObjectMapper();
        String requestBody = null;
        try {
            requestBody = mapper.writeValueAsString((Object)suppliedGlossary);
        }
        catch (JsonProcessingException error) {
            RestCaller.throwJsonParseError(className, "createGlossary", error);
        }
        SubjectAreaOMASAPIResponse restResponse = RestCaller.issuePost(className, "createGlossary", requestBody, url);
        DetectUtils.detectAndThrowUserNotAuthorizedException("createGlossary", restResponse);
        DetectUtils.detectAndThrowInvalidParameterException("createGlossary", restResponse);
        DetectUtils.detectAndThrowUnrecognizedGUIDException("createGlossary", restResponse);
        DetectUtils.detectAndThrowClassificationException("createGlossary", restResponse);
        DetectUtils.detectAndThrowFunctionNotSupportedException("createGlossary", restResponse);
        Glossary glossary = DetectUtils.detectAndReturnGlossary("createGlossary", restResponse);
        if (suppliedGlossary.getNodeType() != null && !suppliedGlossary.getNodeType().equals((Object)glossary.getNodeType())) {
            SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.UNEXPECTED_NODETYPE;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{"createGlossary", suppliedGlossary.getNodeType().name(), glossary.getNodeType().name()});
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), className, "createGlossary", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : createGlossary,userid=" + userid);
        }
        return glossary;
    }

    @Override
    public Glossary getGlossaryByGuid(String userid, String guid) throws MetadataServerUncontactableException, UnrecognizedGUIDException, UserNotAuthorizedException, InvalidParameterException, FunctionNotSupportedException, UnexpectedResponseException {
        String methodName = "getGlossaryByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getGlossaryByGuid,userid=" + userid + ",guid=" + guid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getGlossaryByGuid", (String)userid);
        InputValidator.validateGUIDNotNull((String)className, (String)"getGlossaryByGuid", (String)guid, (String)"guid");
        String urlTemplate = this.omasServerURL + BASE_URL + "/%s";
        String url = String.format(urlTemplate, userid, guid);
        SubjectAreaOMASAPIResponse restResponse = RestCaller.issueGet(className, "getGlossaryByGuid", url);
        DetectUtils.detectAndThrowUserNotAuthorizedException("getGlossaryByGuid", restResponse);
        DetectUtils.detectAndThrowInvalidParameterException("getGlossaryByGuid", restResponse);
        DetectUtils.detectAndThrowUnrecognizedGUIDException("getGlossaryByGuid", restResponse);
        DetectUtils.detectAndThrowFunctionNotSupportedException("getGlossaryByGuid", restResponse);
        Glossary glossary = DetectUtils.detectAndReturnGlossary("getGlossaryByGuid", restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getGlossaryByGuid,userid=" + userid);
        }
        return glossary;
    }

    public Glossary getGlossaryByName(String userid, String name) throws MetadataServerUncontactableException, UnrecognizedNameException, UserNotAuthorizedException, InvalidParameterException, FunctionNotSupportedException, UnexpectedResponseException {
        String methodName = "getGlossaryByName";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getGlossaryByName,userid=" + userid + ",name=" + name);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getGlossaryByName", (String)userid);
        InputValidator.validateNameNotNull((String)className, (String)"getGlossaryByName", (String)name, (String)"name");
        String urlTemplate = this.omasServerURL + BASE_URL + "/%s?isIdName=true";
        String url = String.format(urlTemplate, userid, name);
        SubjectAreaOMASAPIResponse restResponse = RestCaller.issueGet(className, "getGlossaryByName", url);
        DetectUtils.detectAndThrowUserNotAuthorizedException("getGlossaryByName", restResponse);
        DetectUtils.detectAndThrowInvalidParameterException("getGlossaryByName", restResponse);
        DetectUtils.detectAndThrowUnrecognizedNameException("getGlossaryByName", restResponse);
        DetectUtils.detectAndThrowFunctionNotSupportedException("getGlossaryByName", restResponse);
        Glossary glossary = DetectUtils.detectAndReturnGlossary("getGlossaryByName", restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getGlossaryByName,userid=" + userid);
        }
        return glossary;
    }

    @Override
    public Glossary replaceGlossary(String userid, String guid, Glossary suppliedGlossary) throws UnexpectedResponseException, UserNotAuthorizedException, UnrecognizedNameException, FunctionNotSupportedException, InvalidParameterException, MetadataServerUncontactableException {
        String methodName = "replaceGlossary";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: replaceGlossary,userid=" + userid + ",guid=" + guid);
        }
        Glossary glossary = this.updateGlossary(userid, guid, suppliedGlossary, true);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : replaceGlossary,userid=" + userid);
        }
        return glossary;
    }

    @Override
    public Glossary updateGlossary(String userid, String guid, Glossary suppliedGlossary) throws UnexpectedResponseException, UserNotAuthorizedException, UnrecognizedNameException, FunctionNotSupportedException, InvalidParameterException, MetadataServerUncontactableException {
        String methodName = "updateGlossary";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateGlossary,userid=" + userid + ",guid=" + guid);
        }
        Glossary glossary = this.updateGlossary(userid, guid, suppliedGlossary, false);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : updateGlossary,userid=" + userid);
        }
        return glossary;
    }

    private Glossary updateGlossary(String userid, String guid, Glossary suppliedGlossary, boolean isReplace) throws UserNotAuthorizedException, InvalidParameterException, UnrecognizedNameException, FunctionNotSupportedException, MetadataServerUncontactableException, UnexpectedResponseException {
        String methodName = "updateGlossary";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateGlossary,userid=" + userid + ",guid=" + guid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"updateGlossary", (String)userid);
        InputValidator.validateGUIDNotNull((String)className, (String)"updateGlossary", (String)guid, (String)"guid");
        String urlTemplate = this.omasServerURL + BASE_URL + "/%s?isReplace=%b";
        String url = String.format(urlTemplate, userid, guid, isReplace);
        ObjectMapper mapper = new ObjectMapper();
        String requestBody = null;
        try {
            requestBody = mapper.writeValueAsString((Object)suppliedGlossary);
        }
        catch (JsonProcessingException error) {
            RestCaller.throwJsonParseError(className, "updateGlossary", error);
        }
        SubjectAreaOMASAPIResponse restResponse = RestCaller.issuePut(className, "updateGlossary", requestBody, url);
        DetectUtils.detectAndThrowUserNotAuthorizedException("updateGlossary", restResponse);
        DetectUtils.detectAndThrowInvalidParameterException("updateGlossary", restResponse);
        DetectUtils.detectAndThrowUnrecognizedNameException("updateGlossary", restResponse);
        DetectUtils.detectAndThrowFunctionNotSupportedException("updateGlossary", restResponse);
        Glossary glossary = DetectUtils.detectAndReturnGlossary("updateGlossary", restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : updateGlossary,userid=" + userid);
        }
        return glossary;
    }

    @Override
    public Glossary deleteGlossary(String userid, String guid) throws InvalidParameterException, MetadataServerUncontactableException, UserNotAuthorizedException, UnrecognizedGUIDException, FunctionNotSupportedException, UnexpectedResponseException, EntityNotDeletedException {
        String methodName = "deleteGlossary";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteGlossary,userid=" + userid + ",guid=" + guid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"deleteGlossary", (String)userid);
        InputValidator.validateGUIDNotNull((String)className, (String)"deleteGlossary", (String)guid, (String)"guid");
        String urlTemplate = this.omasServerURL + BASE_URL + "/%s?isPurge=false";
        String url = String.format(urlTemplate, userid, guid);
        SubjectAreaOMASAPIResponse restResponse = RestCaller.issueDelete(className, "deleteGlossary", url);
        DetectUtils.detectAndThrowUserNotAuthorizedException("deleteGlossary", restResponse);
        DetectUtils.detectAndThrowInvalidParameterException("deleteGlossary", restResponse);
        DetectUtils.detectAndThrowUnrecognizedGUIDException("deleteGlossary", restResponse);
        DetectUtils.detectAndThrowFunctionNotSupportedException("deleteGlossary", restResponse);
        DetectUtils.detectAndThrowEntityNotDeletedException("deleteGlossary", restResponse);
        Glossary glossary = DetectUtils.detectAndReturnGlossary("deleteGlossary", restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : deleteGlossary,userid=" + userid);
        }
        return glossary;
    }

    @Override
    public void purgeGlossary(String userid, String guid) throws InvalidParameterException, UserNotAuthorizedException, MetadataServerUncontactableException, UnrecognizedGUIDException, GUIDNotPurgedException, UnexpectedResponseException {
        String methodName = "purgeGlossary";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: purgeGlossary,userid=" + userid + ",guid=" + guid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"purgeGlossary", (String)userid);
        InputValidator.validateGUIDNotNull((String)className, (String)"purgeGlossary", (String)guid, (String)"guid");
        String urlTemplate = this.omasServerURL + BASE_URL + "/%s?isPurge=false";
        String url = String.format(urlTemplate, userid, guid);
        SubjectAreaOMASAPIResponse restResponse = RestCaller.issueDelete(className, "purgeGlossary", url);
        DetectUtils.detectAndThrowUserNotAuthorizedException("purgeGlossary", restResponse);
        DetectUtils.detectAndThrowInvalidParameterException("purgeGlossary", restResponse);
        DetectUtils.detectAndThrowUnrecognizedGUIDException("purgeGlossary", restResponse);
        DetectUtils.detectAndThrowGUIDNotPurgedException("purgeGlossary", restResponse);
        Glossary glossary = DetectUtils.detectAndReturnGlossary("purgeGlossary", restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : purgeGlossary,userid=" + userid);
        }
    }
}

