/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.client;

import org.odpi.openmetadata.accessservices.subjectarea.SubjectArea;
import org.odpi.openmetadata.accessservices.subjectarea.SubjectAreaCategory;
import org.odpi.openmetadata.accessservices.subjectarea.SubjectAreaGlossary;
import org.odpi.openmetadata.accessservices.subjectarea.SubjectAreaTerm;
import org.odpi.openmetadata.accessservices.subjectarea.client.SubjectAreaCategoryImpl;
import org.odpi.openmetadata.accessservices.subjectarea.client.SubjectAreaGlossaryImpl;
import org.odpi.openmetadata.accessservices.subjectarea.client.SubjectAreaTermImpl;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.subjectarea.validators.InputValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubjectAreaImpl
implements SubjectArea {
    private static final Logger log = LoggerFactory.getLogger(SubjectAreaImpl.class);
    private static final String className = SubjectAreaImpl.class.getName();
    private final SubjectAreaTermImpl termAPI;
    private final SubjectAreaCategoryImpl categoryAPI;
    private final SubjectAreaGlossaryImpl glossaryAPI;
    private String omasServerURL = null;

    public SubjectAreaImpl(String omasServerURL) throws InvalidParameterException {
        String methodName = "SubjectAreaImpl";
        InputValidator.validateOMASServerURLNotNull((String)className, (String)methodName, (String)omasServerURL);
        this.omasServerURL = omasServerURL;
        this.glossaryAPI = new SubjectAreaGlossaryImpl(omasServerURL);
        this.termAPI = new SubjectAreaTermImpl(omasServerURL);
        this.categoryAPI = new SubjectAreaCategoryImpl(omasServerURL);
    }

    public SubjectAreaCategory getCategoryAPI() {
        return this.categoryAPI;
    }

    public SubjectAreaGlossary getGlossaryAPI() {
        return this.glossaryAPI;
    }

    public SubjectAreaTerm getTermAPI() {
        return this.termAPI;
    }

    @Override
    public SubjectAreaGlossary getSubjectAreaGlossary() {
        return this.glossaryAPI;
    }

    @Override
    public SubjectAreaTerm getSubjectAreaTerm() {
        return this.termAPI;
    }

    @Override
    public SubjectAreaCategory getSubjectAreaCategory() {
        return this.categoryAPI;
    }
}

