/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.client;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.odpi.openmetadata.accessservices.subjectarea.SubjectAreaTerm;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.ClassificationException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.EntityNotDeletedException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.FunctionNotSupportedException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.GUIDNotPurgedException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.MetadataServerUncontactableException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.UnexpectedResponseException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.UnrecognizedNameException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.UserNotAuthorizedException;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.term.Term;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SubjectAreaOMASAPIResponse;
import org.odpi.openmetadata.accessservices.subjectarea.utils.DetectUtils;
import org.odpi.openmetadata.accessservices.subjectarea.utils.RestCaller;
import org.odpi.openmetadata.accessservices.subjectarea.validators.InputValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubjectAreaTermImpl
implements SubjectAreaTerm {
    private static final Logger log = LoggerFactory.getLogger(SubjectAreaTermImpl.class);
    private static final String className = SubjectAreaTermImpl.class.getName();
    private static final String BASE_URL = "/users/%s/terms";
    private String omasServerURL = null;

    public SubjectAreaTermImpl(String omasServerURL) {
        this.omasServerURL = omasServerURL;
    }

    @Override
    public Term createTerm(String userId, Term suppliedTerm) throws MetadataServerUncontactableException, InvalidParameterException, UserNotAuthorizedException, ClassificationException, FunctionNotSupportedException, UnexpectedResponseException {
        String methodName = "createTerm";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: createTerm,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"createTerm", (String)userId);
        String url = this.omasServerURL + String.format(BASE_URL, userId);
        InputValidator.validateUserIdNotNull((String)className, (String)"createTerm", (String)userId);
        ObjectMapper mapper = new ObjectMapper();
        String requestBody = null;
        try {
            requestBody = mapper.writeValueAsString((Object)suppliedTerm);
        }
        catch (JsonProcessingException error) {
            RestCaller.throwJsonParseError(className, "createTerm", error);
        }
        SubjectAreaOMASAPIResponse restResponse = RestCaller.issuePost(className, "createTerm", requestBody, url);
        DetectUtils.detectAndThrowUserNotAuthorizedException("createTerm", restResponse);
        DetectUtils.detectAndThrowInvalidParameterException("createTerm", restResponse);
        DetectUtils.detectAndThrowClassificationException("createTerm", restResponse);
        DetectUtils.detectAndThrowFunctionNotSupportedException("createTerm", restResponse);
        Term term = DetectUtils.detectAndReturnTerm("createTerm", restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : createTerm,userId=" + userId);
        }
        return term;
    }

    @Override
    public Term getTermByGuid(String userId, String guid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, FunctionNotSupportedException, UnexpectedResponseException {
        String methodName = "getTermByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getTermByGuid,userId=" + userId + ",guid=" + guid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getTermByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getTermByGuid", (String)guid, (String)"guid");
        String urlTemplate = this.omasServerURL + BASE_URL + "/%s";
        String url = String.format(urlTemplate, userId, guid);
        SubjectAreaOMASAPIResponse restResponse = RestCaller.issueGet(className, "getTermByGuid", url);
        DetectUtils.detectAndThrowUserNotAuthorizedException("getTermByGuid", restResponse);
        DetectUtils.detectAndThrowInvalidParameterException("getTermByGuid", restResponse);
        DetectUtils.detectAndThrowFunctionNotSupportedException("getTermByGuid", restResponse);
        Term term = DetectUtils.detectAndReturnTerm("getTermByGuid", restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getTermByGuid,userId=" + userId);
        }
        return term;
    }

    @Override
    public Term replaceTerm(String userId, String guid, Term suppliedTerm) throws UnexpectedResponseException, UserNotAuthorizedException, UnrecognizedNameException, FunctionNotSupportedException, InvalidParameterException, MetadataServerUncontactableException {
        String methodName = "replaceTerm";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: replaceTerm,userId=" + userId + ",guid=" + guid);
        }
        Term term = this.updateTerm(userId, guid, suppliedTerm, true);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : replaceTerm,userId=" + userId);
        }
        return term;
    }

    @Override
    public Term updateTerm(String userId, String guid, Term suppliedTerm) throws UnexpectedResponseException, UserNotAuthorizedException, UnrecognizedNameException, FunctionNotSupportedException, InvalidParameterException, MetadataServerUncontactableException {
        String methodName = "updateTerm";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateTerm,userId=" + userId + ",guid=" + guid);
        }
        Term term = this.updateTerm(userId, guid, suppliedTerm, false);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : updateTerm,userId=" + userId);
        }
        return term;
    }

    private Term updateTerm(String userId, String guid, Term suppliedTerm, boolean isReplace) throws UserNotAuthorizedException, InvalidParameterException, UnrecognizedNameException, FunctionNotSupportedException, MetadataServerUncontactableException, UnexpectedResponseException {
        String methodName = "updateTerm";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateTerm,userId=" + userId + ",guid=" + guid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"updateTerm", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"updateTerm", (String)guid, (String)"guid");
        String urlTemplate = this.omasServerURL + BASE_URL + "/%s?isReplace=%b";
        String url = String.format(urlTemplate, userId, guid, isReplace);
        ObjectMapper mapper = new ObjectMapper();
        String requestBody = null;
        try {
            requestBody = mapper.writeValueAsString((Object)suppliedTerm);
        }
        catch (JsonProcessingException error) {
            RestCaller.throwJsonParseError(className, "updateTerm", error);
        }
        SubjectAreaOMASAPIResponse restResponse = RestCaller.issuePut(className, "updateTerm", requestBody, url);
        DetectUtils.detectAndThrowUserNotAuthorizedException("updateTerm", restResponse);
        DetectUtils.detectAndThrowInvalidParameterException("updateTerm", restResponse);
        DetectUtils.detectAndThrowUnrecognizedNameException("updateTerm", restResponse);
        DetectUtils.detectAndThrowFunctionNotSupportedException("updateTerm", restResponse);
        Term term = DetectUtils.detectAndReturnTerm("updateTerm", restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : updateTerm,userId=" + userId);
        }
        return term;
    }

    @Override
    public Term deleteTerm(String userId, String guid) throws InvalidParameterException, MetadataServerUncontactableException, UserNotAuthorizedException, FunctionNotSupportedException, UnexpectedResponseException, EntityNotDeletedException {
        String methodName = "deleteTerm";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteTerm,userId=" + userId + ",guid=" + guid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"deleteTerm", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"deleteTerm", (String)guid, (String)"guid");
        String urlTemplate = this.omasServerURL + BASE_URL + "/%s?isPurge=false";
        String url = String.format(urlTemplate, userId, guid);
        SubjectAreaOMASAPIResponse restResponse = RestCaller.issueDelete(className, "deleteTerm", url);
        DetectUtils.detectAndThrowUserNotAuthorizedException("deleteTerm", restResponse);
        DetectUtils.detectAndThrowInvalidParameterException("deleteTerm", restResponse);
        DetectUtils.detectAndThrowFunctionNotSupportedException("deleteTerm", restResponse);
        DetectUtils.detectAndThrowEntityNotDeletedException("deleteTerm", restResponse);
        Term term = DetectUtils.detectAndReturnTerm("deleteTerm", restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : deleteTerm,userId=" + userId);
        }
        return term;
    }

    @Override
    public void purgeTerm(String userId, String guid) throws InvalidParameterException, UserNotAuthorizedException, MetadataServerUncontactableException, GUIDNotPurgedException, UnexpectedResponseException {
        String methodName = "purgeTerm";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: purgeTerm,userId=" + userId + ",guid=" + guid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"purgeTerm", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"purgeTerm", (String)guid, (String)"guid");
        String urlTemplate = this.omasServerURL + BASE_URL + "/%s?isPurge=false";
        String url = String.format(urlTemplate, userId, guid);
        SubjectAreaOMASAPIResponse restResponse = RestCaller.issueDelete(className, "purgeTerm", url);
        DetectUtils.detectAndThrowUserNotAuthorizedException("purgeTerm", restResponse);
        DetectUtils.detectAndThrowInvalidParameterException("purgeTerm", restResponse);
        DetectUtils.detectAndThrowGUIDNotPurgedException("purgeTerm", restResponse);
        Term term = DetectUtils.detectAndReturnTerm("purgeTerm", restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : purgeTerm,userId=" + userId);
        }
    }
}

