/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.utils;

import org.odpi.openmetadata.accessservices.subjectarea.ffdc.SubjectAreaErrorCode;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.ClassificationException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.EntityNotDeletedException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.FunctionNotSupportedException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.GUIDNotPurgedException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.RelationshipNotDeletedException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.StatusNotSupportedException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.UnexpectedResponseException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.UnrecognizedGUIDException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.UnrecognizedNameException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.UserNotAuthorizedException;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.category.Category;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.glossary.Glossary;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.term.Term;
import org.odpi.openmetadata.accessservices.subjectarea.responses.CategoryResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.ClassificationExceptionResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.EntityNotDeletedExceptionResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.FunctionNotSupportedExceptionResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.GUIDNotPurgedExceptionResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.GlossaryResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.InvalidParameterExceptionResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.RelationshipNotDeletedExceptionResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.ResponseCategory;
import org.odpi.openmetadata.accessservices.subjectarea.responses.StatusNotsupportedExceptionResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SubjectAreaOMASAPIResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.TermResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.UnrecognizedGUIDExceptionResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.UnrecognizedNameExceptionResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.UserNotAuthorizedExceptionResponse;

public class DetectUtils {
    private static String className = "DetectUtils";

    public static void detectAndThrowInvalidParameterException(String methodName, SubjectAreaOMASAPIResponse restResponse) throws InvalidParameterException {
        if (restResponse != null && restResponse.getResponseCategory() == ResponseCategory.InvalidParameterException) {
            InvalidParameterExceptionResponse invalidParameterExceptionResponse = (InvalidParameterExceptionResponse)restResponse;
            throw new InvalidParameterException(restResponse.getRelatedHTTPCode(), className, methodName, invalidParameterExceptionResponse.getExceptionErrorMessage(), invalidParameterExceptionResponse.getExceptionSystemAction(), invalidParameterExceptionResponse.getExceptionUserAction());
        }
    }

    public static void detectAndThrowUnrecognizedGUIDException(String methodName, SubjectAreaOMASAPIResponse restResponse) throws UnrecognizedGUIDException {
        if (restResponse != null && restResponse.getResponseCategory() == ResponseCategory.UnrecognizedGUIDException) {
            UnrecognizedGUIDExceptionResponse unrecognizedGUIDExceptionResponse = (UnrecognizedGUIDExceptionResponse)restResponse;
            throw new UnrecognizedGUIDException(restResponse.getRelatedHTTPCode(), className, methodName, unrecognizedGUIDExceptionResponse.getExceptionErrorMessage(), unrecognizedGUIDExceptionResponse.getExceptionSystemAction(), unrecognizedGUIDExceptionResponse.getExceptionUserAction(), unrecognizedGUIDExceptionResponse.getGuid());
        }
    }

    public static void detectAndThrowClassificationException(String methodName, SubjectAreaOMASAPIResponse restResponse) throws ClassificationException {
        if (restResponse != null && restResponse.getResponseCategory() == ResponseCategory.ClassificationException) {
            ClassificationExceptionResponse classificationExceptionResponse = (ClassificationExceptionResponse)restResponse;
            throw new ClassificationException(restResponse.getRelatedHTTPCode(), className, methodName, classificationExceptionResponse.getExceptionErrorMessage(), classificationExceptionResponse.getExceptionSystemAction(), classificationExceptionResponse.getExceptionUserAction());
        }
    }

    public static void detectAndThrowEntityNotDeletedException(String methodName, SubjectAreaOMASAPIResponse restResponse) throws EntityNotDeletedException {
        if (restResponse != null && restResponse.getResponseCategory() == ResponseCategory.EntityNotDeletedException) {
            EntityNotDeletedExceptionResponse entityNotDeletedExceptionResponse = (EntityNotDeletedExceptionResponse)restResponse;
            throw new EntityNotDeletedException(restResponse.getRelatedHTTPCode(), className, methodName, entityNotDeletedExceptionResponse.getExceptionErrorMessage(), entityNotDeletedExceptionResponse.getExceptionSystemAction(), entityNotDeletedExceptionResponse.getExceptionUserAction(), entityNotDeletedExceptionResponse.getGuid());
        }
    }

    public static void detectAndThrowFunctionNotSupportedException(String methodName, SubjectAreaOMASAPIResponse restResponse) throws FunctionNotSupportedException {
        if (restResponse != null && restResponse.getResponseCategory() == ResponseCategory.FunctionNotSupportedException) {
            FunctionNotSupportedExceptionResponse functionNotSupportedExceptionResponse = (FunctionNotSupportedExceptionResponse)restResponse;
            throw new FunctionNotSupportedException(restResponse.getRelatedHTTPCode(), className, methodName, functionNotSupportedExceptionResponse.getExceptionErrorMessage(), functionNotSupportedExceptionResponse.getExceptionSystemAction(), functionNotSupportedExceptionResponse.getExceptionUserAction());
        }
    }

    public static void detectAndThrowGUIDNotPurgedException(String methodName, SubjectAreaOMASAPIResponse restResponse) throws GUIDNotPurgedException {
        if (restResponse != null && restResponse.getResponseCategory() == ResponseCategory.GUIDNotPurgedException) {
            GUIDNotPurgedExceptionResponse gUIDNotPurgedExceptionResponse = (GUIDNotPurgedExceptionResponse)restResponse;
            throw new GUIDNotPurgedException(restResponse.getRelatedHTTPCode(), className, methodName, gUIDNotPurgedExceptionResponse.getExceptionErrorMessage(), gUIDNotPurgedExceptionResponse.getExceptionSystemAction(), gUIDNotPurgedExceptionResponse.getExceptionUserAction(), gUIDNotPurgedExceptionResponse.getGuid());
        }
    }

    public static void detectAndThrowRelationshipNotDeletedException(String methodName, SubjectAreaOMASAPIResponse restResponse) throws RelationshipNotDeletedException {
        if (restResponse != null && restResponse.getResponseCategory() == ResponseCategory.RelationshipNotDeletedException) {
            RelationshipNotDeletedExceptionResponse relationshipNotDeletedExceptionResponse = (RelationshipNotDeletedExceptionResponse)restResponse;
            throw new RelationshipNotDeletedException(restResponse.getRelatedHTTPCode(), className, methodName, relationshipNotDeletedExceptionResponse.getExceptionErrorMessage(), relationshipNotDeletedExceptionResponse.getExceptionSystemAction(), relationshipNotDeletedExceptionResponse.getExceptionUserAction(), relationshipNotDeletedExceptionResponse.getGuid());
        }
    }

    public static void detectAndThrowStatusNotSupportedException(String methodName, SubjectAreaOMASAPIResponse restResponse) throws StatusNotSupportedException {
        if (restResponse != null && restResponse.getResponseCategory() == ResponseCategory.StatusNotSupportedException) {
            StatusNotsupportedExceptionResponse statusNotSupportedExceptionResponse = (StatusNotsupportedExceptionResponse)restResponse;
            throw new StatusNotSupportedException(restResponse.getRelatedHTTPCode(), className, methodName, statusNotSupportedExceptionResponse.getExceptionErrorMessage(), statusNotSupportedExceptionResponse.getExceptionSystemAction(), statusNotSupportedExceptionResponse.getExceptionUserAction());
        }
    }

    public static void detectAndThrowUnrecognizedNameException(String methodName, SubjectAreaOMASAPIResponse restResponse) throws UnrecognizedNameException {
        if (restResponse != null && restResponse.getResponseCategory() == ResponseCategory.UnrecognizedNameException) {
            UnrecognizedNameExceptionResponse unrecognizedNameExceptionResponse = (UnrecognizedNameExceptionResponse)restResponse;
            throw new UnrecognizedNameException(restResponse.getRelatedHTTPCode(), className, methodName, unrecognizedNameExceptionResponse.getExceptionErrorMessage(), unrecognizedNameExceptionResponse.getExceptionSystemAction(), unrecognizedNameExceptionResponse.getExceptionUserAction(), unrecognizedNameExceptionResponse.getName());
        }
    }

    public static void detectAndThrowUserNotAuthorizedException(String methodName, SubjectAreaOMASAPIResponse restResponse) throws UserNotAuthorizedException {
        if (restResponse != null && restResponse.getResponseCategory() == ResponseCategory.UserNotAuthorizedException) {
            UserNotAuthorizedExceptionResponse userNotAuthorizedExceptionResponse = (UserNotAuthorizedExceptionResponse)restResponse;
            throw new UserNotAuthorizedException(restResponse.getRelatedHTTPCode(), className, methodName, userNotAuthorizedExceptionResponse.getExceptionErrorMessage(), userNotAuthorizedExceptionResponse.getExceptionSystemAction(), userNotAuthorizedExceptionResponse.getExceptionUserAction(), userNotAuthorizedExceptionResponse.getUserId());
        }
    }

    public static Glossary detectAndReturnGlossary(String methodName, SubjectAreaOMASAPIResponse restResponse) throws UnexpectedResponseException {
        Glossary glossary = null;
        if (restResponse == null || restResponse.getResponseCategory() != ResponseCategory.Glossary) {
            SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.CLIENT_RECEIVED_AN_UNEXPECTED_RESPONSE_ERROR;
            String unexpectedResponseCategory = restResponse.getResponseCategory().name();
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{unexpectedResponseCategory});
            throw new UnexpectedResponseException(errorCode.getHTTPErrorCode(), className, methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), unexpectedResponseCategory);
        }
        GlossaryResponse glossaryResponse = (GlossaryResponse)restResponse;
        glossary = glossaryResponse.getGlossary();
        return glossary;
    }

    public static Term detectAndReturnTerm(String methodName, SubjectAreaOMASAPIResponse restResponse) throws UnexpectedResponseException {
        Term term = null;
        if (restResponse == null || restResponse.getResponseCategory() != ResponseCategory.Term) {
            SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.CLIENT_RECEIVED_AN_UNEXPECTED_RESPONSE_ERROR;
            String unexpectedResponseCategory = restResponse.getResponseCategory().name();
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{unexpectedResponseCategory});
            throw new UnexpectedResponseException(errorCode.getHTTPErrorCode(), className, methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), unexpectedResponseCategory);
        }
        TermResponse termResponse = (TermResponse)restResponse;
        term = termResponse.getTerm();
        return term;
    }

    public static Category detectAndReturnCategory(String methodName, SubjectAreaOMASAPIResponse restResponse) throws UnexpectedResponseException {
        Category category = null;
        if (restResponse == null || restResponse.getResponseCategory() != ResponseCategory.Category) {
            SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.CLIENT_RECEIVED_AN_UNEXPECTED_RESPONSE_ERROR;
            String unexpectedResponseCategory = restResponse.getResponseCategory().name();
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{unexpectedResponseCategory});
            throw new UnexpectedResponseException(errorCode.getHTTPErrorCode(), className, methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), unexpectedResponseCategory);
        }
        CategoryResponse categoryResponse = (CategoryResponse)restResponse;
        category = categoryResponse.getCategory();
        return category;
    }
}

