/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.json.JsonSanitizer;
import java.io.IOException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.SubjectAreaErrorCode;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.MetadataServerUncontactableException;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SubjectAreaOMASAPIResponse;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class RestCaller {
    public static SubjectAreaOMASAPIResponse issueGet(String className, String methodName, String url) throws MetadataServerUncontactableException {
        return RestCaller.issueExchangeWithoutBody(className, methodName, HttpMethod.GET, url);
    }

    public static SubjectAreaOMASAPIResponse issuePost(String className, String methodName, String requestBody, String url) throws MetadataServerUncontactableException {
        return RestCaller.issueExchangeWithBody(className, methodName, HttpMethod.POST, requestBody, url);
    }

    public static SubjectAreaOMASAPIResponse issuePostNoBody(String className, String methodName, String url) throws MetadataServerUncontactableException {
        return RestCaller.issueExchangeWithoutBody(className, methodName, HttpMethod.POST, url);
    }

    public static SubjectAreaOMASAPIResponse issuePut(String className, String methodName, String requestBody, String url) throws MetadataServerUncontactableException {
        return RestCaller.issueExchangeWithBody(className, methodName, HttpMethod.PUT, requestBody, url);
    }

    public static SubjectAreaOMASAPIResponse issueDelete(String className, String methodName, String url) throws MetadataServerUncontactableException {
        return RestCaller.issueExchangeWithoutBody(className, methodName, HttpMethod.DELETE, url);
    }

    private static SubjectAreaOMASAPIResponse issueExchangeWithBody(String className, String methodName, HttpMethod httpMethod, String requestBody, String url) throws MetadataServerUncontactableException {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity entity = new HttpEntity((Object)requestBody, (MultiValueMap)headers);
        return RestCaller.issueExchange(className, methodName, httpMethod, url, entity);
    }

    private static SubjectAreaOMASAPIResponse issueExchangeWithoutBody(String className, String methodName, HttpMethod httpMethod, String url) throws MetadataServerUncontactableException {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity entity = new HttpEntity((MultiValueMap)headers);
        return RestCaller.issueExchange(className, methodName, httpMethod, url, entity);
    }

    private static SubjectAreaOMASAPIResponse issueExchange(String className, String methodName, HttpMethod httpMethod, String url, HttpEntity<?> entity) throws MetadataServerUncontactableException {
        SubjectAreaOMASAPIResponse restResponse = null;
        RestTemplate restTemplate = new RestTemplate();
        String resultBody = null;
        ResponseEntity result = null;
        try {
            result = restTemplate.exchange(url, httpMethod, entity, String.class, new Object[0]);
            resultBody = (String)result.getBody();
        }
        catch (Throwable error) {
            SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.CLIENT_SIDE_REST_API_ERROR;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{methodName, url, error.getMessage()});
            throw new MetadataServerUncontactableException(errorCode.getHTTPErrorCode(), className, methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), error);
        }
        ObjectMapper mapper = new ObjectMapper();
        try {
            resultBody = JsonSanitizer.sanitize((String)resultBody);
            restResponse = (SubjectAreaOMASAPIResponse)mapper.readValue(resultBody, SubjectAreaOMASAPIResponse.class);
        }
        catch (IOException ioException) {
            SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.CLIENT_SIDE_API_REST_RESPONSE_ERROR;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{methodName, url, ioException.getMessage()});
            throw new MetadataServerUncontactableException(errorCode.getHTTPErrorCode(), className, methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), (Throwable)ioException);
        }
        return restResponse;
    }

    public static void throwJsonParseError(String className, String methodName, JsonProcessingException error) throws InvalidParameterException {
        SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.UNABLE_TO_PARSE_SUPPLIED_JSON;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{methodName, error.getMessage()});
        throw new InvalidParameterException(errorCode.getHTTPErrorCode(), className, methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), (Throwable)error);
    }
}

