/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.utils;

import java.util.List;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.SubjectAreaErrorCode;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.ClassificationException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.EntityNotDeletedException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.FunctionNotSupportedException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.GUIDNotPurgedException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.MetadataServerUncontactableException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.RelationshipNotDeletedException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.StatusNotSupportedException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.SubjectAreaCheckedExceptionBase;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.UnexpectedResponseException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.UnrecognizedGUIDException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.UserNotAuthorizedException;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.category.Category;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.category.SubjectAreaDefinition;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.glossary.Glossary;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Graph;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Line;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.project.Project;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.term.Term;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.Antonym;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.CategoryAnchorRelationship;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.ISARelationship;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.PreferredTerm;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.ProjectScopeRelationship;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.RelatedTerm;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.ReplacementTerm;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.SemanticAssignment;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.Synonym;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.TermAnchorRelationship;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.TermCategorizationRelationship;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.TermHASARelationship;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.TermISATypeOFRelationship;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.TermTYPEDBYRelationship;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.Translation;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.UsedInContext;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.ValidValue;
import org.odpi.openmetadata.accessservices.subjectarea.responses.AntonymRelationshipResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.CategoriesResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.CategoryAnchorRelationshipResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.CategoryResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.ClassificationExceptionResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.EntityNotDeletedExceptionResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.FunctionNotSupportedExceptionResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.GUIDNotPurgedExceptionResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.GlossariesResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.GlossaryResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.GraphResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.InvalidParameterExceptionResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.LinesResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.MetadataServerUncontactableExceptionResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.PreferredTermRelationshipResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.ProjectResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.ProjectScopeRelationshipResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.ProjectsResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.RelatedTermResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.RelationshipNotDeletedExceptionResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.ReplacementRelationshipResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.ResponseCategory;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SemanticAssignementRelationshipResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.StatusNotsupportedExceptionResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SubjectAreaDefinitionResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SubjectAreaOMASAPIResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SynonymRelationshipResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.TermAnchorRelationshipResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.TermCategorizationRelationshipResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.TermHASARelationshipResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.TermISARelationshipResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.TermISATYPEOFRelationshipResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.TermResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.TermTYPEDBYRelationshipResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.TermsResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.TranslationRelationshipResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.UnexpectedExceptionResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.UnrecognizedGUIDExceptionResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.UsedInContextRelationshipResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.UserNotAuthorizedExceptionResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.ValidValueRelationshipResponse;

public class DetectUtils {
    private static String className = "DetectUtils";

    public static void detectAndThrowInvalidParameterException(String methodName, SubjectAreaOMASAPIResponse restResponse) throws InvalidParameterException {
        if (restResponse != null && restResponse.getResponseCategory() == ResponseCategory.InvalidParameterException) {
            InvalidParameterExceptionResponse invalidParameterExceptionResponse = (InvalidParameterExceptionResponse)restResponse;
            throw new InvalidParameterException(restResponse.getRelatedHTTPCode(), className, methodName, invalidParameterExceptionResponse.getExceptionErrorMessage(), invalidParameterExceptionResponse.getExceptionSystemAction(), invalidParameterExceptionResponse.getExceptionUserAction());
        }
    }

    public static void detectAndThrowUnrecognizedGUIDException(String methodName, SubjectAreaOMASAPIResponse restResponse) throws UnrecognizedGUIDException {
        if (restResponse != null && restResponse.getResponseCategory() == ResponseCategory.UnrecognizedGUIDException) {
            UnrecognizedGUIDExceptionResponse unrecognizedGUIDExceptionResponse = (UnrecognizedGUIDExceptionResponse)restResponse;
            throw new UnrecognizedGUIDException(restResponse.getRelatedHTTPCode(), className, methodName, unrecognizedGUIDExceptionResponse.getExceptionErrorMessage(), unrecognizedGUIDExceptionResponse.getExceptionSystemAction(), unrecognizedGUIDExceptionResponse.getExceptionUserAction(), unrecognizedGUIDExceptionResponse.getGuid());
        }
    }

    public static void detectAndThrowClassificationException(String methodName, SubjectAreaOMASAPIResponse restResponse) throws ClassificationException {
        if (restResponse != null && restResponse.getResponseCategory() == ResponseCategory.ClassificationException) {
            ClassificationExceptionResponse classificationExceptionResponse = (ClassificationExceptionResponse)restResponse;
            throw new ClassificationException(restResponse.getRelatedHTTPCode(), className, methodName, classificationExceptionResponse.getExceptionErrorMessage(), classificationExceptionResponse.getExceptionSystemAction(), classificationExceptionResponse.getExceptionUserAction());
        }
    }

    public static void detectAndThrowEntityNotDeletedException(String methodName, SubjectAreaOMASAPIResponse restResponse) throws EntityNotDeletedException {
        if (restResponse != null && restResponse.getResponseCategory() == ResponseCategory.EntityNotDeletedException) {
            EntityNotDeletedExceptionResponse entityNotDeletedExceptionResponse = (EntityNotDeletedExceptionResponse)restResponse;
            throw new EntityNotDeletedException(restResponse.getRelatedHTTPCode(), className, methodName, entityNotDeletedExceptionResponse.getExceptionErrorMessage(), entityNotDeletedExceptionResponse.getExceptionSystemAction(), entityNotDeletedExceptionResponse.getExceptionUserAction(), entityNotDeletedExceptionResponse.getGuid());
        }
    }

    public static void detectAndThrowFunctionNotSupportedException(String methodName, SubjectAreaOMASAPIResponse restResponse) throws FunctionNotSupportedException {
        if (restResponse != null && restResponse.getResponseCategory() == ResponseCategory.FunctionNotSupportedException) {
            FunctionNotSupportedExceptionResponse functionNotSupportedExceptionResponse = (FunctionNotSupportedExceptionResponse)restResponse;
            throw new FunctionNotSupportedException(restResponse.getRelatedHTTPCode(), className, methodName, functionNotSupportedExceptionResponse.getExceptionErrorMessage(), functionNotSupportedExceptionResponse.getExceptionSystemAction(), functionNotSupportedExceptionResponse.getExceptionUserAction());
        }
    }

    public static void detectAndThrowGUIDNotPurgedException(String methodName, SubjectAreaOMASAPIResponse restResponse) throws GUIDNotPurgedException {
        if (restResponse != null && restResponse.getResponseCategory() == ResponseCategory.GUIDNotPurgedException) {
            GUIDNotPurgedExceptionResponse gUIDNotPurgedExceptionResponse = (GUIDNotPurgedExceptionResponse)restResponse;
            throw new GUIDNotPurgedException(restResponse.getRelatedHTTPCode(), className, methodName, gUIDNotPurgedExceptionResponse.getExceptionErrorMessage(), gUIDNotPurgedExceptionResponse.getExceptionSystemAction(), gUIDNotPurgedExceptionResponse.getExceptionUserAction(), gUIDNotPurgedExceptionResponse.getGuid());
        }
    }

    public static void detectAndThrowRelationshipNotDeletedException(String methodName, SubjectAreaOMASAPIResponse restResponse) throws RelationshipNotDeletedException {
        if (restResponse != null && restResponse.getResponseCategory() == ResponseCategory.RelationshipNotDeletedException) {
            RelationshipNotDeletedExceptionResponse relationshipNotDeletedExceptionResponse = (RelationshipNotDeletedExceptionResponse)restResponse;
            throw new RelationshipNotDeletedException(restResponse.getRelatedHTTPCode(), className, methodName, relationshipNotDeletedExceptionResponse.getExceptionErrorMessage(), relationshipNotDeletedExceptionResponse.getExceptionSystemAction(), relationshipNotDeletedExceptionResponse.getExceptionUserAction(), relationshipNotDeletedExceptionResponse.getGuid());
        }
    }

    public static void detectAndThrowStatusNotSupportedException(String methodName, SubjectAreaOMASAPIResponse restResponse) throws StatusNotSupportedException {
        if (restResponse != null && restResponse.getResponseCategory() == ResponseCategory.StatusNotSupportedException) {
            StatusNotsupportedExceptionResponse statusNotSupportedExceptionResponse = (StatusNotsupportedExceptionResponse)restResponse;
            throw new StatusNotSupportedException(restResponse.getRelatedHTTPCode(), className, methodName, statusNotSupportedExceptionResponse.getExceptionErrorMessage(), statusNotSupportedExceptionResponse.getExceptionSystemAction(), statusNotSupportedExceptionResponse.getExceptionUserAction());
        }
    }

    public static void detectAndThrowUserNotAuthorizedException(String methodName, SubjectAreaOMASAPIResponse restResponse) throws UserNotAuthorizedException {
        if (restResponse != null && restResponse.getResponseCategory() == ResponseCategory.UserNotAuthorizedException) {
            UserNotAuthorizedExceptionResponse userNotAuthorizedExceptionResponse = (UserNotAuthorizedExceptionResponse)restResponse;
            throw new UserNotAuthorizedException(restResponse.getRelatedHTTPCode(), className, methodName, userNotAuthorizedExceptionResponse.getExceptionErrorMessage(), userNotAuthorizedExceptionResponse.getExceptionSystemAction(), userNotAuthorizedExceptionResponse.getExceptionUserAction(), userNotAuthorizedExceptionResponse.getUserId());
        }
    }

    public static void detectVoid(String methodName, SubjectAreaOMASAPIResponse restResponse) throws UnexpectedResponseException {
        if (restResponse == null || restResponse.getResponseCategory() != ResponseCategory.Void) {
            DetectUtils.CategoryErrorResponse(methodName, restResponse);
        }
    }

    public static Glossary detectAndReturnGlossary(String methodName, SubjectAreaOMASAPIResponse restResponse) throws UnexpectedResponseException {
        Glossary glossary = null;
        if (restResponse != null && restResponse.getResponseCategory() == ResponseCategory.Glossary) {
            GlossaryResponse glossaryResponse = (GlossaryResponse)restResponse;
            glossary = glossaryResponse.getGlossary();
        } else {
            DetectUtils.CategoryErrorResponse(methodName, restResponse);
        }
        return glossary;
    }

    public static List<Glossary> detectAndReturnGlossaries(String methodName, SubjectAreaOMASAPIResponse restResponse) throws UnexpectedResponseException {
        List glossaries = null;
        if (restResponse != null && restResponse.getResponseCategory() == ResponseCategory.Glossaries) {
            GlossariesResponse glossariesResponse = (GlossariesResponse)restResponse;
            glossaries = glossariesResponse.getGlossaries();
        } else {
            DetectUtils.CategoryErrorResponse(methodName, restResponse);
        }
        return glossaries;
    }

    public static Project detectAndReturnProject(String methodName, SubjectAreaOMASAPIResponse restResponse) throws UnexpectedResponseException {
        Project project = null;
        if (restResponse != null && restResponse.getResponseCategory() == ResponseCategory.Project) {
            ProjectResponse projectResponse = (ProjectResponse)restResponse;
            project = projectResponse.getProject();
        } else {
            DetectUtils.CategoryErrorResponse(methodName, restResponse);
        }
        return project;
    }

    public static List<Project> detectAndReturnProjects(String methodName, SubjectAreaOMASAPIResponse restResponse) throws UnexpectedResponseException {
        List projects = null;
        if (restResponse != null && restResponse.getResponseCategory() == ResponseCategory.Projects) {
            ProjectsResponse projectsResponse = (ProjectsResponse)restResponse;
            projects = projectsResponse.getProjects();
        } else {
            DetectUtils.CategoryErrorResponse(methodName, restResponse);
        }
        return projects;
    }

    public static Term detectAndReturnTerm(String methodName, SubjectAreaOMASAPIResponse restResponse) throws UnexpectedResponseException {
        Term term = null;
        if (restResponse != null && restResponse.getResponseCategory() == ResponseCategory.Term) {
            TermResponse termResponse = (TermResponse)restResponse;
            term = termResponse.getTerm();
        } else {
            DetectUtils.CategoryErrorResponse(methodName, restResponse);
        }
        return term;
    }

    public static List<Term> detectAndReturnTerms(String methodName, SubjectAreaOMASAPIResponse restResponse) throws UnexpectedResponseException {
        List terms = null;
        if (restResponse != null && restResponse.getResponseCategory() == ResponseCategory.Terms) {
            TermsResponse termsResponse = (TermsResponse)restResponse;
            terms = termsResponse.getTerms();
        } else {
            DetectUtils.CategoryErrorResponse(methodName, restResponse);
        }
        return terms;
    }

    public static Graph detectAndReturnGraph(String methodName, SubjectAreaOMASAPIResponse restResponse) throws UnexpectedResponseException {
        Graph graph = null;
        if (restResponse != null && restResponse.getResponseCategory() == ResponseCategory.Graph) {
            GraphResponse GraphResponse2 = (GraphResponse)restResponse;
            graph = GraphResponse2.getGraph();
        } else {
            DetectUtils.CategoryErrorResponse(methodName, restResponse);
        }
        return graph;
    }

    public static List<Line> detectAndReturnLines(String methodName, SubjectAreaOMASAPIResponse restResponse) throws UnexpectedResponseException {
        List lines = null;
        if (restResponse != null && restResponse.getResponseCategory() == ResponseCategory.Lines) {
            LinesResponse linesResponse = (LinesResponse)restResponse;
            lines = linesResponse.getLines();
        } else {
            DetectUtils.CategoryErrorResponse(methodName, restResponse);
        }
        return lines;
    }

    public static Category detectAndReturnCategory(String methodName, SubjectAreaOMASAPIResponse restResponse) throws UnexpectedResponseException {
        Category category = null;
        if (restResponse != null && restResponse.getResponseCategory() == ResponseCategory.Category) {
            CategoryResponse categoryResponse = (CategoryResponse)restResponse;
            category = categoryResponse.getCategory();
        } else {
            DetectUtils.CategoryErrorResponse(methodName, restResponse);
        }
        return category;
    }

    public static List<Category> detectAndReturnCategories(String methodName, SubjectAreaOMASAPIResponse restResponse) throws UnexpectedResponseException {
        List categories = null;
        if (restResponse != null && restResponse.getResponseCategory() == ResponseCategory.Categories) {
            CategoriesResponse categoriesResponse = (CategoriesResponse)restResponse;
            categories = categoriesResponse.getCategories();
        } else {
            DetectUtils.CategoryErrorResponse(methodName, restResponse);
        }
        return categories;
    }

    public static SubjectAreaDefinition detectAndReturnSubjectAreaDefinition(String methodName, SubjectAreaOMASAPIResponse restResponse) throws UnexpectedResponseException {
        SubjectAreaDefinition subjectAreaDefinition = null;
        if (restResponse != null && restResponse.getResponseCategory() == ResponseCategory.SubjectAreaDefinition) {
            SubjectAreaDefinitionResponse subjectAreaDefinitionResponse = (SubjectAreaDefinitionResponse)restResponse;
            subjectAreaDefinition = subjectAreaDefinitionResponse.getSubjectAreaDefinition();
        } else {
            DetectUtils.CategoryErrorResponse(methodName, restResponse);
        }
        return subjectAreaDefinition;
    }

    private static void CategoryErrorResponse(String methodName, SubjectAreaOMASAPIResponse restResponse) throws UnexpectedResponseException {
        SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.CLIENT_RECEIVED_AN_UNEXPECTED_RESPONSE_ERROR;
        String unexpectedResponseCategory = ResponseCategory.Unknown.name();
        if (restResponse != null) {
            unexpectedResponseCategory = restResponse.getResponseCategory().name();
        }
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{unexpectedResponseCategory});
        throw new UnexpectedResponseException(errorCode.getHTTPErrorCode(), className, methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), unexpectedResponseCategory);
    }

    public static TermHASARelationship detectAndReturnTermHASARelationship(String methodName, SubjectAreaOMASAPIResponse restResponse) throws UnexpectedResponseException {
        TermHASARelationship termHASARelationship = null;
        if (restResponse != null && restResponse.getResponseCategory() == ResponseCategory.TermHASARelationship) {
            TermHASARelationshipResponse termHASARelationshipResponse = (TermHASARelationshipResponse)restResponse;
            termHASARelationship = termHASARelationshipResponse.getTermHASARelationship();
        } else {
            DetectUtils.CategoryErrorResponse(methodName, restResponse);
        }
        return termHASARelationship;
    }

    public static RelatedTerm detectAndReturnRelatedTerm(String methodName, SubjectAreaOMASAPIResponse restResponse) throws UnexpectedResponseException {
        RelatedTerm relatedTermRelationship = null;
        if (restResponse != null && restResponse.getResponseCategory() == ResponseCategory.RelatedTerm) {
            RelatedTermResponse relatedTermResponse = (RelatedTermResponse)restResponse;
            relatedTermRelationship = relatedTermResponse.getRelatedTerm();
        } else {
            DetectUtils.CategoryErrorResponse(methodName, restResponse);
        }
        return relatedTermRelationship;
    }

    public static Synonym detectAndReturnSynonym(String methodName, SubjectAreaOMASAPIResponse restResponse) throws UnexpectedResponseException {
        Synonym synonym = null;
        if (restResponse != null && restResponse.getResponseCategory() == ResponseCategory.SynonymRelationship) {
            SynonymRelationshipResponse synonymResponse = (SynonymRelationshipResponse)restResponse;
            synonym = synonymResponse.getSynonym();
        } else {
            DetectUtils.CategoryErrorResponse(methodName, restResponse);
        }
        return synonym;
    }

    public static Antonym detectAndReturnAntonym(String methodName, SubjectAreaOMASAPIResponse restResponse) throws UnexpectedResponseException {
        Antonym antonym = null;
        if (restResponse != null && restResponse.getResponseCategory() == ResponseCategory.AntonymRelationship) {
            AntonymRelationshipResponse antonymResponse = (AntonymRelationshipResponse)restResponse;
            antonym = antonymResponse.getAntonym();
        } else {
            DetectUtils.CategoryErrorResponse(methodName, restResponse);
        }
        return antonym;
    }

    public static Translation detectAndReturnTranslation(String methodName, SubjectAreaOMASAPIResponse restResponse) throws UnexpectedResponseException {
        Translation translation = null;
        if (restResponse != null && restResponse.getResponseCategory() == ResponseCategory.TranslationRelationship) {
            TranslationRelationshipResponse translationResponse = (TranslationRelationshipResponse)restResponse;
            translation = translationResponse.getTranslation();
        } else {
            DetectUtils.CategoryErrorResponse(methodName, restResponse);
        }
        return translation;
    }

    public static UsedInContext detectAndReturnUsedInContext(String methodName, SubjectAreaOMASAPIResponse restResponse) throws UnexpectedResponseException {
        UsedInContext usedInContext = null;
        if (restResponse != null && restResponse.getResponseCategory() == ResponseCategory.TermUsedInContextRelationship) {
            UsedInContextRelationshipResponse usedInContextResponse = (UsedInContextRelationshipResponse)restResponse;
            usedInContext = usedInContextResponse.getUsedInContext();
        } else {
            DetectUtils.CategoryErrorResponse(methodName, restResponse);
        }
        return usedInContext;
    }

    public static PreferredTerm detectAndReturnPreferredTerm(String methodName, SubjectAreaOMASAPIResponse restResponse) throws UnexpectedResponseException {
        PreferredTerm preferredTerm = null;
        if (restResponse != null && restResponse.getResponseCategory() == ResponseCategory.PreferredTermRelationship) {
            PreferredTermRelationshipResponse preferredTermResponse = (PreferredTermRelationshipResponse)restResponse;
            preferredTerm = preferredTermResponse.getPreferredTerm();
        } else {
            DetectUtils.CategoryErrorResponse(methodName, restResponse);
        }
        return preferredTerm;
    }

    public static ValidValue detectAndReturnValidValue(String methodName, SubjectAreaOMASAPIResponse restResponse) throws UnexpectedResponseException {
        ValidValue validValue = null;
        if (restResponse != null && restResponse.getResponseCategory() == ResponseCategory.ValidValueRelationship) {
            ValidValueRelationshipResponse validValueResponse = (ValidValueRelationshipResponse)restResponse;
            validValue = validValueResponse.getValidValue();
        } else {
            DetectUtils.CategoryErrorResponse(methodName, restResponse);
        }
        return validValue;
    }

    public static ReplacementTerm detectAndReturnReplacementTerm(String methodName, SubjectAreaOMASAPIResponse restResponse) throws UnexpectedResponseException {
        ReplacementTerm replacementTerm = null;
        if (restResponse != null && restResponse.getResponseCategory() == ResponseCategory.TermReplacementRelationship) {
            ReplacementRelationshipResponse replacementTermResponse = (ReplacementRelationshipResponse)restResponse;
            replacementTerm = replacementTermResponse.getTermReplacementRelationship();
        } else {
            DetectUtils.CategoryErrorResponse(methodName, restResponse);
        }
        return replacementTerm;
    }

    public static TermTYPEDBYRelationship detectAndReturnTermTYPEDBYRelationship(String methodName, SubjectAreaOMASAPIResponse restResponse) throws UnexpectedResponseException {
        TermTYPEDBYRelationship termTYPEDBYRelationship = null;
        if (restResponse != null && restResponse.getResponseCategory() == ResponseCategory.TermTYPEDBYRelationship) {
            TermTYPEDBYRelationshipResponse termTYPEDBYRelationshipResponse = (TermTYPEDBYRelationshipResponse)restResponse;
            termTYPEDBYRelationship = termTYPEDBYRelationshipResponse.getTermTYPEDBYRelationship();
        } else {
            DetectUtils.CategoryErrorResponse(methodName, restResponse);
        }
        return termTYPEDBYRelationship;
    }

    public static ISARelationship detectAndReturnISARelationship(String methodName, SubjectAreaOMASAPIResponse restResponse) throws UnexpectedResponseException {
        ISARelationship isa = null;
        if (restResponse != null && restResponse.getResponseCategory() == ResponseCategory.TermISARelationship) {
            TermISARelationshipResponse isaResponse = (TermISARelationshipResponse)restResponse;
            isa = isaResponse.getTermISARelationship();
        } else {
            DetectUtils.CategoryErrorResponse(methodName, restResponse);
        }
        return isa;
    }

    public static TermISATypeOFRelationship detectAndReturnTermISATypeOFRelationship(String methodName, SubjectAreaOMASAPIResponse restResponse) throws UnexpectedResponseException {
        TermISATypeOFRelationship termISATypeOFRelationship = null;
        if (restResponse != null && restResponse.getResponseCategory() == ResponseCategory.TermISATYPEOFRelationship) {
            TermISATYPEOFRelationshipResponse TermISATypeOFRelationshipResponse = (TermISATYPEOFRelationshipResponse)restResponse;
            termISATypeOFRelationship = TermISATypeOFRelationshipResponse.getTermISATYPEOFRelationship();
        } else {
            DetectUtils.CategoryErrorResponse(methodName, restResponse);
        }
        return termISATypeOFRelationship;
    }

    public static SemanticAssignment detectAndReturnSemanticAssignmentRelationship(String methodName, SubjectAreaOMASAPIResponse restResponse) throws UnexpectedResponseException {
        SemanticAssignment semanticAssignment = null;
        if (restResponse != null && restResponse.getResponseCategory() == ResponseCategory.SemanticAssignmentRelationship) {
            SemanticAssignementRelationshipResponse relationshipResponse = (SemanticAssignementRelationshipResponse)restResponse;
            semanticAssignment = relationshipResponse.getSemanticAssignment();
        } else {
            DetectUtils.CategoryErrorResponse(methodName, restResponse);
        }
        return semanticAssignment;
    }

    public static TermCategorizationRelationship detectAndReturnTermCategorizationRelationship(String methodName, SubjectAreaOMASAPIResponse restResponse) throws UnexpectedResponseException {
        TermCategorizationRelationship termCategorizationRelationship = null;
        if (restResponse != null && restResponse.getResponseCategory() == ResponseCategory.TermCategorizationRelationship) {
            TermCategorizationRelationshipResponse relationshipResponse = (TermCategorizationRelationshipResponse)restResponse;
            termCategorizationRelationship = relationshipResponse.getTermCategorization();
        } else {
            DetectUtils.CategoryErrorResponse(methodName, restResponse);
        }
        return termCategorizationRelationship;
    }

    public static TermAnchorRelationship detectAndReturnTermAnchorRelationship(String methodName, SubjectAreaOMASAPIResponse restResponse) throws UnexpectedResponseException {
        TermAnchorRelationship termAnchorRelationship = null;
        if (restResponse != null && restResponse.getResponseCategory() == ResponseCategory.TermAnchorRelationship) {
            TermAnchorRelationshipResponse relationshipResponse = (TermAnchorRelationshipResponse)restResponse;
            termAnchorRelationship = relationshipResponse.getTermAnchorRelationship();
        } else {
            DetectUtils.CategoryErrorResponse(methodName, restResponse);
        }
        return termAnchorRelationship;
    }

    public static CategoryAnchorRelationship detectAndReturnCategoryAnchorRelationship(String methodName, SubjectAreaOMASAPIResponse restResponse) throws UnexpectedResponseException {
        CategoryAnchorRelationship categoryAnchorRelationship = null;
        if (restResponse != null && restResponse.getResponseCategory() == ResponseCategory.CategoryAnchorRelationship) {
            CategoryAnchorRelationshipResponse relationshipResponse = (CategoryAnchorRelationshipResponse)restResponse;
            categoryAnchorRelationship = relationshipResponse.getCategoryAnchorRelationship();
        } else {
            DetectUtils.CategoryErrorResponse(methodName, restResponse);
        }
        return categoryAnchorRelationship;
    }

    public static ProjectScopeRelationship detectAndReturnProjectScope(String methodName, SubjectAreaOMASAPIResponse restResponse) throws UnexpectedResponseException {
        ProjectScopeRelationship projectScopeRelationship = null;
        if (restResponse != null && restResponse.getResponseCategory() == ResponseCategory.ProjectScopeRelationship) {
            ProjectScopeRelationshipResponse relationshipResponse = (ProjectScopeRelationshipResponse)restResponse;
            projectScopeRelationship = relationshipResponse.getProjectScope();
        } else {
            DetectUtils.CategoryErrorResponse(methodName, restResponse);
        }
        return projectScopeRelationship;
    }

    public static SubjectAreaOMASAPIResponse getResponseFromException(SubjectAreaCheckedExceptionBase e) {
        MetadataServerUncontactableExceptionResponse response = null;
        if (e instanceof MetadataServerUncontactableException) {
            response = new MetadataServerUncontactableExceptionResponse(e);
        } else if (e instanceof InvalidParameterException) {
            response = new InvalidParameterExceptionResponse(e);
        } else if (e instanceof UserNotAuthorizedException) {
            response = new UserNotAuthorizedExceptionResponse(e);
        } else if (e instanceof UnrecognizedGUIDException) {
            response = new UnrecognizedGUIDExceptionResponse(e);
        } else if (e instanceof ClassificationException) {
            response = new ClassificationExceptionResponse(e);
        } else if (e instanceof FunctionNotSupportedException) {
            response = new FunctionNotSupportedExceptionResponse(e);
        } else if (e instanceof UnexpectedResponseException) {
            response = new UnexpectedExceptionResponse(e);
        }
        return response;
    }
}

