/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.client;

import org.odpi.openmetadata.accessservices.subjectarea.SubjectArea;
import org.odpi.openmetadata.accessservices.subjectarea.SubjectAreaCategory;
import org.odpi.openmetadata.accessservices.subjectarea.SubjectAreaGlossary;
import org.odpi.openmetadata.accessservices.subjectarea.SubjectAreaGraph;
import org.odpi.openmetadata.accessservices.subjectarea.SubjectAreaProject;
import org.odpi.openmetadata.accessservices.subjectarea.SubjectAreaRelationship;
import org.odpi.openmetadata.accessservices.subjectarea.SubjectAreaTerm;
import org.odpi.openmetadata.accessservices.subjectarea.client.SubjectAreaCategoryImpl;
import org.odpi.openmetadata.accessservices.subjectarea.client.SubjectAreaGlossaryImpl;
import org.odpi.openmetadata.accessservices.subjectarea.client.SubjectAreaGraphImpl;
import org.odpi.openmetadata.accessservices.subjectarea.client.SubjectAreaProjectImpl;
import org.odpi.openmetadata.accessservices.subjectarea.client.SubjectAreaRelationshipImpl;
import org.odpi.openmetadata.accessservices.subjectarea.client.SubjectAreaTermImpl;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.subjectarea.validators.InputValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubjectAreaImpl
implements SubjectArea {
    private static final Logger log = LoggerFactory.getLogger(SubjectAreaImpl.class);
    private static final String className = SubjectAreaImpl.class.getName();
    static final String SUBJECT_AREA_BASE_URL = "/servers/%s/open-metadata/access-services/subject-area/users/%s/";
    private final SubjectAreaTermImpl termAPI;
    private final SubjectAreaCategoryImpl categoryAPI;
    private final SubjectAreaGlossaryImpl glossaryAPI;
    private final SubjectAreaProjectImpl projectAPI;
    public final SubjectAreaRelationshipImpl relationshipAPI;
    public final SubjectAreaGraphImpl graphAPI;
    public final String serverName;
    public final String omasServerUrl;

    public SubjectAreaImpl(String serverName, String omasServerURL) throws InvalidParameterException {
        String methodName = "SubjectAreaImpl";
        InputValidator.validateRemoteServerNameNotNull((String)className, (String)methodName, (String)serverName);
        InputValidator.validateRemoteServerURLNotNull((String)className, (String)methodName, (String)omasServerURL);
        this.glossaryAPI = new SubjectAreaGlossaryImpl(omasServerURL, serverName);
        this.termAPI = new SubjectAreaTermImpl(omasServerURL, serverName);
        this.categoryAPI = new SubjectAreaCategoryImpl(omasServerURL, serverName);
        this.relationshipAPI = new SubjectAreaRelationshipImpl(omasServerURL, serverName);
        this.graphAPI = new SubjectAreaGraphImpl(omasServerURL, serverName);
        this.projectAPI = new SubjectAreaProjectImpl(omasServerURL, serverName);
        this.serverName = serverName;
        this.omasServerUrl = omasServerURL;
    }

    @Override
    public SubjectAreaCategory getSubjectAreaCategory() {
        return this.categoryAPI;
    }

    @Override
    public SubjectAreaGlossary getSubjectAreaGlossary() {
        return this.glossaryAPI;
    }

    @Override
    public SubjectAreaProject getSubjectAreaProject() {
        return this.projectAPI;
    }

    @Override
    public SubjectAreaTerm getSubjectAreaTerm() {
        return this.termAPI;
    }

    @Override
    public SubjectAreaRelationship getSubjectAreaRelationship() {
        return this.relationshipAPI;
    }

    @Override
    public SubjectAreaGraph getSubjectAreaGraph() {
        return this.graphAPI;
    }

    @Override
    public String getServerName() {
        return this.serverName;
    }

    @Override
    public String getOmasServerUrl() {
        return this.omasServerUrl;
    }
}

