/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.client;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.accessservices.subjectarea.SubjectAreaProject;
import org.odpi.openmetadata.accessservices.subjectarea.client.SubjectAreaBaseImpl;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.SubjectAreaErrorCode;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.ClassificationException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.EntityNotDeletedException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.FunctionNotSupportedException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.GUIDNotPurgedException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.MetadataServerUncontactableException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.UnexpectedResponseException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.UnrecognizedGUIDException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.UserNotAuthorizedException;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.SequencingOrder;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Line;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.NodeType;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.project.Project;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.term.Term;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SubjectAreaOMASAPIResponse;
import org.odpi.openmetadata.accessservices.subjectarea.utils.DetectUtils;
import org.odpi.openmetadata.accessservices.subjectarea.utils.QueryUtils;
import org.odpi.openmetadata.accessservices.subjectarea.utils.RestCaller;
import org.odpi.openmetadata.accessservices.subjectarea.validators.InputValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubjectAreaProjectImpl
extends SubjectAreaBaseImpl
implements SubjectAreaProject {
    private static final Logger log = LoggerFactory.getLogger(SubjectAreaProjectImpl.class);
    private static final String className = SubjectAreaProjectImpl.class.getName();
    private static final String BASE_URL = "/servers/%s/open-metadata/access-services/subject-area/users/%s/projects";

    public SubjectAreaProjectImpl(String omasServerURL, String serverName) {
        super(omasServerURL, serverName);
    }

    @Override
    public Project createProject(String userId, Project suppliedProject) throws MetadataServerUncontactableException, InvalidParameterException, UserNotAuthorizedException, UnrecognizedGUIDException, ClassificationException, FunctionNotSupportedException, UnexpectedResponseException {
        String methodName = "createProject";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: createProject,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"createProject", (String)userId);
        String url = this.omasServerURL + String.format(BASE_URL, this.serverName, userId);
        InputValidator.validateNodeType((Object[])new Object[]{className, "createProject", suppliedProject.getNodeType(), NodeType.Project, NodeType.GlossaryProject});
        suppliedProject.setNodeType(NodeType.GlossaryProject);
        ObjectMapper mapper = new ObjectMapper();
        String requestBody = null;
        try {
            requestBody = mapper.writeValueAsString((Object)suppliedProject);
        }
        catch (JsonProcessingException error) {
            RestCaller.throwJsonParseError(className, "createProject", error);
        }
        SubjectAreaOMASAPIResponse restResponse = RestCaller.issuePost(className, "createProject", requestBody, url);
        DetectUtils.detectAndThrowUserNotAuthorizedException("createProject", restResponse);
        DetectUtils.detectAndThrowInvalidParameterException("createProject", restResponse);
        DetectUtils.detectAndThrowUnrecognizedGUIDException("createProject", restResponse);
        DetectUtils.detectAndThrowClassificationException("createProject", restResponse);
        DetectUtils.detectAndThrowFunctionNotSupportedException("createProject", restResponse);
        Project project = DetectUtils.detectAndReturnProject("createProject", restResponse);
        if (suppliedProject.getNodeType() != null && !suppliedProject.getNodeType().equals((Object)project.getNodeType())) {
            SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.UNEXPECTED_NODETYPE;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{"createProject", suppliedProject.getNodeType().name(), project.getNodeType().name()});
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), className, "createProject", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : createProject,userId=" + userId);
        }
        return project;
    }

    @Override
    public Project getProjectByGuid(String userId, String guid) throws MetadataServerUncontactableException, UnrecognizedGUIDException, UserNotAuthorizedException, InvalidParameterException, FunctionNotSupportedException, UnexpectedResponseException {
        String methodName = "getProjectByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getProjectByGuid,userId=" + userId + ",guid=" + guid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getProjectByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getProjectByGuid", (String)guid, (String)"guid");
        String urlTemplate = this.omasServerURL + BASE_URL + "/%s";
        String url = String.format(urlTemplate, this.serverName, userId, guid);
        SubjectAreaOMASAPIResponse restResponse = RestCaller.issueGet(className, "getProjectByGuid", url);
        DetectUtils.detectAndThrowUserNotAuthorizedException("getProjectByGuid", restResponse);
        DetectUtils.detectAndThrowInvalidParameterException("getProjectByGuid", restResponse);
        DetectUtils.detectAndThrowUnrecognizedGUIDException("getProjectByGuid", restResponse);
        DetectUtils.detectAndThrowFunctionNotSupportedException("getProjectByGuid", restResponse);
        Project project = DetectUtils.detectAndReturnProject("getProjectByGuid", restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getProjectByGuid,userId=" + userId);
        }
        return project;
    }

    @Override
    public List<Line> getProjectRelationships(String userId, String guid, Date asOfTime, int offset, int pageSize, SequencingOrder sequencingOrder, String sequencingProperty) throws UserNotAuthorizedException, InvalidParameterException, FunctionNotSupportedException, UnexpectedResponseException, MetadataServerUncontactableException {
        String methodName = "getProjectRelationships";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getProjectRelationships,userId=" + userId + ",guid=" + guid);
        }
        List<Line> relationships = this.getRelationships(BASE_URL, userId, guid, asOfTime, offset, pageSize, sequencingOrder, sequencingProperty);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getProjectRelationships,userId=" + userId);
        }
        return relationships;
    }

    @Override
    public List<Term> getProjectTerms(String userId, String guid, Date asOfTime) throws InvalidParameterException, UserNotAuthorizedException, FunctionNotSupportedException, UnexpectedResponseException, MetadataServerUncontactableException {
        String methodName = "getProjectTerms";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getProjectTerms,userId=" + userId + ",guid=" + guid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getProjectTerms", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getProjectTerms", (String)guid, (String)"guid");
        String urlTemplate = this.omasServerURL + BASE_URL + "/%s/terms";
        String url = String.format(urlTemplate, this.serverName, userId, guid);
        SubjectAreaOMASAPIResponse restResponse = RestCaller.issueGet(className, "getProjectTerms", url);
        DetectUtils.detectAndThrowUserNotAuthorizedException("getProjectTerms", restResponse);
        DetectUtils.detectAndThrowInvalidParameterException("getProjectTerms", restResponse);
        DetectUtils.detectAndThrowFunctionNotSupportedException("getProjectTerms", restResponse);
        List<Term> terms = DetectUtils.detectAndReturnTerms("getProjectTerms", restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getProjectTerms,userId=" + userId);
        }
        return terms;
    }

    @Override
    public List<Project> findProject(String userId, String searchCriteria, Date asOfTime, int offset, int pageSize, SequencingOrder sequencingOrder, String sequencingProperty) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, FunctionNotSupportedException, UnexpectedResponseException {
        String methodName = "findProject";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: findProject,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"findProject", (String)userId);
        String urlTemplate = this.omasServerURL + BASE_URL;
        String url = String.format(urlTemplate, this.serverName, userId);
        if (sequencingOrder == null) {
            sequencingOrder = SequencingOrder.ANY;
        }
        StringBuffer queryStringSB = new StringBuffer();
        QueryUtils.addCharacterToQuery(queryStringSB);
        queryStringSB.append("sequencingOrder=" + sequencingOrder);
        if (asOfTime != null) {
            QueryUtils.addCharacterToQuery(queryStringSB);
            queryStringSB.append("asOfTime=" + asOfTime);
        }
        if (searchCriteria != null) {
            this.encodeQueryProperty("searchCriteria", searchCriteria, "findProject", queryStringSB);
        }
        if (offset != 0) {
            QueryUtils.addCharacterToQuery(queryStringSB);
            queryStringSB.append("offset=" + offset);
        }
        if (pageSize != 0) {
            QueryUtils.addCharacterToQuery(queryStringSB);
            queryStringSB.append("pageSize=" + pageSize);
        }
        if (sequencingProperty != null) {
            this.encodeQueryProperty("sequencingProperty", sequencingProperty, "findProject", queryStringSB);
        }
        if (queryStringSB.length() > 0) {
            url = url + queryStringSB.toString();
        }
        SubjectAreaOMASAPIResponse restResponse = RestCaller.issueGet(className, "findProject", url);
        DetectUtils.detectAndThrowUserNotAuthorizedException("findProject", restResponse);
        DetectUtils.detectAndThrowInvalidParameterException("findProject", restResponse);
        DetectUtils.detectAndThrowFunctionNotSupportedException("findProject", restResponse);
        List<Project> projects = DetectUtils.detectAndReturnProjects("findProject", restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : findProject,userId=" + userId);
        }
        return projects;
    }

    @Override
    public Project replaceProject(String userId, String guid, Project suppliedProject) throws UnexpectedResponseException, UserNotAuthorizedException, InvalidParameterException, MetadataServerUncontactableException {
        String methodName = "replaceProject";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: replaceProject,userId=" + userId + ",guid=" + guid);
        }
        Project project = this.updateProject(userId, guid, suppliedProject, true);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : replaceProject,userId=" + userId);
        }
        return project;
    }

    @Override
    public Project updateProject(String userId, String guid, Project suppliedProject) throws UnexpectedResponseException, UserNotAuthorizedException, InvalidParameterException, MetadataServerUncontactableException {
        String methodName = "updateProject";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateProject,userId=" + userId + ",guid=" + guid);
        }
        Project project = this.updateProject(userId, guid, suppliedProject, false);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : updateProject,userId=" + userId);
        }
        return project;
    }

    @Override
    public Project deleteProject(String userId, String guid) throws InvalidParameterException, MetadataServerUncontactableException, UserNotAuthorizedException, UnrecognizedGUIDException, FunctionNotSupportedException, UnexpectedResponseException, EntityNotDeletedException {
        String methodName = "deleteProject";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteProject,userId=" + userId + ",guid=" + guid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"deleteProject", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"deleteProject", (String)guid, (String)"guid");
        String urlTemplate = this.omasServerURL + BASE_URL + "/%s?isPurge=false";
        String url = String.format(urlTemplate, this.serverName, userId, guid);
        SubjectAreaOMASAPIResponse restResponse = RestCaller.issueDelete(className, "deleteProject", url);
        DetectUtils.detectAndThrowUserNotAuthorizedException("deleteProject", restResponse);
        DetectUtils.detectAndThrowInvalidParameterException("deleteProject", restResponse);
        DetectUtils.detectAndThrowUnrecognizedGUIDException("deleteProject", restResponse);
        DetectUtils.detectAndThrowFunctionNotSupportedException("deleteProject", restResponse);
        DetectUtils.detectAndThrowEntityNotDeletedException("deleteProject", restResponse);
        Project project = DetectUtils.detectAndReturnProject("deleteProject", restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : deleteProject,userId=" + userId);
        }
        return project;
    }

    @Override
    public void purgeProject(String userId, String guid) throws InvalidParameterException, UserNotAuthorizedException, MetadataServerUncontactableException, UnrecognizedGUIDException, GUIDNotPurgedException, UnexpectedResponseException, FunctionNotSupportedException {
        String methodName = "purgeProject";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: purgeProject,userId=" + userId + ",guid=" + guid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"purgeProject", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"purgeProject", (String)guid, (String)"guid");
        String urlTemplate = this.omasServerURL + BASE_URL + "/%s?isPurge=true";
        String url = String.format(urlTemplate, this.serverName, userId, guid);
        SubjectAreaOMASAPIResponse restResponse = RestCaller.issueDelete(className, "purgeProject", url);
        DetectUtils.detectAndThrowUserNotAuthorizedException("purgeProject", restResponse);
        DetectUtils.detectAndThrowInvalidParameterException("purgeProject", restResponse);
        DetectUtils.detectAndThrowUnrecognizedGUIDException("purgeProject", restResponse);
        DetectUtils.detectAndThrowGUIDNotPurgedException("purgeProject", restResponse);
        DetectUtils.detectAndThrowFunctionNotSupportedException("purgeProject", restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : purgeProject,userId=" + userId);
        }
    }

    private Project updateProject(String userId, String guid, Project suppliedProject, boolean isReplace) throws UserNotAuthorizedException, InvalidParameterException, MetadataServerUncontactableException, UnexpectedResponseException {
        String methodName = "updateProject";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateProject,userId=" + userId + ",guid=" + guid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"updateProject", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"updateProject", (String)guid, (String)"guid");
        String urlTemplate = this.omasServerURL + BASE_URL + "/%s?isReplace=%b";
        String url = String.format(urlTemplate, this.serverName, userId, guid, isReplace);
        ObjectMapper mapper = new ObjectMapper();
        String requestBody = null;
        try {
            requestBody = mapper.writeValueAsString((Object)suppliedProject);
        }
        catch (JsonProcessingException error) {
            RestCaller.throwJsonParseError(className, "updateProject", error);
        }
        SubjectAreaOMASAPIResponse restResponse = RestCaller.issuePut(className, "updateProject", requestBody, url);
        DetectUtils.detectAndThrowUserNotAuthorizedException("updateProject", restResponse);
        DetectUtils.detectAndThrowInvalidParameterException("updateProject", restResponse);
        Project project = DetectUtils.detectAndReturnProject("updateProject", restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : updateProject,userId=" + userId);
        }
        return project;
    }

    @Override
    public Project restoreProject(String userId, String guid) throws InvalidParameterException, UserNotAuthorizedException, MetadataServerUncontactableException, UnrecognizedGUIDException, FunctionNotSupportedException, UnexpectedResponseException {
        String methodName = "restoreProject";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: restoreProject,userId=" + userId + ",guid=" + guid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"restoreProject", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"restoreProject", (String)guid, (String)"guid");
        String urlTemplate = this.omasServerURL + BASE_URL + "/%s";
        String url = String.format(urlTemplate, this.serverName, userId, guid);
        SubjectAreaOMASAPIResponse restResponse = RestCaller.issuePostNoBody(className, "restoreProject", url);
        DetectUtils.detectAndThrowUserNotAuthorizedException("restoreProject", restResponse);
        DetectUtils.detectAndThrowInvalidParameterException("restoreProject", restResponse);
        DetectUtils.detectAndThrowUnrecognizedGUIDException("restoreProject", restResponse);
        DetectUtils.detectAndThrowFunctionNotSupportedException("restoreProject", restResponse);
        Project project = DetectUtils.detectAndReturnProject("restoreProject", restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : restoreProject,userId=" + userId);
        }
        return project;
    }
}

