/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.client;

import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.SubjectAreaErrorCode;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.FunctionNotSupportedException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.MetadataServerUncontactableException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.UnexpectedResponseException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.UserNotAuthorizedException;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.SequencingOrder;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Line;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SubjectAreaOMASAPIResponse;
import org.odpi.openmetadata.accessservices.subjectarea.utils.DetectUtils;
import org.odpi.openmetadata.accessservices.subjectarea.utils.QueryUtils;
import org.odpi.openmetadata.accessservices.subjectarea.utils.RestCaller;
import org.odpi.openmetadata.accessservices.subjectarea.validators.InputValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubjectAreaBaseImpl {
    private static final Logger log = LoggerFactory.getLogger(SubjectAreaBaseImpl.class);
    private static final String className = SubjectAreaBaseImpl.class.getName();
    protected String omasServerURL = null;
    protected String serverName;

    public SubjectAreaBaseImpl(String omasServerURL, String serverName) {
        this.omasServerURL = omasServerURL;
        this.serverName = serverName;
    }

    protected void encodeQueryProperty(String propertyName, String propertyValue, String methodName, StringBuffer queryStringSB) throws InvalidParameterException {
        try {
            QueryUtils.encodeQueryParam(propertyName, propertyValue, queryStringSB);
        }
        catch (UnsupportedEncodingException e) {
            SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.ERROR_ENCODING_QUERY_PARAMETER;
            throw new InvalidParameterException(errorCode.getMessageDefinition(), className, methodName, propertyName, propertyValue);
        }
    }

    protected List<Line> getRelationships(String base_url, String userId, String guid, Date asOfTime, int offset, int pageSize, SequencingOrder sequencingOrder, String sequencingProperty) throws InvalidParameterException, MetadataServerUncontactableException, UserNotAuthorizedException, FunctionNotSupportedException, UnexpectedResponseException {
        String methodName = "getRelationships";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getRelationships,userId=" + userId + ",guid=" + guid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getRelationships", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getRelationships", (String)guid, (String)"guid");
        String urlTemplate = this.omasServerURL + base_url + "/%s/relationships";
        String url = String.format(urlTemplate, this.serverName, userId, guid);
        if (sequencingOrder == null) {
            sequencingOrder = SequencingOrder.ANY;
        }
        StringBuffer queryStringSB = new StringBuffer();
        QueryUtils.addCharacterToQuery(queryStringSB);
        queryStringSB.append("sequencingOrder=" + sequencingOrder);
        if (asOfTime != null) {
            QueryUtils.addCharacterToQuery(queryStringSB);
            queryStringSB.append("asOfTime=" + asOfTime);
        }
        if (offset != 0) {
            QueryUtils.addCharacterToQuery(queryStringSB);
            queryStringSB.append("offset=" + offset);
        }
        if (pageSize != 0) {
            QueryUtils.addCharacterToQuery(queryStringSB);
            queryStringSB.append("pageSize=" + pageSize);
        }
        if (sequencingProperty != null) {
            this.encodeQueryProperty("sequencingProperty", sequencingProperty, "getRelationships", queryStringSB);
        }
        if (queryStringSB.length() > 0) {
            url = url + queryStringSB.toString();
        }
        SubjectAreaOMASAPIResponse restResponse = RestCaller.issueGet(className, "getRelationships", url);
        DetectUtils.detectAndThrowUserNotAuthorizedException(restResponse);
        DetectUtils.detectAndThrowInvalidParameterException(restResponse);
        DetectUtils.detectAndThrowFunctionNotSupportedException(restResponse);
        List<Line> relationships = DetectUtils.detectAndReturnLines(className, "getRelationships", restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getRelationships,userId=" + userId);
        }
        return relationships;
    }
}

