/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.client;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.accessservices.subjectarea.SubjectAreaGlossary;
import org.odpi.openmetadata.accessservices.subjectarea.client.SubjectAreaBaseImpl;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.SubjectAreaErrorCode;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.ClassificationException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.EntityNotDeletedException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.EntityNotPurgedException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.FunctionNotSupportedException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.MetadataServerUncontactableException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.UnexpectedResponseException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.UnrecognizedGUIDException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.UserNotAuthorizedException;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.SequencingOrder;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.glossary.Glossary;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Line;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.NodeType;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SubjectAreaOMASAPIResponse;
import org.odpi.openmetadata.accessservices.subjectarea.utils.DetectUtils;
import org.odpi.openmetadata.accessservices.subjectarea.utils.QueryUtils;
import org.odpi.openmetadata.accessservices.subjectarea.utils.RestCaller;
import org.odpi.openmetadata.accessservices.subjectarea.validators.InputValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubjectAreaGlossaryImpl
extends SubjectAreaBaseImpl
implements SubjectAreaGlossary {
    private static final Logger log = LoggerFactory.getLogger(SubjectAreaGlossaryImpl.class);
    private static final String className = SubjectAreaGlossaryImpl.class.getName();
    private static final String BASE_URL = "/servers/%s/open-metadata/access-services/subject-area/users/%s/glossaries";

    public SubjectAreaGlossaryImpl(String omasServerURL, String serverName) {
        super(omasServerURL, serverName);
    }

    @Override
    public Glossary createGlossary(String userId, Glossary suppliedGlossary) throws MetadataServerUncontactableException, InvalidParameterException, UserNotAuthorizedException, UnrecognizedGUIDException, ClassificationException, FunctionNotSupportedException, UnexpectedResponseException {
        String methodName = "createGlossary";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: createGlossary,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"createGlossary", (String)userId);
        String url = this.omasServerURL + String.format(BASE_URL, this.serverName, userId);
        InputValidator.validateNodeType((Object[])new Object[]{className, "createGlossary", suppliedGlossary.getNodeType(), NodeType.Glossary, NodeType.Taxonomy, NodeType.TaxonomyAndCanonicalGlossary, NodeType.CanonicalGlossary});
        ObjectMapper mapper = new ObjectMapper();
        String requestBody = null;
        try {
            requestBody = mapper.writeValueAsString((Object)suppliedGlossary);
        }
        catch (JsonProcessingException error) {
            RestCaller.throwJsonParseError(className, "createGlossary", error);
        }
        SubjectAreaOMASAPIResponse restResponse = RestCaller.issuePost(className, "createGlossary", requestBody, url);
        DetectUtils.detectAndThrowUserNotAuthorizedException(restResponse);
        DetectUtils.detectAndThrowInvalidParameterException(restResponse);
        DetectUtils.detectAndThrowUnrecognizedGUIDException(restResponse);
        DetectUtils.detectAndThrowClassificationException(restResponse);
        DetectUtils.detectAndThrowFunctionNotSupportedException(restResponse);
        Glossary glossary = DetectUtils.detectAndReturnGlossary(className, "createGlossary", restResponse);
        if (suppliedGlossary.getNodeType() != null && !suppliedGlossary.getNodeType().equals((Object)glossary.getNodeType())) {
            SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.UNEXPECTED_NODETYPE;
            throw new InvalidParameterException(errorCode.getMessageDefinition(), className, "createGlossary", "NodeType", suppliedGlossary.getNodeType().name());
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : createGlossary,userId=" + userId);
        }
        return glossary;
    }

    @Override
    public Glossary getGlossaryByGuid(String userId, String guid) throws MetadataServerUncontactableException, UnrecognizedGUIDException, UserNotAuthorizedException, InvalidParameterException, FunctionNotSupportedException, UnexpectedResponseException {
        String methodName = "getGlossaryByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getGlossaryByGuid,userId=" + userId + ",guid=" + guid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getGlossaryByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getGlossaryByGuid", (String)guid, (String)"guid");
        String urlTemplate = this.omasServerURL + BASE_URL + "/%s";
        String url = String.format(urlTemplate, this.serverName, userId, guid);
        SubjectAreaOMASAPIResponse restResponse = RestCaller.issueGet(className, "getGlossaryByGuid", url);
        DetectUtils.detectAndThrowUserNotAuthorizedException(restResponse);
        DetectUtils.detectAndThrowInvalidParameterException(restResponse);
        DetectUtils.detectAndThrowUnrecognizedGUIDException(restResponse);
        DetectUtils.detectAndThrowFunctionNotSupportedException(restResponse);
        Glossary glossary = DetectUtils.detectAndReturnGlossary(className, "getGlossaryByGuid", restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getGlossaryByGuid,userId=" + userId);
        }
        return glossary;
    }

    @Override
    public List<Line> getGlossaryRelationships(String userId, String guid, Date asOfTime, int offset, int pageSize, SequencingOrder sequencingOrder, String sequencingProperty) throws UserNotAuthorizedException, InvalidParameterException, FunctionNotSupportedException, UnexpectedResponseException, MetadataServerUncontactableException {
        String methodName = "getGlossaryRelationships";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getGlossaryRelationships,userId=" + userId + ",guid=" + guid);
        }
        List<Line> relationships = this.getRelationships(BASE_URL, userId, guid, asOfTime, offset, pageSize, sequencingOrder, sequencingProperty);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getGlossaryRelationships,userId=" + userId);
        }
        return relationships;
    }

    @Override
    public List<Glossary> findGlossary(String userId, String searchCriteria, Date asOfTime, int offset, int pageSize, SequencingOrder sequencingOrder, String sequencingProperty) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, FunctionNotSupportedException, UnexpectedResponseException {
        String methodName = "findGlossary";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: findGlossary,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"findGlossary", (String)userId);
        String urlTemplate = this.omasServerURL + BASE_URL;
        String url = String.format(urlTemplate, this.serverName, userId);
        if (sequencingOrder == null) {
            sequencingOrder = SequencingOrder.ANY;
        }
        StringBuffer queryStringSB = new StringBuffer();
        QueryUtils.addCharacterToQuery(queryStringSB);
        queryStringSB.append("sequencingOrder=" + sequencingOrder);
        if (asOfTime != null) {
            QueryUtils.addCharacterToQuery(queryStringSB);
            queryStringSB.append("asOfTime=" + asOfTime);
        }
        if (searchCriteria != null) {
            this.encodeQueryProperty("searchCriteria", searchCriteria, "findGlossary", queryStringSB);
        }
        if (offset != 0) {
            QueryUtils.addCharacterToQuery(queryStringSB);
            queryStringSB.append("offset=" + offset);
        }
        if (pageSize != 0) {
            QueryUtils.addCharacterToQuery(queryStringSB);
            queryStringSB.append("pageSize=" + pageSize);
        }
        if (sequencingProperty != null) {
            this.encodeQueryProperty("sequencingProperty", sequencingProperty, "findGlossary", queryStringSB);
        }
        if (queryStringSB.length() > 0) {
            url = url + queryStringSB.toString();
        }
        SubjectAreaOMASAPIResponse restResponse = RestCaller.issueGet(className, "findGlossary", url);
        DetectUtils.detectAndThrowUserNotAuthorizedException(restResponse);
        DetectUtils.detectAndThrowInvalidParameterException(restResponse);
        DetectUtils.detectAndThrowFunctionNotSupportedException(restResponse);
        List<Glossary> glossaries = DetectUtils.detectAndReturnGlossaries(className, "findGlossary", restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : findGlossary,userId=" + userId);
        }
        return glossaries;
    }

    @Override
    public Glossary replaceGlossary(String userId, String guid, Glossary suppliedGlossary) throws UnexpectedResponseException, UserNotAuthorizedException, InvalidParameterException, MetadataServerUncontactableException {
        String methodName = "replaceGlossary";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: replaceGlossary,userId=" + userId + ",guid=" + guid);
        }
        Glossary glossary = this.updateGlossary(userId, guid, suppliedGlossary, true);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : replaceGlossary,userId=" + userId);
        }
        return glossary;
    }

    @Override
    public Glossary updateGlossary(String userId, String guid, Glossary suppliedGlossary) throws UnexpectedResponseException, UserNotAuthorizedException, InvalidParameterException, MetadataServerUncontactableException {
        String methodName = "updateGlossary";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateGlossary,userId=" + userId + ",guid=" + guid);
        }
        Glossary glossary = this.updateGlossary(userId, guid, suppliedGlossary, false);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : updateGlossary,userId=" + userId);
        }
        return glossary;
    }

    @Override
    public Glossary deleteGlossary(String userId, String guid) throws InvalidParameterException, MetadataServerUncontactableException, UserNotAuthorizedException, UnrecognizedGUIDException, FunctionNotSupportedException, UnexpectedResponseException, EntityNotDeletedException {
        String methodName = "deleteGlossary";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteGlossary,userId=" + userId + ",guid=" + guid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"deleteGlossary", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"deleteGlossary", (String)guid, (String)"guid");
        String urlTemplate = this.omasServerURL + BASE_URL + "/%s?isPurge=false";
        String url = String.format(urlTemplate, this.serverName, userId, guid);
        SubjectAreaOMASAPIResponse restResponse = RestCaller.issueDelete(className, "deleteGlossary", url);
        DetectUtils.detectAndThrowUserNotAuthorizedException(restResponse);
        DetectUtils.detectAndThrowInvalidParameterException(restResponse);
        DetectUtils.detectAndThrowUnrecognizedGUIDException(restResponse);
        DetectUtils.detectAndThrowFunctionNotSupportedException(restResponse);
        DetectUtils.detectAndThrowEntityNotDeletedException(restResponse);
        Glossary glossary = DetectUtils.detectAndReturnGlossary(className, "deleteGlossary", restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : deleteGlossary,userId=" + userId);
        }
        return glossary;
    }

    @Override
    public void purgeGlossary(String userId, String guid) throws InvalidParameterException, UserNotAuthorizedException, MetadataServerUncontactableException, UnrecognizedGUIDException, EntityNotPurgedException, UnexpectedResponseException, FunctionNotSupportedException {
        String methodName = "purgeGlossary";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: purgeGlossary,userId=" + userId + ",guid=" + guid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"purgeGlossary", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"purgeGlossary", (String)guid, (String)"guid");
        String urlTemplate = this.omasServerURL + BASE_URL + "/%s?isPurge=true";
        String url = String.format(urlTemplate, this.serverName, userId, guid);
        SubjectAreaOMASAPIResponse restResponse = RestCaller.issueDelete(className, "purgeGlossary", url);
        DetectUtils.detectAndThrowUserNotAuthorizedException(restResponse);
        DetectUtils.detectAndThrowInvalidParameterException(restResponse);
        DetectUtils.detectAndThrowUnrecognizedGUIDException(restResponse);
        DetectUtils.detectAndThrowEntityNotPurgedException(restResponse);
        DetectUtils.detectAndThrowFunctionNotSupportedException(restResponse);
        DetectUtils.detectVoid(className, "purgeGlossary", restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : purgeGlossary,userId=" + userId);
        }
    }

    private Glossary updateGlossary(String userId, String guid, Glossary suppliedGlossary, boolean isReplace) throws UserNotAuthorizedException, InvalidParameterException, MetadataServerUncontactableException, UnexpectedResponseException {
        String methodName = "updateGlossary";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateGlossary,userId=" + userId + ",guid=" + guid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"updateGlossary", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"updateGlossary", (String)guid, (String)"guid");
        String urlTemplate = this.omasServerURL + BASE_URL + "/%s?isReplace=%b";
        String url = String.format(urlTemplate, this.serverName, userId, guid, isReplace);
        ObjectMapper mapper = new ObjectMapper();
        String requestBody = null;
        try {
            requestBody = mapper.writeValueAsString((Object)suppliedGlossary);
        }
        catch (JsonProcessingException error) {
            RestCaller.throwJsonParseError(className, "updateGlossary", error);
        }
        SubjectAreaOMASAPIResponse restResponse = RestCaller.issuePut(className, "updateGlossary", requestBody, url);
        DetectUtils.detectAndThrowUserNotAuthorizedException(restResponse);
        DetectUtils.detectAndThrowInvalidParameterException(restResponse);
        Glossary glossary = DetectUtils.detectAndReturnGlossary(className, "updateGlossary", restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : updateGlossary,userId=" + userId);
        }
        return glossary;
    }

    @Override
    public Glossary restoreGlossary(String userId, String guid) throws InvalidParameterException, UserNotAuthorizedException, MetadataServerUncontactableException, UnrecognizedGUIDException, FunctionNotSupportedException, UnexpectedResponseException {
        String methodName = "restoreGlossary";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: restoreGlossary,userId=" + userId + ",guid=" + guid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"restoreGlossary", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"restoreGlossary", (String)guid, (String)"guid");
        String urlTemplate = this.omasServerURL + BASE_URL + "/%s";
        String url = String.format(urlTemplate, this.serverName, userId, guid);
        SubjectAreaOMASAPIResponse restResponse = RestCaller.issuePostNoBody(className, "restoreGlossary", url);
        DetectUtils.detectAndThrowUserNotAuthorizedException(restResponse);
        DetectUtils.detectAndThrowInvalidParameterException(restResponse);
        DetectUtils.detectAndThrowUnrecognizedGUIDException(restResponse);
        DetectUtils.detectAndThrowFunctionNotSupportedException(restResponse);
        Glossary glossary = DetectUtils.detectAndReturnGlossary(className, "restoreGlossary", restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : restoreGlossary,userId=" + userId);
        }
        return glossary;
    }
}

