/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.client;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.accessservices.subjectarea.SubjectAreaTerm;
import org.odpi.openmetadata.accessservices.subjectarea.client.SubjectAreaBaseImpl;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.ClassificationException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.EntityNotDeletedException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.EntityNotPurgedException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.FunctionNotSupportedException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.MetadataServerUncontactableException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.UnexpectedResponseException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.UnrecognizedGUIDException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.UserNotAuthorizedException;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.SequencingOrder;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Line;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.term.Term;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SubjectAreaOMASAPIResponse;
import org.odpi.openmetadata.accessservices.subjectarea.utils.DetectUtils;
import org.odpi.openmetadata.accessservices.subjectarea.utils.QueryUtils;
import org.odpi.openmetadata.accessservices.subjectarea.utils.RestCaller;
import org.odpi.openmetadata.accessservices.subjectarea.validators.InputValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubjectAreaTermImpl
extends SubjectAreaBaseImpl
implements SubjectAreaTerm {
    private static final Logger log = LoggerFactory.getLogger(SubjectAreaTermImpl.class);
    private static final String className = SubjectAreaTermImpl.class.getName();
    private static final String BASE_URL = "/servers/%s/open-metadata/access-services/subject-area/users/%s/terms";

    public SubjectAreaTermImpl(String omasServerURL, String serverName) {
        super(omasServerURL, serverName);
    }

    @Override
    public Term createTerm(String userId, Term suppliedTerm) throws MetadataServerUncontactableException, InvalidParameterException, UserNotAuthorizedException, ClassificationException, FunctionNotSupportedException, UnexpectedResponseException {
        String methodName = "createTerm";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: createTerm,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"createTerm", (String)userId);
        String url = this.omasServerURL + String.format(BASE_URL, this.serverName, userId);
        ObjectMapper mapper = new ObjectMapper();
        String requestBody = null;
        try {
            requestBody = mapper.writeValueAsString((Object)suppliedTerm);
        }
        catch (JsonProcessingException error) {
            RestCaller.throwJsonParseError(className, "createTerm", error);
        }
        SubjectAreaOMASAPIResponse restResponse = RestCaller.issuePost(className, "createTerm", requestBody, url);
        DetectUtils.detectAndThrowUserNotAuthorizedException(restResponse);
        DetectUtils.detectAndThrowInvalidParameterException(restResponse);
        DetectUtils.detectAndThrowClassificationException(restResponse);
        DetectUtils.detectAndThrowFunctionNotSupportedException(restResponse);
        Term term = DetectUtils.detectAndReturnTerm(className, "createTerm", restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : createTerm,userId=" + userId);
        }
        return term;
    }

    @Override
    public Term getTermByGuid(String userId, String guid) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, FunctionNotSupportedException, UnexpectedResponseException {
        String methodName = "getTermByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getTermByGuid,userId=" + userId + ",guid=" + guid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"getTermByGuid", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"getTermByGuid", (String)guid, (String)"guid");
        String urlTemplate = this.omasServerURL + BASE_URL + "/%s";
        String url = String.format(urlTemplate, this.serverName, userId, guid);
        SubjectAreaOMASAPIResponse restResponse = RestCaller.issueGet(className, "getTermByGuid", url);
        DetectUtils.detectAndThrowUserNotAuthorizedException(restResponse);
        DetectUtils.detectAndThrowInvalidParameterException(restResponse);
        DetectUtils.detectAndThrowFunctionNotSupportedException(restResponse);
        Term term = DetectUtils.detectAndReturnTerm(className, "getTermByGuid", restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getTermByGuid,userId=" + userId);
        }
        return term;
    }

    @Override
    public List<Line> getTermRelationships(String userId, String guid, Date asOfTime, int offset, int pageSize, SequencingOrder sequencingOrder, String sequencingProperty) throws UserNotAuthorizedException, InvalidParameterException, FunctionNotSupportedException, UnexpectedResponseException, MetadataServerUncontactableException {
        String methodName = "getRelationships";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getRelationships,userId=" + userId + ",guid=" + guid);
        }
        List<Line> relationships = this.getRelationships(BASE_URL, userId, guid, asOfTime, offset, pageSize, sequencingOrder, sequencingProperty);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getRelationships,userId=" + userId);
        }
        return relationships;
    }

    @Override
    public Term replaceTerm(String userId, String guid, Term suppliedTerm) throws UnexpectedResponseException, UserNotAuthorizedException, FunctionNotSupportedException, InvalidParameterException, MetadataServerUncontactableException {
        String methodName = "replaceTerm";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: replaceTerm,userId=" + userId + ",guid=" + guid);
        }
        Term term = this.updateTerm(userId, guid, suppliedTerm, true);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : replaceTerm,userId=" + userId);
        }
        return term;
    }

    @Override
    public Term updateTerm(String userId, String guid, Term suppliedTerm) throws UnexpectedResponseException, UserNotAuthorizedException, FunctionNotSupportedException, InvalidParameterException, MetadataServerUncontactableException {
        String methodName = "updateTerm";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateTerm,userId=" + userId + ",guid=" + guid);
        }
        Term term = this.updateTerm(userId, guid, suppliedTerm, false);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : updateTerm,userId=" + userId);
        }
        return term;
    }

    @Override
    public Term deleteTerm(String userId, String guid) throws InvalidParameterException, MetadataServerUncontactableException, UserNotAuthorizedException, FunctionNotSupportedException, UnrecognizedGUIDException, UnexpectedResponseException, EntityNotDeletedException {
        String methodName = "deleteTerm";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteTerm,userId=" + userId + ",guid=" + guid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"deleteTerm", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"deleteTerm", (String)guid, (String)"guid");
        String urlTemplate = this.omasServerURL + BASE_URL + "/%s?isPurge=false";
        String url = String.format(urlTemplate, this.serverName, userId, guid);
        SubjectAreaOMASAPIResponse restResponse = RestCaller.issueDelete(className, "deleteTerm", url);
        DetectUtils.detectAndThrowUserNotAuthorizedException(restResponse);
        DetectUtils.detectAndThrowInvalidParameterException(restResponse);
        DetectUtils.detectAndThrowFunctionNotSupportedException(restResponse);
        DetectUtils.detectAndThrowEntityNotDeletedException(restResponse);
        Term term = DetectUtils.detectAndReturnTerm(className, "deleteTerm", restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : deleteTerm,userId=" + userId);
        }
        return term;
    }

    @Override
    public void purgeTerm(String userId, String guid) throws InvalidParameterException, UserNotAuthorizedException, MetadataServerUncontactableException, UnrecognizedGUIDException, FunctionNotSupportedException, EntityNotPurgedException {
        String methodName = "purgeTerm";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: purgeTerm,userId=" + userId + ",guid=" + guid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"purgeTerm", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"purgeTerm", (String)guid, (String)"guid");
        String urlTemplate = this.omasServerURL + BASE_URL + "/%s?isPurge=true";
        String url = String.format(urlTemplate, this.serverName, userId, guid);
        SubjectAreaOMASAPIResponse restResponse = RestCaller.issueDelete(className, "purgeTerm", url);
        DetectUtils.detectAndThrowUserNotAuthorizedException(restResponse);
        DetectUtils.detectAndThrowInvalidParameterException(restResponse);
        DetectUtils.detectAndThrowEntityNotPurgedException(restResponse);
        DetectUtils.detectAndThrowUnrecognizedGUIDException(restResponse);
        DetectUtils.detectAndThrowFunctionNotSupportedException(restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : purgeTerm,userId=" + userId);
        }
    }

    private Term updateTerm(String userId, String guid, Term suppliedTerm, boolean isReplace) throws UserNotAuthorizedException, InvalidParameterException, FunctionNotSupportedException, MetadataServerUncontactableException, UnexpectedResponseException {
        String methodName = "updateTerm";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateTerm,userId=" + userId + ",guid=" + guid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"updateTerm", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"updateTerm", (String)guid, (String)"guid");
        String urlTemplate = this.omasServerURL + BASE_URL + "/%s?isReplace=%b";
        String url = String.format(urlTemplate, this.serverName, userId, guid, isReplace);
        ObjectMapper mapper = new ObjectMapper();
        String requestBody = null;
        try {
            requestBody = mapper.writeValueAsString((Object)suppliedTerm);
        }
        catch (JsonProcessingException error) {
            RestCaller.throwJsonParseError(className, "updateTerm", error);
        }
        SubjectAreaOMASAPIResponse restResponse = RestCaller.issuePut(className, "updateTerm", requestBody, url);
        DetectUtils.detectAndThrowUserNotAuthorizedException(restResponse);
        DetectUtils.detectAndThrowInvalidParameterException(restResponse);
        DetectUtils.detectAndThrowFunctionNotSupportedException(restResponse);
        Term term = DetectUtils.detectAndReturnTerm(className, "updateTerm", restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : updateTerm,userId=" + userId);
        }
        return term;
    }

    @Override
    public Term restoreTerm(String userId, String guid) throws InvalidParameterException, UserNotAuthorizedException, MetadataServerUncontactableException, UnrecognizedGUIDException, FunctionNotSupportedException, UnexpectedResponseException {
        String methodName = "restoreTerm";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: restoreTerm,userId=" + userId + ",guid=" + guid);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"restoreTerm", (String)userId);
        InputValidator.validateGUIDNotNull((String)className, (String)"restoreTerm", (String)guid, (String)"guid");
        String urlTemplate = this.omasServerURL + BASE_URL + "/%s";
        String url = String.format(urlTemplate, this.serverName, userId, guid);
        SubjectAreaOMASAPIResponse restResponse = RestCaller.issuePostNoBody(className, "restoreTerm", url);
        DetectUtils.detectAndThrowUserNotAuthorizedException(restResponse);
        DetectUtils.detectAndThrowInvalidParameterException(restResponse);
        DetectUtils.detectAndThrowUnrecognizedGUIDException(restResponse);
        DetectUtils.detectAndThrowFunctionNotSupportedException(restResponse);
        Term term = DetectUtils.detectAndReturnTerm(className, "restoreTerm", restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : restoreTerm,userId=" + userId);
        }
        return term;
    }

    @Override
    public List<Term> findTerm(String userId, String searchCriteria, Date asOfTime, int offset, int pageSize, SequencingOrder sequencingOrder, String sequencingProperty) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, FunctionNotSupportedException, UnexpectedResponseException {
        String methodName = "findTerm";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: findTerm,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull((String)className, (String)"findTerm", (String)userId);
        String urlTemplate = this.omasServerURL + BASE_URL;
        String url = String.format(urlTemplate, this.serverName, userId);
        if (sequencingOrder == null) {
            sequencingOrder = SequencingOrder.ANY;
        }
        StringBuffer queryStringSB = new StringBuffer();
        QueryUtils.addCharacterToQuery(queryStringSB);
        queryStringSB.append("sequencingOrder=" + sequencingOrder);
        if (asOfTime != null) {
            QueryUtils.addCharacterToQuery(queryStringSB);
            queryStringSB.append("asOfTime=" + asOfTime);
        }
        if (searchCriteria != null) {
            this.encodeQueryProperty("searchCriteria", searchCriteria, "findTerm", queryStringSB);
        }
        if (offset != 0) {
            QueryUtils.addCharacterToQuery(queryStringSB);
            queryStringSB.append("offset=" + offset);
        }
        if (pageSize != 0) {
            QueryUtils.addCharacterToQuery(queryStringSB);
            queryStringSB.append("pageSize=" + pageSize);
        }
        if (sequencingProperty != null) {
            this.encodeQueryProperty("sequencingProperty", sequencingProperty, "findTerm", queryStringSB);
        }
        if (queryStringSB.length() > 0) {
            url = url + queryStringSB.toString();
        }
        SubjectAreaOMASAPIResponse restResponse = RestCaller.issueGet(className, "findTerm", url);
        DetectUtils.detectAndThrowUserNotAuthorizedException(restResponse);
        DetectUtils.detectAndThrowInvalidParameterException(restResponse);
        DetectUtils.detectAndThrowFunctionNotSupportedException(restResponse);
        List<Term> terms = DetectUtils.detectAndReturnTerms(className, "findTerm", restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : findTerm,userId=" + userId);
        }
        return terms;
    }
}

