/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.client;

import org.odpi.openmetadata.accessservices.subjectarea.SubjectArea;
import org.odpi.openmetadata.accessservices.subjectarea.client.SubjectAreaRestClient;
import org.odpi.openmetadata.accessservices.subjectarea.client.entities.SubjectAreaNode;
import org.odpi.openmetadata.accessservices.subjectarea.client.entities.categories.SubjectAreaCategory;
import org.odpi.openmetadata.accessservices.subjectarea.client.entities.glossaries.SubjectAreaGlossary;
import org.odpi.openmetadata.accessservices.subjectarea.client.entities.projects.SubjectAreaProject;
import org.odpi.openmetadata.accessservices.subjectarea.client.entities.terms.SubjectAreaTerm;
import org.odpi.openmetadata.accessservices.subjectarea.client.relationships.SubjectAreaGraph;
import org.odpi.openmetadata.accessservices.subjectarea.client.relationships.SubjectAreaGraphClient;
import org.odpi.openmetadata.accessservices.subjectarea.client.relationships.SubjectAreaLine;
import org.odpi.openmetadata.accessservices.subjectarea.client.relationships.SubjectAreaRelationship;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.SubjectAreaErrorCode;
import org.odpi.openmetadata.accessservices.subjectarea.validators.InputValidator;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.ExceptionMessageDefinition;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;

public class SubjectAreaImpl
implements SubjectArea {
    private static final String className = SubjectAreaImpl.class.getName();
    private final SubjectAreaTerm termAPI;
    private final SubjectAreaCategory categoryAPI;
    private final SubjectAreaGlossary glossaryAPI;
    private final SubjectAreaProject projectAPI;
    public final SubjectAreaRelationship relationshipAPI;
    public final SubjectAreaGraph graphAPI;
    public final String serverName;
    public final String omasServerUrl;

    public SubjectAreaImpl(String serverName, String omasServerURL) throws org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.InvalidParameterException {
        String methodName = "SubjectAreaImpl";
        InputValidator.validateRemoteServerNameNotNull((String)className, (String)methodName, (String)serverName);
        InputValidator.validateRemoteServerURLNotNull((String)className, (String)methodName, (String)omasServerURL);
        try {
            SubjectAreaRestClient client = new SubjectAreaRestClient(serverName, omasServerURL);
            SubjectAreaNode subjectAreaNode = new SubjectAreaNode(client);
            SubjectAreaLine subjectAreaLine = new SubjectAreaLine(client);
            SubjectAreaGraphClient subjectAreaGraph = new SubjectAreaGraphClient(client);
            this.glossaryAPI = subjectAreaNode;
            this.termAPI = subjectAreaNode;
            this.categoryAPI = subjectAreaNode;
            this.relationshipAPI = subjectAreaLine;
            this.graphAPI = subjectAreaGraph;
            this.projectAPI = subjectAreaNode;
        }
        catch (InvalidParameterException e) {
            String parameterName = "serverName or omasServerURL";
            String parameterValue = "unknown";
            if (serverName == null || "".equals(serverName)) {
                parameterName = "serverName";
                parameterValue = serverName;
            }
            if (omasServerURL == null || "".equals(omasServerURL)) {
                parameterName = "omasServerURL";
                parameterValue = omasServerURL;
            }
            ExceptionMessageDefinition messageDefinition = SubjectAreaErrorCode.SUBJECT_AREA_FAILED_TO_INITIALISE.getMessageDefinition();
            messageDefinition.setMessageParameters(new String[]{parameterName, parameterValue});
            throw new org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.InvalidParameterException(messageDefinition, className, methodName, (Throwable)e, parameterName, parameterValue);
        }
        this.serverName = serverName;
        this.omasServerUrl = omasServerURL;
    }

    @Override
    public SubjectAreaCategory getSubjectAreaCategory() {
        return this.categoryAPI;
    }

    @Override
    public SubjectAreaGlossary getSubjectAreaGlossary() {
        return this.glossaryAPI;
    }

    @Override
    public SubjectAreaProject getSubjectAreaProject() {
        return this.projectAPI;
    }

    @Override
    public SubjectAreaTerm getSubjectAreaTerm() {
        return this.termAPI;
    }

    @Override
    public SubjectAreaRelationship getSubjectAreaRelationship() {
        return this.relationshipAPI;
    }

    @Override
    public SubjectAreaGraph getSubjectAreaGraph() {
        return this.graphAPI;
    }

    @Override
    public String getServerName() {
        return this.serverName;
    }

    @Override
    public String getOmasServerUrl() {
        return this.omasServerUrl;
    }
}

