/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.client.entities;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.odpi.openmetadata.accessservices.subjectarea.client.SubjectAreaEntityClient;
import org.odpi.openmetadata.accessservices.subjectarea.client.SubjectAreaRestClient;
import org.odpi.openmetadata.accessservices.subjectarea.client.entities.AbstractSubjectAreaEntity;
import org.odpi.openmetadata.accessservices.subjectarea.client.entities.SubjectAreaNodeClient;
import org.odpi.openmetadata.accessservices.subjectarea.client.entities.categories.SubjectAreaCategory;
import org.odpi.openmetadata.accessservices.subjectarea.client.entities.glossaries.SubjectAreaGlossary;
import org.odpi.openmetadata.accessservices.subjectarea.client.entities.projects.SubjectAreaProject;
import org.odpi.openmetadata.accessservices.subjectarea.client.entities.terms.SubjectAreaTerm;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.category.Category;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.category.SubjectAreaDefinition;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.glossary.Glossary;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Node;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.project.Project;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.term.Term;
import org.reflections.Reflections;

public class SubjectAreaNode
implements SubjectAreaCategory,
SubjectAreaTerm,
SubjectAreaProject,
SubjectAreaGlossary {
    private Map<Class<?>, SubjectAreaEntityClient<?>> cache = new HashMap();
    private static final String DEFAULT_SCAN_PACKAGE = SubjectAreaNode.class.getPackage().getName();

    public SubjectAreaNode(SubjectAreaRestClient subjectAreaRestClient, String ... packagesToScan) {
        HashSet<String> packages = new HashSet<String>(Arrays.asList(packagesToScan));
        packages.add(DEFAULT_SCAN_PACKAGE);
        Reflections reflections = new Reflections(new Object[]{packages});
        Set clientClasses = reflections.getTypesAnnotatedWith(SubjectAreaNodeClient.class);
        for (Class declaredClass : clientClasses) {
            try {
                if (!AbstractSubjectAreaEntity.class.isAssignableFrom(declaredClass)) continue;
                Constructor ctor = declaredClass.getDeclaredConstructor(SubjectAreaRestClient.class);
                ctor.setAccessible(true);
                AbstractSubjectAreaEntity newInstance = (AbstractSubjectAreaEntity)ctor.newInstance(new Object[]{subjectAreaRestClient});
                this.cache.put(newInstance.type(), newInstance);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new ExceptionInInitializerError("During initialization SubjectAreaNode an error has occurred - " + e.getMessage());
            }
        }
    }

    public SubjectAreaNode(SubjectAreaRestClient subjectAreaRestClient) {
        this(subjectAreaRestClient, DEFAULT_SCAN_PACKAGE);
    }

    @Override
    public SubjectAreaEntityClient<Category> category() {
        return this.getClient(Category.class);
    }

    @Override
    public SubjectAreaEntityClient<SubjectAreaDefinition> subjectAreaDefinition() {
        return this.getClient(SubjectAreaDefinition.class);
    }

    @Override
    public SubjectAreaEntityClient<Glossary> glossary() {
        return this.getClient(Glossary.class);
    }

    @Override
    public SubjectAreaEntityClient<Project> project() {
        return this.getClient(Project.class);
    }

    @Override
    public SubjectAreaEntityClient<Term> term() {
        return this.getClient(Term.class);
    }

    public <T extends Node> SubjectAreaEntityClient<T> getClient(Class<T> clazz) {
        if (this.cache.containsKey(clazz)) {
            return this.cache.get(clazz);
        }
        return null;
    }
}

