/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.client.relationships;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.odpi.openmetadata.accessservices.subjectarea.client.SubjectAreaClient;
import org.odpi.openmetadata.accessservices.subjectarea.client.SubjectAreaRelationshipClient;
import org.odpi.openmetadata.accessservices.subjectarea.client.SubjectAreaRestClient;
import org.odpi.openmetadata.accessservices.subjectarea.client.relationships.AbstractSubjectAreaRelationship;
import org.odpi.openmetadata.accessservices.subjectarea.client.relationships.SubjectAreaLineClient;
import org.odpi.openmetadata.accessservices.subjectarea.client.relationships.SubjectAreaRelationship;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Line;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.Antonym;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.Categorization;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.CategoryAnchor;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.CategoryHierarchyLink;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.HasA;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.IsA;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.IsATypeOf;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.PreferredTerm;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.ProjectScope;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.RelatedTerm;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.ReplacementTerm;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.SemanticAssignment;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.Synonym;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.TermAnchor;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.Translation;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.TypedBy;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.UsedInContext;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.ValidValue;
import org.reflections.Reflections;

public class SubjectAreaLine
implements SubjectAreaRelationship {
    private static final String HASA = "has-as";
    private static final String RELATED_TERM = "related-terms";
    private static final String SYNONYM = "synonyms";
    private static final String ANTONYM = "antonyms";
    private static final String TRANSLATION = "translations";
    private static final String USED_IN_CONTEXT = "used-in-contexts";
    private static final String PREFERRED_TERM = "preferred-terms";
    private static final String VALID_VALUE = "valid-values";
    private static final String REPLACEMENT_TERM = "replacement-terms";
    private static final String TYPED_BY = "typed-bys";
    private static final String IS_A = "is-as";
    private static final String IS_A_TYPE_OF = "is-a-type-ofs";
    private static final String TERM_CATEGORIZATION = "term-categorizations";
    private static final String SEMANTIC_ASSIGNMENT = "semantic-assignments";
    private static final String TERM_ANCHOR = "term-anchor";
    private static final String CATEGORY_ANCHOR = "category-anchor";
    private static final String PROJECT_SCOPE = "project-scopes";
    private static final String CATEGORY_HIERARCHY_LINK = "category-hierarchy-link";
    private Map<Class<?>, SubjectAreaRelationshipClient<?>> cache = new HashMap();
    private static final String DEFAULT_SCAN_PACKAGE = SubjectAreaLine.class.getPackage().getName();

    public SubjectAreaLine(SubjectAreaRestClient subjectAreaRestClient, String ... packagesToScan) {
        HashSet<String> packages = new HashSet<String>(Arrays.asList(packagesToScan));
        packages.add(DEFAULT_SCAN_PACKAGE);
        Reflections reflections = new Reflections(new Object[]{packages});
        Set clientClasses = reflections.getTypesAnnotatedWith(SubjectAreaLineClient.class);
        for (Class declaredClass : clientClasses) {
            try {
                if (!AbstractSubjectAreaRelationship.class.isAssignableFrom(declaredClass)) continue;
                Constructor ctor = declaredClass.getDeclaredConstructor(SubjectAreaRestClient.class);
                ctor.setAccessible(true);
                AbstractSubjectAreaRelationship newInstance = (AbstractSubjectAreaRelationship)ctor.newInstance(new Object[]{subjectAreaRestClient});
                this.cache.put(newInstance.type(), newInstance);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new ExceptionInInitializerError("During initialization SubjectAreaLine an error has occurred - " + e.getMessage());
            }
        }
    }

    public SubjectAreaLine(SubjectAreaRestClient subjectAreaRestClient) {
        this(subjectAreaRestClient, DEFAULT_SCAN_PACKAGE);
    }

    @Override
    public SubjectAreaRelationshipClient<HasA> hasA() {
        return this.getClient(HasA.class);
    }

    @Override
    public SubjectAreaRelationshipClient<RelatedTerm> relatedTerm() {
        return this.getClient(RelatedTerm.class);
    }

    @Override
    public SubjectAreaRelationshipClient<TermAnchor> termAnchor() {
        return this.getClient(TermAnchor.class);
    }

    @Override
    public SubjectAreaRelationshipClient<ProjectScope> projectScope() {
        return this.getClient(ProjectScope.class);
    }

    @Override
    public SubjectAreaRelationshipClient<Synonym> synonym() {
        return this.getClient(Synonym.class);
    }

    @Override
    public SubjectAreaRelationshipClient<Antonym> antonym() {
        return this.getClient(Antonym.class);
    }

    @Override
    public SubjectAreaRelationshipClient<Translation> translation() {
        return this.getClient(Translation.class);
    }

    @Override
    public SubjectAreaRelationshipClient<UsedInContext> usedInContext() {
        return this.getClient(UsedInContext.class);
    }

    @Override
    public SubjectAreaRelationshipClient<PreferredTerm> preferredTerm() {
        return this.getClient(PreferredTerm.class);
    }

    @Override
    public SubjectAreaRelationshipClient<ValidValue> validValue() {
        return this.getClient(ValidValue.class);
    }

    @Override
    public SubjectAreaRelationshipClient<ReplacementTerm> replacementTerm() {
        return this.getClient(ReplacementTerm.class);
    }

    @Override
    public SubjectAreaRelationshipClient<TypedBy> typedBy() {
        return this.getClient(TypedBy.class);
    }

    @Override
    public SubjectAreaRelationshipClient<IsA> isA() {
        return this.getClient(IsA.class);
    }

    @Override
    public SubjectAreaRelationshipClient<IsATypeOf> isaTypeOf() {
        return this.getClient(IsATypeOf.class);
    }

    @Override
    public SubjectAreaRelationshipClient<Categorization> termCategorization() {
        return this.getClient(Categorization.class);
    }

    @Override
    public SubjectAreaRelationshipClient<SemanticAssignment> semanticAssignment() {
        return this.getClient(SemanticAssignment.class);
    }

    @Override
    public SubjectAreaClient<CategoryHierarchyLink> categoryHierarchyLink() {
        return this.getClient(CategoryHierarchyLink.class);
    }

    @Override
    public SubjectAreaRelationshipClient<CategoryAnchor> categoryAnchor() {
        return this.getClient(CategoryAnchor.class);
    }

    public <T extends Line> SubjectAreaRelationshipClient<T> getClient(Class<T> clazz) {
        if (this.cache.containsKey(clazz)) {
            return this.cache.get(clazz);
        }
        return null;
    }

    @SubjectAreaLineClient
    static class SubjectAreaProjectScopeClient
    extends AbstractSubjectAreaRelationship<ProjectScope> {
        protected SubjectAreaProjectScopeClient(SubjectAreaRestClient subjectAreaRestClient) {
            super(subjectAreaRestClient, SubjectAreaLine.PROJECT_SCOPE);
        }

        @Override
        public Class<ProjectScope> type() {
            return ProjectScope.class;
        }
    }

    @SubjectAreaLineClient
    static class SubjectAreaIsaTypeOfClient
    extends AbstractSubjectAreaRelationship<IsATypeOf> {
        protected SubjectAreaIsaTypeOfClient(SubjectAreaRestClient subjectAreaRestClient) {
            super(subjectAreaRestClient, SubjectAreaLine.IS_A_TYPE_OF);
        }

        @Override
        public Class<IsATypeOf> type() {
            return IsATypeOf.class;
        }
    }

    @SubjectAreaLineClient
    static class SubjectAreaIsaClient
    extends AbstractSubjectAreaRelationship<IsA> {
        protected SubjectAreaIsaClient(SubjectAreaRestClient subjectAreaRestClient) {
            super(subjectAreaRestClient, SubjectAreaLine.IS_A);
        }

        @Override
        public Class<IsA> type() {
            return IsA.class;
        }
    }

    @SubjectAreaLineClient
    static class SubjectAreaTypedByClient
    extends AbstractSubjectAreaRelationship<TypedBy> {
        protected SubjectAreaTypedByClient(SubjectAreaRestClient subjectAreaRestClient) {
            super(subjectAreaRestClient, SubjectAreaLine.TYPED_BY);
        }

        @Override
        public Class<TypedBy> type() {
            return TypedBy.class;
        }
    }

    @SubjectAreaLineClient
    static class SubjectAreaSemanticAssignmentClient
    extends AbstractSubjectAreaRelationship<SemanticAssignment> {
        protected SubjectAreaSemanticAssignmentClient(SubjectAreaRestClient subjectAreaRestClient) {
            super(subjectAreaRestClient, SubjectAreaLine.SEMANTIC_ASSIGNMENT);
        }

        @Override
        public Class<SemanticAssignment> type() {
            return SemanticAssignment.class;
        }
    }

    @SubjectAreaLineClient
    static class SubjectAreaReplacementTermClient
    extends AbstractSubjectAreaRelationship<ReplacementTerm> {
        protected SubjectAreaReplacementTermClient(SubjectAreaRestClient subjectAreaRestClient) {
            super(subjectAreaRestClient, SubjectAreaLine.REPLACEMENT_TERM);
        }

        @Override
        public Class<ReplacementTerm> type() {
            return ReplacementTerm.class;
        }
    }

    @SubjectAreaLineClient
    static class SubjectAreaValidValueClient
    extends AbstractSubjectAreaRelationship<ValidValue> {
        protected SubjectAreaValidValueClient(SubjectAreaRestClient subjectAreaRestClient) {
            super(subjectAreaRestClient, SubjectAreaLine.VALID_VALUE);
        }

        @Override
        public Class<ValidValue> type() {
            return ValidValue.class;
        }
    }

    @SubjectAreaLineClient
    static class SubjectAreaPreferredTermClient
    extends AbstractSubjectAreaRelationship<PreferredTerm> {
        protected SubjectAreaPreferredTermClient(SubjectAreaRestClient subjectAreaRestClient) {
            super(subjectAreaRestClient, SubjectAreaLine.PREFERRED_TERM);
        }

        @Override
        public Class<PreferredTerm> type() {
            return PreferredTerm.class;
        }
    }

    @SubjectAreaLineClient
    static class SubjectAreaUsedInContextClient
    extends AbstractSubjectAreaRelationship<UsedInContext> {
        protected SubjectAreaUsedInContextClient(SubjectAreaRestClient subjectAreaRestClient) {
            super(subjectAreaRestClient, SubjectAreaLine.USED_IN_CONTEXT);
        }

        @Override
        public Class<UsedInContext> type() {
            return UsedInContext.class;
        }
    }

    @SubjectAreaLineClient
    static class SubjectAreaTranslationClient
    extends AbstractSubjectAreaRelationship<Translation> {
        protected SubjectAreaTranslationClient(SubjectAreaRestClient subjectAreaRestClient) {
            super(subjectAreaRestClient, SubjectAreaLine.TRANSLATION);
        }

        @Override
        public Class<Translation> type() {
            return Translation.class;
        }
    }

    @SubjectAreaLineClient
    static class SubjectAreaCategorizationClient
    extends AbstractSubjectAreaRelationship<Categorization> {
        protected SubjectAreaCategorizationClient(SubjectAreaRestClient subjectAreaRestClient) {
            super(subjectAreaRestClient, SubjectAreaLine.TERM_CATEGORIZATION);
        }

        @Override
        public Class<Categorization> type() {
            return Categorization.class;
        }
    }

    @SubjectAreaLineClient
    static class SubjectAreaCategoryAnchorClient
    extends AbstractSubjectAreaRelationship<CategoryAnchor> {
        protected SubjectAreaCategoryAnchorClient(SubjectAreaRestClient subjectAreaRestClient) {
            super(subjectAreaRestClient, SubjectAreaLine.CATEGORY_ANCHOR);
        }

        @Override
        public Class<CategoryAnchor> type() {
            return CategoryAnchor.class;
        }
    }

    @SubjectAreaLineClient
    static class SubjectAreaAntonymClient
    extends AbstractSubjectAreaRelationship<Antonym> {
        protected SubjectAreaAntonymClient(SubjectAreaRestClient subjectAreaRestClient) {
            super(subjectAreaRestClient, SubjectAreaLine.ANTONYM);
        }

        @Override
        public Class<Antonym> type() {
            return Antonym.class;
        }
    }

    @SubjectAreaLineClient
    static class SubjectAreaSynonymClient
    extends AbstractSubjectAreaRelationship<Synonym> {
        protected SubjectAreaSynonymClient(SubjectAreaRestClient subjectAreaRestClient) {
            super(subjectAreaRestClient, SubjectAreaLine.SYNONYM);
        }

        @Override
        public Class<Synonym> type() {
            return Synonym.class;
        }
    }

    @SubjectAreaLineClient
    static class SubjectAreaHasaClient
    extends AbstractSubjectAreaRelationship<HasA> {
        protected SubjectAreaHasaClient(SubjectAreaRestClient subjectAreaRestClient) {
            super(subjectAreaRestClient, SubjectAreaLine.HASA);
        }

        @Override
        public Class<HasA> type() {
            return HasA.class;
        }
    }

    @SubjectAreaLineClient
    static class SubjectAreaRelatedTermClient
    extends AbstractSubjectAreaRelationship<RelatedTerm> {
        protected SubjectAreaRelatedTermClient(SubjectAreaRestClient subjectAreaRestClient) {
            super(subjectAreaRestClient, SubjectAreaLine.RELATED_TERM);
        }

        @Override
        public Class<RelatedTerm> type() {
            return RelatedTerm.class;
        }
    }

    @SubjectAreaLineClient
    static class SubjectAreaTermAnchorClient
    extends AbstractSubjectAreaRelationship<TermAnchor> {
        protected SubjectAreaTermAnchorClient(SubjectAreaRestClient subjectAreaRestClient) {
            super(subjectAreaRestClient, SubjectAreaLine.TERM_ANCHOR);
        }

        @Override
        public Class<TermAnchor> type() {
            return TermAnchor.class;
        }
    }

    @SubjectAreaLineClient
    static class SubjectAreaCategoryHierarchyLinkClient
    extends AbstractSubjectAreaRelationship<CategoryHierarchyLink> {
        protected SubjectAreaCategoryHierarchyLinkClient(SubjectAreaRestClient subjectAreaRestClient) {
            super(subjectAreaRestClient, SubjectAreaLine.CATEGORY_HIERARCHY_LINK);
        }

        @Override
        public Class<CategoryHierarchyLink> type() {
            return CategoryHierarchyLink.class;
        }
    }
}

