/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.client;

import java.util.Collection;
import java.util.Map;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.FindRequest;
import org.odpi.openmetadata.accessservices.subjectarea.utils.QueryBuilder;
import org.odpi.openmetadata.accessservices.subjectarea.utils.QueryUtils;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCRESTClient;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GenericResponse;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ParameterizedTypeReference;

public class SubjectAreaRestClient
extends FFDCRESTClient {
    private static final Logger log = LoggerFactory.getLogger(SubjectAreaRestClient.class);
    protected static final InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();
    private final String serverName;
    private final String serverPlatformURLRoot;

    public SubjectAreaRestClient(String serverName, String serverPlatformURLRoot) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot);
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
    }

    public SubjectAreaRestClient(String serverName, String serverPlatformURLRoot, String userId, String password) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, userId, password);
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
    }

    public <T> GenericResponse<T> postRESTCall(String userId, String methodName, String urnTemplate, ParameterizedTypeReference<GenericResponse<T>> type, T requestBody) throws PropertyServerException, UserNotAuthorizedException, InvalidParameterException {
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId=" + userId);
        }
        String expandedURL = String.format(this.serverPlatformURLRoot + urnTemplate, this.serverName, userId);
        GenericResponse response = (GenericResponse)this.callPostRESTCall(methodName, type, expandedURL, requestBody, new Object[0]);
        this.exceptionHandler.detectAndThrowStandardExceptions(methodName, (FFDCResponse)response);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : " + methodName + ",userId=" + userId);
        }
        return response;
    }

    public <T> GenericResponse<T> putRESTCall(String userId, String guid, String methodName, String urnTemplate, ParameterizedTypeReference<GenericResponse<T>> type, T requestBody) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId=" + userId + ",guid=" + guid);
        }
        String expandedURL = String.format(this.serverPlatformURLRoot + urnTemplate, this.serverName, userId, guid);
        GenericResponse response = (GenericResponse)this.callPutRESTCall(methodName, type, expandedURL, requestBody, new Object[0]);
        this.exceptionHandler.detectAndThrowStandardExceptions(methodName, (FFDCResponse)response);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : " + methodName + ",userId=" + userId);
        }
        return response;
    }

    public <T> GenericResponse<T> getByIdRESTCall(String userId, String guid, String methodName, ParameterizedTypeReference<GenericResponse<T>> type, String urnTemplate) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getByIdRESTCall(userId, guid, methodName, type, urnTemplate, null, null, null);
    }

    public <T> GenericResponse<T> getByIdRESTCall(String userId, String guid, String methodName, ParameterizedTypeReference<GenericResponse<T>> type, String urnTemplate, FindRequest findRequest) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getByIdRESTCall(userId, guid, methodName, type, urnTemplate, findRequest, null, null);
    }

    public <T> GenericResponse<T> getByIdRESTCall(String userId, String guid, String methodName, ParameterizedTypeReference<GenericResponse<T>> type, String urnTemplate, FindRequest findRequest, Integer maximumPageSizeOnRestCall, Map<String, String> params) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId=" + userId + ",guid=" + guid);
        }
        GenericResponse<T> completeResponse = null;
        int requestedPageSize = 0;
        if (findRequest != null) {
            if (findRequest.getPageSize() == null) {
                findRequest.setPageSize(Integer.valueOf(invalidParameterHandler.getMaxPagingSize()));
            }
            invalidParameterHandler.validatePaging(findRequest.getStartingFrom(), findRequest.getPageSize().intValue(), methodName);
            requestedPageSize = findRequest.getPageSize();
        }
        if (maximumPageSizeOnRestCall == null || maximumPageSizeOnRestCall < 1 || maximumPageSizeOnRestCall >= requestedPageSize) {
            String expandedURL;
            if (findRequest == null) {
                expandedURL = String.format(this.serverPlatformURLRoot + urnTemplate, this.serverName, userId, guid);
            } else {
                QueryBuilder queryBuilder = this.createFindQuery(methodName, findRequest);
                if (params != null && params.keySet().size() > 0) {
                    for (String param : params.keySet()) {
                        queryBuilder.addParam(param, params.get(param));
                    }
                }
                String findUrlTemplate = urnTemplate + queryBuilder.toString();
                expandedURL = String.format(this.serverPlatformURLRoot + findUrlTemplate, this.serverName, userId, guid);
            }
            completeResponse = (GenericResponse<T>)this.callGetRESTCall(methodName, type, expandedURL, new Object[0]);
            this.exceptionHandler.detectAndThrowStandardExceptions(methodName, completeResponse);
        } else {
            int lastIndex = urnTemplate.lastIndexOf("%s");
            String lastBit = urnTemplate.substring(lastIndex);
            String lastBitWithGuid = lastBit.replace("%s", guid);
            urnTemplate = urnTemplate.substring(0, lastIndex) + lastBitWithGuid;
            completeResponse = this.getAccumulatedResponse(userId, methodName, urnTemplate, type, findRequest, maximumPageSizeOnRestCall, requestedPageSize);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : " + methodName + ",userId=" + userId);
        }
        return completeResponse;
    }

    public <T> GenericResponse<T> findRESTCall(String userId, String methodName, String urnTemplate, ParameterizedTypeReference<GenericResponse<T>> type, FindRequest findRequest) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.findRESTCall(userId, methodName, urnTemplate, type, findRequest, null);
    }

    public <T> GenericResponse<T> findRESTCall(String userId, String methodName, String urnTemplate, ParameterizedTypeReference<GenericResponse<T>> type, FindRequest findRequest, Integer maximumPageSizeOnRestCall) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId=" + userId);
        }
        GenericResponse completeResponse = null;
        if (findRequest.getPageSize() == null) {
            findRequest.setPageSize(Integer.valueOf(invalidParameterHandler.getMaxPagingSize()));
        }
        invalidParameterHandler.validatePaging(findRequest.getStartingFrom(), findRequest.getPageSize().intValue(), methodName);
        int requestedPageSize = findRequest.getPageSize();
        if (maximumPageSizeOnRestCall == null || maximumPageSizeOnRestCall < 1 || maximumPageSizeOnRestCall >= requestedPageSize) {
            String findUrlTemplate = urnTemplate + this.createFindQuery(methodName, findRequest).toString();
            String expandedURL = String.format(this.serverPlatformURLRoot + findUrlTemplate, this.serverName, userId);
            completeResponse = (GenericResponse)this.callGetRESTCall(methodName, type, expandedURL, new Object[0]);
            this.exceptionHandler.detectAndThrowStandardExceptions(methodName, (FFDCResponse)completeResponse);
        } else {
            completeResponse = this.getAccumulatedResponse(userId, methodName, urnTemplate, type, findRequest, maximumPageSizeOnRestCall, requestedPageSize);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : " + methodName + ",userId=" + userId);
        }
        return completeResponse;
    }

    private <T> GenericResponse<T> getAccumulatedResponse(String userId, String methodName, String urnTemplate, ParameterizedTypeReference<GenericResponse<T>> type, FindRequest findRequest, Integer maximumPageSizeOnRestCall, int requestedPageSize) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        GenericResponse completeResponse = null;
        int startingFrom = findRequest.getStartingFrom();
        int totalNumberRetrieved = 0;
        while (totalNumberRetrieved < requestedPageSize) {
            findRequest.setPageSize(maximumPageSizeOnRestCall);
            findRequest.setStartingFrom(startingFrom + totalNumberRetrieved);
            String findUrlTemplate = urnTemplate + this.createFindQuery(methodName, findRequest).toString();
            String expandedURL = String.format(this.serverPlatformURLRoot + findUrlTemplate, this.serverName, userId);
            GenericResponse responseForPart = (GenericResponse)this.callGetRESTCall(methodName, type, expandedURL, new Object[0]);
            this.exceptionHandler.detectAndThrowStandardExceptions(methodName, (FFDCResponse)responseForPart);
            int numberRetrieved = responseForPart.results().size();
            totalNumberRetrieved = this.getMore(numberRetrieved, maximumPageSizeOnRestCall, requestedPageSize) ? (totalNumberRetrieved += numberRetrieved) : requestedPageSize;
            if (completeResponse == null) {
                completeResponse = responseForPart;
                continue;
            }
            completeResponse.addAllResults((Collection)responseForPart.results());
        }
        return completeResponse;
    }

    boolean getMore(int numberRetrieved, int maximumPageSizeOnRestCall, int requestedPageSize) {
        return numberRetrieved == maximumPageSizeOnRestCall && requestedPageSize > maximumPageSizeOnRestCall;
    }

    public <T> GenericResponse<T> findRESTCall(String userId, String guid, String methodName, String urnTemplate, ParameterizedTypeReference<GenericResponse<T>> type, FindRequest findRequest, Integer maximumPageSizeOnRestCall) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        GenericResponse<T> completeResponse = null;
        if (findRequest.getPageSize() == null) {
            findRequest.setPageSize(Integer.valueOf(invalidParameterHandler.getMaxPagingSize()));
        }
        invalidParameterHandler.validatePaging(findRequest.getStartingFrom(), findRequest.getPageSize().intValue(), methodName);
        int requestedPageSize = findRequest.getPageSize();
        int startingFrom = findRequest.getStartingFrom();
        if (maximumPageSizeOnRestCall == null || maximumPageSizeOnRestCall == 0 || maximumPageSizeOnRestCall >= requestedPageSize) {
            completeResponse = this.getByIdRESTCall(userId, guid, methodName, type, urnTemplate, findRequest);
            this.exceptionHandler.detectAndThrowStandardExceptions(methodName, completeResponse);
        } else {
            int totalNumberRetrieved = 0;
            while (totalNumberRetrieved < requestedPageSize) {
                findRequest.setPageSize(maximumPageSizeOnRestCall);
                findRequest.setStartingFrom(totalNumberRetrieved);
                GenericResponse<T> responseForPart = this.getByIdRESTCall(userId, guid, methodName, type, urnTemplate, findRequest);
                this.exceptionHandler.detectAndThrowStandardExceptions(methodName, responseForPart);
                int numberRetrieved = responseForPart.results().size();
                if (numberRetrieved == 0) {
                    totalNumberRetrieved = requestedPageSize;
                    continue;
                }
                totalNumberRetrieved += numberRetrieved;
                if (completeResponse == null) {
                    completeResponse = responseForPart;
                } else {
                    completeResponse.addAllResults((Collection)responseForPart.results());
                }
                startingFrom += numberRetrieved;
            }
        }
        return completeResponse;
    }

    public <T> GenericResponse<T> deleteRESTCall(String userId, String guid, String methodName, ParameterizedTypeReference<GenericResponse<T>> type, String urnTemplate) throws PropertyServerException, UserNotAuthorizedException, InvalidParameterException {
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId=" + userId + ",guid=" + guid);
        }
        String expandedURL = String.format(this.serverPlatformURLRoot + urnTemplate, this.serverName, userId, guid);
        GenericResponse response = (GenericResponse)this.callDeleteRESTCall(methodName, type, expandedURL, new Object[0]);
        this.exceptionHandler.detectAndThrowStandardExceptions(methodName, (FFDCResponse)response);
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId=" + userId + ",guid=" + guid);
        }
        return response;
    }

    public <T> GenericResponse<T> restoreRESTCall(String userId, String guid, String methodName, ParameterizedTypeReference<GenericResponse<T>> type, String urnTemplate) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId=" + userId + ",guid=" + guid);
        }
        String expandedURL = String.format(this.serverPlatformURLRoot + urnTemplate, this.serverName, userId, guid);
        GenericResponse response = (GenericResponse)this.callPostRESTCall(methodName, type, expandedURL, null, new Object[0]);
        this.exceptionHandler.detectAndThrowStandardExceptions(methodName, (FFDCResponse)response);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : " + methodName + ",userId=" + userId);
        }
        return response;
    }

    public QueryBuilder createFindQuery(String methodName, FindRequest findRequest) throws InvalidParameterException {
        String property;
        QueryBuilder queryBuilder = new QueryBuilder();
        SequencingOrder sequencingOrder = findRequest.getSequencingOrder();
        if (sequencingOrder == null) {
            sequencingOrder = SequencingOrder.ANY;
        }
        String sequencingOrderName = QueryUtils.encodeParams(methodName, "sequencingOrder", sequencingOrder.name());
        queryBuilder.addParam("sequencingOrder", sequencingOrderName);
        Integer pageSize = findRequest.getPageSize();
        if (pageSize != null) {
            queryBuilder.addParam("pageSize", pageSize);
        }
        queryBuilder.addParam("startingFrom", findRequest.getStartingFrom());
        String searchCriteria = findRequest.getSearchCriteria();
        if (searchCriteria != null) {
            searchCriteria = QueryUtils.encodeParams(methodName, "searchCriteria", searchCriteria);
            queryBuilder.addParam("searchCriteria", searchCriteria);
        }
        if ((property = findRequest.getSequencingProperty()) != null) {
            property = QueryUtils.encodeParams(methodName, "sequencingProperty", property);
            queryBuilder.addParam("sequencingProperty", property);
        }
        return queryBuilder;
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getServerPlatformURLRoot() {
        return this.serverPlatformURLRoot;
    }
}

