/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.client.relationships;

import java.util.stream.Collectors;
import org.odpi.openmetadata.accessservices.subjectarea.client.Parametrization;
import org.odpi.openmetadata.accessservices.subjectarea.client.SubjectAreaRestClient;
import org.odpi.openmetadata.accessservices.subjectarea.client.relationships.SubjectAreaGraph;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.NeighborhoodHistoricalFindRequest;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Graph;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SubjectAreaOMASAPIResponse;
import org.odpi.openmetadata.accessservices.subjectarea.utils.QueryBuilder;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;

public class SubjectAreaGraphClient
implements SubjectAreaGraph,
Parametrization<Graph> {
    private static final String BASE_URL = "/servers/%s/open-metadata/access-services/subject-area/users/%s/nodes";
    protected final SubjectAreaRestClient client;

    public SubjectAreaGraphClient(SubjectAreaRestClient client) {
        this.client = client;
    }

    @Override
    public Class<Graph> type() {
        return Graph.class;
    }

    @Override
    public Graph getGraph(String userId, String guid, NeighborhoodHistoricalFindRequest request) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getGraph";
        String urlTemplate = "/servers/%s/open-metadata/access-services/subject-area/users/%s/nodes/%s" + this.createGraphQuery(request).toString();
        SubjectAreaOMASAPIResponse response = this.client.getByIdRESTCall(userId, guid, "getGraph", this.getParametrizedType(), urlTemplate);
        return (Graph)response.getHead();
    }

    public QueryBuilder createGraphQuery(NeighborhoodHistoricalFindRequest request) {
        QueryBuilder queryBuilder = new QueryBuilder();
        String nodeFilter = request.getNodeFilter().stream().map(Enum::name).collect(Collectors.joining(","));
        String lineFilter = request.getLineFilter().stream().map(Enum::name).collect(Collectors.joining(","));
        if (!nodeFilter.isEmpty()) {
            queryBuilder.addParam("nodeFilter", nodeFilter);
        }
        if (!lineFilter.isEmpty()) {
            queryBuilder.addParam("lineFilter", lineFilter);
        }
        return queryBuilder.addParam("asOfTime", request.getAsOfTime()).addParam("statusFilter", request.getStatusFilter().name()).addParam("level", request.getLevel());
    }
}

