/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.client;

import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.FindRequest;
import org.odpi.openmetadata.accessservices.subjectarea.utils.QueryBuilder;
import org.odpi.openmetadata.accessservices.subjectarea.utils.QueryUtils;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCRESTClient;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GenericResponse;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ParameterizedTypeReference;

public class SubjectAreaRestClient
extends FFDCRESTClient {
    private static final Logger log = LoggerFactory.getLogger(SubjectAreaRestClient.class);
    private final String serverName;
    private final String serverPlatformURLRoot;

    public SubjectAreaRestClient(String serverName, String serverPlatformURLRoot) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot);
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
    }

    public SubjectAreaRestClient(String serverName, String serverPlatformURLRoot, String userId, String password) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, userId, password);
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
    }

    public <T> GenericResponse<T> postRESTCall(String userId, String methodName, String urnTemplate, ParameterizedTypeReference<GenericResponse<T>> type, T requestBody) throws PropertyServerException, UserNotAuthorizedException, InvalidParameterException {
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId=" + userId);
        }
        String expandedURL = String.format(this.serverPlatformURLRoot + urnTemplate, this.serverName, userId);
        GenericResponse response = (GenericResponse)this.callPostRESTCall(methodName, type, expandedURL, requestBody, new Object[0]);
        this.exceptionHandler.detectAndThrowStandardExceptions(methodName, (FFDCResponse)response);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : " + methodName + ",userId=" + userId);
        }
        return response;
    }

    public <T> GenericResponse<T> putRESTCall(String userId, String guid, String methodName, String urnTemplate, ParameterizedTypeReference<GenericResponse<T>> type, T requestBody) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId=" + userId + ",guid=" + guid);
        }
        String expandedURL = String.format(this.serverPlatformURLRoot + urnTemplate, this.serverName, userId, guid);
        GenericResponse response = (GenericResponse)this.callPutRESTCall(methodName, type, expandedURL, requestBody, new Object[0]);
        this.exceptionHandler.detectAndThrowStandardExceptions(methodName, (FFDCResponse)response);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : " + methodName + ",userId=" + userId);
        }
        return response;
    }

    public <T> GenericResponse<T> getByIdRESTCall(String userId, String guid, String methodName, ParameterizedTypeReference<GenericResponse<T>> type, String urnTemplate) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId=" + userId + ",guid=" + guid);
        }
        String expandedURL = String.format(this.serverPlatformURLRoot + urnTemplate, this.serverName, userId, guid);
        GenericResponse response = (GenericResponse)this.callGetRESTCall(methodName, type, expandedURL, new Object[0]);
        this.exceptionHandler.detectAndThrowStandardExceptions(methodName, (FFDCResponse)response);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : " + methodName + ",userId=" + userId);
        }
        return response;
    }

    public <T> GenericResponse<T> findRESTCall(String userId, String methodName, String urnTemplate, ParameterizedTypeReference<GenericResponse<T>> type, FindRequest findRequest) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId=" + userId);
        }
        String findUrlTemplate = urnTemplate + this.createFindQuery(methodName, findRequest).toString();
        String expandedURL = String.format(this.serverPlatformURLRoot + findUrlTemplate, this.serverName, userId);
        GenericResponse response = (GenericResponse)this.callGetRESTCall(methodName, type, expandedURL, new Object[0]);
        this.exceptionHandler.detectAndThrowStandardExceptions(methodName, (FFDCResponse)response);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : " + methodName + ",userId=" + userId);
        }
        return response;
    }

    public <T> GenericResponse<T> findRESTCall(String userId, String guid, String methodName, String urnTemplate, ParameterizedTypeReference<GenericResponse<T>> type, FindRequest findRequest) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String findUrlTemplate = urnTemplate + this.createFindQuery(methodName, findRequest).toString();
        return this.getByIdRESTCall(userId, guid, methodName, type, findUrlTemplate);
    }

    public <T> GenericResponse<T> deleteRESTCall(String userId, String guid, String methodName, ParameterizedTypeReference<GenericResponse<T>> type, String urnTemplate) throws PropertyServerException, UserNotAuthorizedException, InvalidParameterException {
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId=" + userId + ",guid=" + guid);
        }
        String expandedURL = String.format(this.serverPlatformURLRoot + urnTemplate, this.serverName, userId, guid);
        GenericResponse response = (GenericResponse)this.callDeleteRESTCall(methodName, type, expandedURL, new Object[0]);
        this.exceptionHandler.detectAndThrowStandardExceptions(methodName, (FFDCResponse)response);
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId=" + userId + ",guid=" + guid);
        }
        return response;
    }

    public <T> GenericResponse<T> restoreRESTCall(String userId, String guid, String methodName, ParameterizedTypeReference<GenericResponse<T>> type, String urnTemplate) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId=" + userId + ",guid=" + guid);
        }
        String expandedURL = String.format(this.serverPlatformURLRoot + urnTemplate, this.serverName, userId, guid);
        GenericResponse response = (GenericResponse)this.callPostRESTCall(methodName, type, expandedURL, null, new Object[0]);
        this.exceptionHandler.detectAndThrowStandardExceptions(methodName, (FFDCResponse)response);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : " + methodName + ",userId=" + userId);
        }
        return response;
    }

    public QueryBuilder createFindQuery(String methodName, FindRequest findRequest) throws InvalidParameterException {
        SequencingOrder sequencingOrder;
        String property;
        String searchCriteria = findRequest.getSearchCriteria();
        if (searchCriteria != null) {
            searchCriteria = QueryUtils.encodeParams(methodName, "searchCriteria", searchCriteria);
        }
        if ((property = findRequest.getSequencingProperty()) != null) {
            property = QueryUtils.encodeParams(methodName, "sequencingProperty", property);
        }
        if ((sequencingOrder = findRequest.getSequencingOrder()) == null) {
            sequencingOrder = SequencingOrder.ANY;
        }
        return new QueryBuilder().addParam("sequencingOrder", sequencingOrder.name()).addParam("asOfTime", findRequest.getAsOfTime()).addParam("searchCriteria", searchCriteria).addParam("offset", findRequest.getOffset()).addParam("pageSize", findRequest.getPageSize()).addParam("sequencingProperty", property);
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getServerPlatformURLRoot() {
        return this.serverPlatformURLRoot;
    }
}

