/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.client;

import org.odpi.openmetadata.accessservices.subjectarea.SubjectArea;
import org.odpi.openmetadata.accessservices.subjectarea.client.SubjectAreaRestClient;
import org.odpi.openmetadata.accessservices.subjectarea.client.nodes.DefaultSubjectAreaNodeClients;
import org.odpi.openmetadata.accessservices.subjectarea.client.nodes.SubjectAreaNodeClients;
import org.odpi.openmetadata.accessservices.subjectarea.client.relationships.SubjectAreaGraph;
import org.odpi.openmetadata.accessservices.subjectarea.client.relationships.SubjectAreaGraphClient;
import org.odpi.openmetadata.accessservices.subjectarea.client.relationships.SubjectAreaLine;
import org.odpi.openmetadata.accessservices.subjectarea.client.relationships.SubjectAreaRelationshipClients;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.SubjectAreaErrorCode;
import org.odpi.openmetadata.accessservices.subjectarea.validators.InputValidator;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.ExceptionMessageDefinition;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;

public class SubjectAreaImpl
implements SubjectArea {
    private static final String className = SubjectAreaImpl.class.getName();
    private final SubjectAreaNodeClients nodeClients;
    private final SubjectAreaRelationshipClients relationshipAPI;
    private final SubjectAreaGraph graphAPI;
    private final String serverName;
    private final String omasServerUrl;

    public SubjectAreaImpl(String serverName, String omasServerURL) throws org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.InvalidParameterException {
        String methodName = "SubjectAreaImpl";
        InputValidator.validateRemoteServerNameNotNull((String)className, (String)methodName, (String)serverName);
        InputValidator.validateRemoteServerURLNotNull((String)className, (String)methodName, (String)omasServerURL);
        try {
            SubjectAreaRestClient client = new SubjectAreaRestClient(serverName, omasServerURL);
            DefaultSubjectAreaNodeClients subjectAreaNode = new DefaultSubjectAreaNodeClients(client);
            SubjectAreaLine subjectAreaLine = new SubjectAreaLine(client);
            SubjectAreaGraphClient subjectAreaGraph = new SubjectAreaGraphClient(client);
            this.nodeClients = subjectAreaNode;
            this.relationshipAPI = subjectAreaLine;
            this.graphAPI = subjectAreaGraph;
        }
        catch (InvalidParameterException e) {
            String parameterName = "serverName or omasServerURL";
            String parameterValue = "unknown";
            if (serverName == null || "".equals(serverName)) {
                parameterName = "serverName";
                parameterValue = serverName;
            }
            if (omasServerURL == null || "".equals(omasServerURL)) {
                parameterName = "omasServerURL";
                parameterValue = omasServerURL;
            }
            ExceptionMessageDefinition messageDefinition = SubjectAreaErrorCode.SUBJECT_AREA_FAILED_TO_INITIALISE.getMessageDefinition();
            messageDefinition.setMessageParameters(new String[]{parameterName, parameterValue});
            throw new org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.InvalidParameterException(messageDefinition, className, methodName, (Throwable)e, parameterName, parameterValue);
        }
        this.serverName = serverName;
        this.omasServerUrl = omasServerURL;
    }

    @Override
    public SubjectAreaNodeClients nodeClients() {
        return this.nodeClients;
    }

    @Override
    public SubjectAreaRelationshipClients relationshipClients() {
        return this.relationshipAPI;
    }

    @Override
    public SubjectAreaGraph subjectAreaGraph() {
        return this.graphAPI;
    }

    @Override
    public String serverName() {
        return this.serverName;
    }

    @Override
    public String omasServerUrl() {
        return this.omasServerUrl;
    }
}

