/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.client.nodes.glossaries;

import java.lang.reflect.Type;
import java.util.List;
import org.odpi.openmetadata.accessservices.subjectarea.client.SubjectAreaRestClient;
import org.odpi.openmetadata.accessservices.subjectarea.client.nodes.AbstractSubjectAreaNode;
import org.odpi.openmetadata.accessservices.subjectarea.client.nodes.SubjectAreaNodeClient;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.category.Category;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.FindRequest;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.glossary.Glossary;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.term.Term;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SubjectAreaOMASAPIResponse;
import org.odpi.openmetadata.accessservices.subjectarea.utils.QueryBuilder;
import org.odpi.openmetadata.commonservices.ffdc.rest.GenericResponse;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.ResolvableType;

@SubjectAreaNodeClient
public class SubjectAreaGlossaryClient<G extends Glossary>
extends AbstractSubjectAreaNode<G> {
    public SubjectAreaGlossaryClient(SubjectAreaRestClient client) {
        super(client, "/servers/%s/open-metadata/access-services/subject-area/users/%s/glossaries");
    }

    public List<Category> getCategories(String userId, String guid, FindRequest findRequest, Boolean onlyTop) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String urnTemplate = this.BASE_URL + "/%s/categories";
        String methodInfo = this.getMethodInfo("getCategories");
        QueryBuilder query = this.client.createFindQuery(methodInfo, findRequest);
        query.addParam("onlyTop", onlyTop);
        String urlTemplate = urnTemplate + query.toString();
        ResolvableType resolvableType = ResolvableType.forClassWithGenerics(SubjectAreaOMASAPIResponse.class, (Class[])new Class[]{Category.class});
        ParameterizedTypeReference type = ParameterizedTypeReference.forType((Type)resolvableType.getType());
        GenericResponse response = this.client.getByIdRESTCall(userId, guid, methodInfo, type, urlTemplate);
        return response.results();
    }

    public List<Term> getTerms(String userId, String guid, FindRequest findRequest) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodInfo = this.getMethodInfo("getTerms");
        String urlTemplate = this.BASE_URL + "/%s/terms" + this.client.createFindQuery(methodInfo, findRequest).toString();
        ResolvableType resolvableType = ResolvableType.forClassWithGenerics(SubjectAreaOMASAPIResponse.class, (Class[])new Class[]{Term.class});
        ParameterizedTypeReference type = ParameterizedTypeReference.forType((Type)resolvableType.getType());
        GenericResponse response = this.client.getByIdRESTCall(userId, guid, methodInfo, type, urlTemplate);
        return response.results();
    }
}

