/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.client.nodes;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.odpi.openmetadata.accessservices.subjectarea.client.SubjectAreaNodeClient;
import org.odpi.openmetadata.accessservices.subjectarea.client.SubjectAreaRestClient;
import org.odpi.openmetadata.accessservices.subjectarea.client.nodes.AbstractSubjectAreaNode;
import org.odpi.openmetadata.accessservices.subjectarea.client.nodes.SubjectAreaNodeClients;
import org.odpi.openmetadata.accessservices.subjectarea.client.nodes.projects.SubjectAreaProjectClient;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.SubjectAreaErrorCode;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.SubjectAreaCheckedException;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.category.Category;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.glossary.Glossary;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Node;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.project.Project;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.term.Term;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.ExceptionMessageDefinition;
import org.reflections.Reflections;

public class DefaultSubjectAreaNodeClients
implements SubjectAreaNodeClients {
    private final Map<Class<?>, SubjectAreaNodeClient<?>> cache = new HashMap();
    private static final String DEFAULT_SCAN_PACKAGE = DefaultSubjectAreaNodeClients.class.getPackage().getName();

    public DefaultSubjectAreaNodeClients(SubjectAreaRestClient subjectAreaRestClient, String ... packagesToScan) {
        HashSet<String> packages = new HashSet<String>(Arrays.asList(packagesToScan));
        packages.add(DEFAULT_SCAN_PACKAGE);
        Reflections reflections = new Reflections(new Object[]{packages});
        Set clientClasses = reflections.getTypesAnnotatedWith(org.odpi.openmetadata.accessservices.subjectarea.client.nodes.SubjectAreaNodeClient.class);
        for (Class declaredClass : clientClasses) {
            try {
                if (!AbstractSubjectAreaNode.class.isAssignableFrom(declaredClass)) continue;
                Constructor ctor = declaredClass.getDeclaredConstructor(SubjectAreaRestClient.class);
                ctor.setAccessible(true);
                AbstractSubjectAreaNode newInstance = (AbstractSubjectAreaNode)ctor.newInstance(new Object[]{subjectAreaRestClient});
                this.cache.put(newInstance.resultType(), newInstance);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new ExceptionInInitializerError("During initialization `DefaultSubjectAreaNodeClients` an error has occurred - " + e.getMessage());
            }
        }
    }

    public DefaultSubjectAreaNodeClients(SubjectAreaRestClient subjectAreaRestClient) {
        this(subjectAreaRestClient, DEFAULT_SCAN_PACKAGE);
    }

    @Override
    public <G extends Glossary> SubjectAreaNodeClient<G> glossaries() {
        return this.getClient(Glossary.class);
    }

    @Override
    public <T extends Term> SubjectAreaNodeClient<T> terms() {
        return this.getClient(Term.class);
    }

    @Override
    public <C extends Category> SubjectAreaNodeClient<C> categories() {
        return this.getClient(Category.class);
    }

    public <P extends Project> SubjectAreaProjectClient<P> projects() {
        return (SubjectAreaProjectClient)this.getClient(Project.class);
    }

    public <T extends Node> SubjectAreaNodeClient<T> getClient(Class<T> clazz) {
        if (this.cache.containsKey(clazz)) {
            return this.cache.get(clazz);
        }
        ExceptionMessageDefinition messageDefinition = SubjectAreaErrorCode.NOT_FOUND_CLIENT.getMessageDefinition(new String[]{clazz.getName()});
        SubjectAreaCheckedException exc = new SubjectAreaCheckedException(messageDefinition, this.getClass().getName(), messageDefinition.getSystemAction());
        throw new IllegalArgumentException((Throwable)exc);
    }
}

